/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import java.io.IOException;
import java.util.TimeZone;
import org.json.JSONException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class Bug36943Test
extends AbstractAJAXSession {
    private AJAXClient client1;
    private TimeZone timeZone;
    private Task task;

    public Bug36943Test(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.timeZone = this.client1.getValues().getTimeZone();
        this.task = new Task();
        this.task.setParentFolderID(this.client1.getValues().getPrivateTaskFolder());
        this.task.setTitle("Test for bug 36943");
        this.task.setNote("Pile of \ud83d\udca9 poo");
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        if (this.task.containsObjectID()) {
            this.client1.execute(new DeleteRequest(this.task));
        }
        super.tearDown();
    }

    @Test
    public void testForPileOfPoo() throws OXException, IOException, JSONException {
        InsertResponse response = this.client1.execute(new InsertRequest(this.task, this.timeZone, false));
        if (!response.hasError()) {
            response.fillTask(this.task);
        }
        Bug36943Test.assertTrue((String)"Creating a task with pile of \ud83d\udca9 poo may have an error.", (boolean)response.hasError());
        Bug36943Test.assertTrue((String)"Expected exception for wrong characters.", (boolean)TaskExceptionCode.INCORRECT_STRING.create().similarTo(response.getException()));
    }
}

