/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.session.actions.AbstractRequest;
import com.openexchange.ajax.session.actions.LoginResponse;
import com.openexchange.ajax.session.actions.LoginResponseParser;

public class LoginRequest
extends AbstractRequest<LoginResponse> {
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_TOKEN = "token";
    private static final String PARAM_SECRET = "secret";
    private final boolean failOnError;

    public LoginRequest(TokenLoginParameters parameters, boolean failOnError) {
        super(new AJAXRequest.Parameter[]{new AJAXRequest.URLParameter("action", "redeemToken"), new AJAXRequest.URLParameter("authId", parameters.getAuthId()), new AJAXRequest.URLParameter("client", parameters.getClient()), new AJAXRequest.URLParameter("version", parameters.getVersion()), new AJAXRequest.FieldParameter(PARAM_TOKEN, parameters.getToken()), new AJAXRequest.FieldParameter(PARAM_SECRET, parameters.getSecret())});
        this.failOnError = failOnError;
    }

    public LoginRequest(TokenLoginParameters parameters) {
        this(parameters, true);
    }

    public LoginRequest(String login, String password, String authId, String client, String version) {
        this(login, password, authId, client, version, true);
    }

    public LoginRequest(String login, String password, String authId, String client, String version, boolean failOnError) {
        super(new AJAXRequest.Parameter[]{new AJAXRequest.URLParameter("action", "login"), new AJAXRequest.URLParameter("authId", authId), new AJAXRequest.URLParameter("client", client), new AJAXRequest.URLParameter("version", version), new AJAXRequest.FieldParameter(PARAM_NAME, login), new AJAXRequest.FieldParameter(PARAM_PASSWORD, password)});
        this.failOnError = failOnError;
    }

    public LoginResponseParser getParser() {
        return new LoginResponseParser(this.failOnError);
    }

    public static class TokenLoginParameters {
        String token;
        String secret;
        String authId;
        String client;
        String version;

        public TokenLoginParameters(String token, String secret, String authId, String client, String version) {
            this.token = token;
            this.secret = secret;
            this.authId = authId;
            this.client = client;
            this.version = version;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public String getAuthId() {
            return this.authId;
        }

        public void setAuthId(String authId) {
            this.authId = authId;
        }

        public String getClient() {
            return this.client;
        }

        public void setClient(String client) {
            this.client = client;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

