/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.session.actions.AbstractRequest;
import com.openexchange.ajax.session.actions.HttpAuthParser;
import com.openexchange.ajax.session.actions.HttpAuthResponse;
import com.openexchange.tools.encoding.Base64;

public class HttpAuthRequest
extends AbstractRequest<HttpAuthResponse> {
    public static final String HTTP_AUTH_URL = "/ajax/login/httpAuth";
    final String login;
    final String password;

    public HttpAuthRequest(String login, String password) {
        super(new AJAXRequest.Parameter[0]);
        this.login = login;
        this.password = password;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public String getServletPath() {
        return HTTP_AUTH_URL;
    }

    @Override
    public Header[] getHeaders() {
        return new Header[]{new Header(){

            @Override
            public String getName() {
                return "Authorization";
            }

            @Override
            public String getValue() {
                return "Basic " + Base64.encode((String)(HttpAuthRequest.this.login + ':' + HttpAuthRequest.this.password));
            }
        }};
    }

    public HttpAuthParser getParser() {
        return new HttpAuthParser();
    }
}

