/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.netsol.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.HeaderCollection;
import com.openexchange.mail.mime.PlainTextAddress;
import com.openexchange.mail.mime.dataobjects.MimeMailMessage;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NetsolGetResponse
extends AbstractAJAXResponse {
    private MailMessage mail;
    private static final InternetAddress[] EMPTY_ADDRS = new InternetAddress[0];

    public NetsolGetResponse(Response response) {
        super(response);
    }

    public MailMessage getMail(TimeZone timeZone) throws JSONException, OXException {
        if (null == this.mail) {
            MimeMailMessage parsed = new MimeMailMessage();
            JSONObject jsonObject = this.getData() instanceof JSONObject ? (JSONObject)this.getData() : new JSONObject(this.getData().toString());
            NetsolGetResponse.parse(jsonObject, (MailMessage)parsed, timeZone);
            this.mail = parsed;
        }
        return this.mail;
    }

    private static void parse(JSONObject jsonObj, MailMessage mail, TimeZone timeZone) throws OXException {
        try {
            Date date;
            if (jsonObj.has(MailJSONField.FLAGS.getKey()) && !jsonObj.isNull(MailJSONField.FLAGS.getKey())) {
                mail.setFlags(jsonObj.getInt(MailJSONField.FLAGS.getKey()));
            }
            if (jsonObj.has(MailJSONField.THREAD_LEVEL.getKey()) && !jsonObj.isNull(MailJSONField.THREAD_LEVEL.getKey())) {
                mail.setThreadLevel(jsonObj.getInt(MailJSONField.THREAD_LEVEL.getKey()));
            }
            if (jsonObj.has(MailJSONField.USER.getKey()) && !jsonObj.isNull(MailJSONField.USER.getKey())) {
                JSONArray arr = jsonObj.getJSONArray(MailJSONField.USER.getKey());
                int length = arr.length();
                ArrayList<String> l = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    l.add(arr.getString(i));
                }
                mail.addUserFlags(l.toArray(new String[l.size()]));
            }
            if (jsonObj.has(MailJSONField.HEADERS.getKey()) && !jsonObj.isNull(MailJSONField.HEADERS.getKey())) {
                JSONObject obj = jsonObj.getJSONObject(MailJSONField.HEADERS.getKey());
                int size = obj.length();
                HeaderCollection headers = new HeaderCollection(size);
                Iterator iter = obj.keys();
                for (int i = 0; i < size; ++i) {
                    String key = (String)iter.next();
                    headers.addHeader(key, obj.getString(key));
                }
                mail.addHeaders(headers);
            }
            mail.addFrom(NetsolGetResponse.parseAddressKey(MailJSONField.FROM.getKey(), jsonObj));
            mail.addTo(NetsolGetResponse.parseAddressKey(MailJSONField.RECIPIENT_TO.getKey(), jsonObj));
            mail.addCc(NetsolGetResponse.parseAddressKey(MailJSONField.RECIPIENT_CC.getKey(), jsonObj));
            mail.addBcc(NetsolGetResponse.parseAddressKey(MailJSONField.RECIPIENT_BCC.getKey(), jsonObj));
            if (jsonObj.has(MailJSONField.DISPOSITION_NOTIFICATION_TO.getKey()) && !jsonObj.isNull(MailJSONField.DISPOSITION_NOTIFICATION_TO.getKey())) {
                String dispVal = jsonObj.getString(MailJSONField.DISPOSITION_NOTIFICATION_TO.getKey());
                if ("true".equalsIgnoreCase(dispVal)) {
                    mail.setDispositionNotification(mail.getFrom().length > 0 ? mail.getFrom()[0] : null);
                } else {
                    InternetAddress ia = NetsolGetResponse.getEmailAddress(dispVal);
                    if (ia == null) {
                        mail.setDispositionNotification(null);
                    } else {
                        mail.setDispositionNotification(ia);
                    }
                }
            }
            if (jsonObj.has(MailJSONField.PRIORITY.getKey()) && !jsonObj.isNull(MailJSONField.PRIORITY.getKey())) {
                mail.setPriority(jsonObj.getInt(MailJSONField.PRIORITY.getKey()));
            }
            if (jsonObj.has(MailJSONField.COLOR_LABEL.getKey()) && !jsonObj.isNull(MailJSONField.COLOR_LABEL.getKey())) {
                mail.setColorLabel(jsonObj.getInt(MailJSONField.COLOR_LABEL.getKey()));
            }
            if (jsonObj.has(MailJSONField.VCARD.getKey()) && !jsonObj.isNull(MailJSONField.VCARD.getKey())) {
                mail.setAppendVCard(jsonObj.getInt(MailJSONField.VCARD.getKey()) > 0);
            }
            if (jsonObj.has(MailJSONField.MSGREF.getKey()) && !jsonObj.isNull(MailJSONField.MSGREF.getKey())) {
                mail.setMsgref(new MailPath(jsonObj.getString(MailJSONField.MSGREF.getKey())));
            }
            if (jsonObj.has(MailJSONField.SUBJECT.getKey()) && !jsonObj.isNull(MailJSONField.SUBJECT.getKey())) {
                mail.setSubject(jsonObj.getString(MailJSONField.SUBJECT.getKey()));
            }
            if (jsonObj.has(MailJSONField.SIZE.getKey())) {
                mail.setSize((long)jsonObj.getInt(MailJSONField.SIZE.getKey()));
            }
            if (jsonObj.has(MailJSONField.SENT_DATE.getKey()) && !jsonObj.isNull(MailJSONField.SENT_DATE.getKey())) {
                date = new Date(jsonObj.getLong(MailJSONField.SENT_DATE.getKey()));
                int offset = timeZone.getOffset(date.getTime());
                mail.setSentDate(new Date(jsonObj.getLong(MailJSONField.SENT_DATE.getKey()) - (long)offset));
            }
            if (jsonObj.has(MailJSONField.RECEIVED_DATE.getKey()) && !jsonObj.isNull(MailJSONField.RECEIVED_DATE.getKey())) {
                date = new Date(jsonObj.getLong(MailJSONField.RECEIVED_DATE.getKey()));
                int offset = timeZone.getOffset(date.getTime());
                mail.setReceivedDate(new Date(jsonObj.getLong(MailJSONField.RECEIVED_DATE.getKey()) - (long)offset));
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create();
        }
    }

    private static InternetAddress getEmailAddress(String addrStr) {
        if (addrStr == null || addrStr.length() == 0) {
            return null;
        }
        try {
            return InternetAddress.parse((String)addrStr, (boolean)true)[0];
        }
        catch (AddressException e) {
            return null;
        }
    }

    private static InternetAddress[] parseAddressKey(String key, JSONObject jo) throws JSONException {
        String value = null;
        if (!jo.has(key) || jo.isNull(key) || (value = jo.getString(key)).length() == 0) {
            return EMPTY_ADDRS;
        }
        if (value.charAt(0) == '[') {
            boolean hasPersonal;
            JSONArray outer = new JSONArray(value);
            int l1 = outer.length();
            if (l1 == 0) {
                return EMPTY_ADDRS;
            }
            StringBuilder sb = new StringBuilder(l1 * 64);
            JSONArray persAndAddr = outer.getJSONArray(0);
            String personal = persAndAddr.getString(0);
            boolean bl = hasPersonal = personal != null && !"null".equals(personal);
            if (hasPersonal) {
                sb.append(MimeMessageUtility.quotePersonal((String)personal)).append(" <");
            }
            sb.append(persAndAddr.getString(1));
            if (hasPersonal) {
                sb.append('>');
            }
            for (int i = 1; i < l1; ++i) {
                boolean hasPersonal2;
                sb.append(", ");
                JSONArray persAndAddr2 = outer.getJSONArray(i);
                String personal2 = persAndAddr2.getString(0);
                boolean bl2 = hasPersonal2 = personal2 != null && !"null".equals(personal2);
                if (hasPersonal2) {
                    sb.append(MimeMessageUtility.quotePersonal((String)personal2)).append(" <");
                }
                sb.append(persAndAddr2.getString(1));
                if (!hasPersonal2) continue;
                sb.append('>');
            }
            value = sb.toString();
        }
        try {
            return InternetAddress.parse((String)value, (boolean)false);
        }
        catch (AddressException e) {
            return new InternetAddress[]{new PlainTextAddress(value)};
        }
    }
}

