/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.api2;

import com.openexchange.ajax.folder.FolderTools;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.FolderTestManager;

public class Bug17261Test
extends AbstractAJAXSession {
    private AJAXClient client2;
    private FolderObject folder;
    private FolderObject secondFolder;
    private FolderTestManager ftm1;
    private FolderTestManager ftm2;
    private String folderName;

    public Bug17261Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.folderName = "Bug17621 Folder" + System.currentTimeMillis();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.ftm1 = new FolderTestManager(this.client);
        this.folder = this.ftm1.generatePublicFolder(this.folderName, 3, 1, this.client.getValues().getUserId());
        InsertRequest insertFolderReq = new InsertRequest(EnumAPI.OUTLOOK, this.folder, false);
        InsertResponse insertFolderResp = this.client.execute(insertFolderReq);
        Bug17261Test.assertNull((String)"Inserting folder caused exception.", (Object)((Object)insertFolderResp.getException()));
        insertFolderResp.fillObject((DataObject)this.folder);
    }

    public void testInsertingFolderWithSameNameFromSecondUser() throws Exception {
        this.ftm2 = new FolderTestManager(this.client2);
        this.secondFolder = this.ftm2.generatePublicFolder(this.folderName, 3, 1, this.client2.getValues().getUserId());
        InsertRequest insertSecondFolderReq = new InsertRequest(EnumAPI.OUTLOOK, this.secondFolder, false);
        InsertResponse insertSecondFolderResp = this.client2.execute(insertSecondFolderReq);
        Bug17261Test.assertNull((String)"Inserting second folder caused exception.", (Object)((Object)insertSecondFolderResp.getException()));
        insertSecondFolderResp.fillObject((DataObject)this.secondFolder);
        this.ftm2.deleteFolderOnServer(this.secondFolder);
    }

    public void testMakeFirstFolderVisibleAndTryAgain() throws Exception {
        FolderTools.shareFolder(this.client, EnumAPI.OUTLOOK, this.folder.getObjectID(), this.client2.getValues().getUserId(), 2, 4, 0, 0);
        this.ftm2 = new FolderTestManager(this.client2);
        this.secondFolder = this.ftm2.generatePublicFolder(this.folderName, 3, 1, this.client2.getValues().getUserId());
        InsertRequest insertSecondFolderReq = new InsertRequest(EnumAPI.OUTLOOK, this.secondFolder, false);
        InsertResponse insertSecondFolderResp = this.client2.execute(insertSecondFolderReq);
        Bug17261Test.assertNull((String)"Inserting second folder should not cause an exception.", (Object)((Object)insertSecondFolderResp.getException()));
        insertSecondFolderResp.fillObject((DataObject)this.secondFolder);
        this.ftm2.deleteFolderOnServer(this.secondFolder);
    }

    public void testInsertingFolderCauseException() throws Exception {
        this.secondFolder = this.ftm1.generatePublicFolder(this.folderName, 3, 1, this.client.getValues().getUserId());
        InsertRequest insertSecondFolderReq = new InsertRequest(EnumAPI.OUTLOOK, this.secondFolder, false);
        InsertResponse insertSecondFolderResp = this.client2.execute(insertSecondFolderReq);
        Bug17261Test.assertNotNull((String)"Inserting second folder should cause an exception.", (Object)((Object)insertSecondFolderResp.getException()));
        insertSecondFolderResp.fillObject((DataObject)this.secondFolder);
        if (this.secondFolder.getObjectID() > 0) {
            this.ftm1.deleteFolderOnServer(this.secondFolder);
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.ftm1.deleteFolderOnServer(this.folder);
        this.client2.logout();
        super.tearDown();
    }
}

