/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.folder.actions.FolderUpdatesResponse;
import com.openexchange.ajax.framework.CommonUpdatesParser;
import com.openexchange.ajax.parser.FolderParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.fixtures.transformators.FolderModuleTransformator;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FolderUpdatesParser
extends CommonUpdatesParser<FolderUpdatesResponse> {
    protected FolderUpdatesParser(boolean failOnError, int[] columns) {
        super(failOnError, columns);
    }

    @Override
    protected FolderUpdatesResponse createResponse(Response response) throws JSONException {
        FolderUpdatesResponse folderUpdateResponse = (FolderUpdatesResponse)super.createResponse(response);
        JSONArray rows = (JSONArray)response.getData();
        if (rows == null) {
            return folderUpdateResponse;
        }
        int size = rows.length();
        for (int i = 0; i < size; ++i) {
            Object arrayOrId = rows.get(i);
            FolderObject folder = new FolderObject();
            if (arrayOrId instanceof String || !(arrayOrId instanceof JSONArray)) continue;
            JSONArray row = (JSONArray)arrayOrId;
            for (int colIndex = 0; colIndex < this.getColumns().length; ++colIndex) {
                int column;
                Object value = row.get(colIndex);
                if (value == JSONObject.NULL || this.getsIgnored(column = this.getColumns()[colIndex])) continue;
                value = this.transform(value, column);
                if (1 == column) {
                    if (value instanceof Integer) {
                        folder.setObjectID(((Integer)value).intValue());
                        continue;
                    }
                    String svalue = (String)value;
                    try {
                        folder.setObjectID(Integer.parseInt(svalue));
                    }
                    catch (NumberFormatException e) {
                        folder.setFullName(svalue);
                    }
                    continue;
                }
                folder.set(column, value);
            }
            folderUpdateResponse.addFolder(folder);
        }
        return folderUpdateResponse;
    }

    public boolean getsIgnored(int column) {
        return column == 6 || column == 305 || column == 307 || column == 308 || column == 309 || column == 310 || column == 311 || column == 312 || column == 313 || column == 314 || column == 315 || column > 1000;
    }

    @Override
    protected FolderUpdatesResponse instantiateResponse(Response response) {
        return new FolderUpdatesResponse(response);
    }

    public Object transform(Object actual, int column) throws JSONException {
        switch (column) {
            case 4: 
            case 5: {
                return new Date((Long)actual);
            }
            case 301: {
                FolderModuleTransformator trafo = new FolderModuleTransformator();
                try {
                    return trafo.transform((String)actual);
                }
                catch (OXException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            case 306: {
                FolderParser parser = new FolderParser();
                try {
                    return parser.parseOCLPermission((JSONArray)actual, null);
                }
                catch (OXException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return actual;
    }
}

