/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.AbstractObjectCountTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.CalendarTestManager;
import com.openexchange.test.FolderTestManager;
import java.util.UUID;
import org.junit.Before;
import org.junit.Test;

public class AppointmentObjectCountTest
extends AbstractObjectCountTest {
    private FolderTestManager ftm;
    private CalendarTestManager ctm1;
    private CalendarTestManager ctm2;

    public AppointmentObjectCountTest(String name) {
        super(name);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ftm = new FolderTestManager(this.client1);
        this.ctm1 = new CalendarTestManager(this.client1);
        this.ctm2 = new CalendarTestManager(this.client2);
    }

    @Test
    public void testPrivate() throws Exception {
        int initialValue = this.getCount(this.client2);
        FolderObject folder = AppointmentObjectCountTest.createPrivateFolder(this.client1, this.ftm, 2);
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)0, (int)this.getCount(this.client1, folder));
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)initialValue, (int)this.getCount(this.client2));
        this.insertAppointments(this.ctm1, folder);
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)3, (int)this.getCount(this.client1, folder));
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)(initialValue + 3), (int)this.getCount(this.client2));
    }

    @Test
    public void testPublicReadOwn() throws Exception {
        FolderObject folder = this.createPublic(this.readOwnPermission());
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)0, (int)this.getCount(this.client1, folder));
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)0, (int)this.getCount(this.client2, folder));
        this.insertAppointments(this.ctm1, folder);
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)3, (int)this.getCount(this.client1, folder));
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)0, (int)this.getCount(this.client2, folder));
        this.insertAppointments(this.ctm2, folder);
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)6, (int)this.getCount(this.client1, folder));
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)3, (int)this.getCount(this.client2, folder));
    }

    @Test
    public void testPublicReadAll() throws Exception {
        FolderObject folder = this.createPublic(this.readAllPermission());
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)0, (int)this.getCount(this.client1, folder));
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)0, (int)this.getCount(this.client2, folder));
        this.insertAppointments(this.ctm1, folder);
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)3, (int)this.getCount(this.client1, folder));
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)3, (int)this.getCount(this.client2, folder));
        this.insertAppointments(this.ctm2, folder);
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)6, (int)this.getCount(this.client1, folder));
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)6, (int)this.getCount(this.client2, folder));
    }

    @Test
    public void testSharedReadOwn() throws Exception {
        FolderObject folder = this.createShared(this.readOwnPermission());
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)0, (int)this.getCount(this.client1, folder));
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)0, (int)this.getCount(this.client2, folder));
        this.insertAppointments(this.ctm1, folder);
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)3, (int)this.getCount(this.client1, folder));
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)0, (int)this.getCount(this.client2, folder));
        this.insertAppointments(this.ctm2, folder);
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)6, (int)this.getCount(this.client1, folder));
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)0, (int)this.getCount(this.client2, folder));
    }

    @Test
    public void testSharedReadAll() throws Exception {
        FolderObject folder = this.createShared(this.readAllPermission());
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)0, (int)this.getCount(this.client1, folder));
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)0, (int)this.getCount(this.client2, folder));
        this.insertAppointments(this.ctm1, folder);
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)3, (int)this.getCount(this.client1, folder));
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)3, (int)this.getCount(this.client2, folder));
        this.insertAppointments(this.ctm2, folder);
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)6, (int)this.getCount(this.client1, folder));
        AppointmentObjectCountTest.assertEquals((String)"Wrong amount.", (int)6, (int)this.getCount(this.client2, folder));
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm1.cleanUp();
        this.ctm2.cleanUp();
        this.ftm.cleanUp();
        super.tearDown();
    }

    private void insertAppointments(CalendarTestManager ctm, FolderObject folder) throws Exception {
        Appointment single = new Appointment();
        single.setTitle("Single Appoinment " + System.currentTimeMillis());
        single.setStartDate(TimeTools.D("01.05.2013 08:00"));
        single.setEndDate(TimeTools.D("01.05.2013 09:00"));
        single.setUsers(new UserParticipant[]{new UserParticipant(this.client1.getValues().getUserId()), new UserParticipant(this.client2.getValues().getUserId())});
        single.setParticipants(new Participant[]{new UserParticipant(this.client1.getValues().getUserId()), new UserParticipant(this.client2.getValues().getUserId())});
        single.setIgnoreConflicts(true);
        single.setParentFolderID(folder.getObjectID());
        ctm.insert(single);
        Appointment series = new Appointment();
        series.setTitle("Single Appoinment " + System.currentTimeMillis());
        series.setStartDate(TimeTools.D("01.05.2013 08:00"));
        series.setEndDate(TimeTools.D("01.05.2013 09:00"));
        series.setRecurrenceType(1);
        series.setInterval(1);
        series.setOccurrence(5);
        series.setUsers(new UserParticipant[]{new UserParticipant(this.client1.getValues().getUserId()), new UserParticipant(this.client2.getValues().getUserId())});
        series.setParticipants(new Participant[]{new UserParticipant(this.client1.getValues().getUserId()), new UserParticipant(this.client2.getValues().getUserId())});
        series.setIgnoreConflicts(true);
        series.setParentFolderID(folder.getObjectID());
        ctm.insert(series);
        Appointment exception = ctm.createIdentifyingCopy(series);
        exception.setIgnoreConflicts(true);
        exception.setRecurrencePosition(3);
        exception.setStartDate(TimeTools.D("01.05.2013 08:30"));
        exception.setEndDate(TimeTools.D("01.05.2013 09:30"));
        ctm.update(exception);
    }

    private int getCount(AJAXClient client) throws Exception {
        return AppointmentObjectCountTest.getFolder(client, client.getValues().getPrivateAppointmentFolder(), DEFAULT_COLUMNS).getTotal();
    }

    private int getCount(AJAXClient client, FolderObject folder) throws Exception {
        return AppointmentObjectCountTest.getFolder(client, folder.getObjectID(), DEFAULT_COLUMNS).getTotal();
    }

    private FolderObject createPublic(OCLPermission permission) throws Exception {
        FolderObject folder = this.ftm.generatePublicFolder(UUID.randomUUID().toString(), 2, 2, this.client1.getValues().getUserId());
        folder.addPermission(permission);
        return this.ftm.insertFolderOnServer(folder);
    }

    private FolderObject createShared(OCLPermission permission) throws Exception {
        FolderObject folder = this.ftm.generatePublicFolder(UUID.randomUUID().toString(), 2, this.client1.getValues().getPrivateAppointmentFolder(), this.client1.getValues().getUserId());
        folder.addPermission(permission);
        return this.ftm.insertFolderOnServer(folder);
    }

    private OCLPermission readOwnPermission() throws Exception {
        OCLPermission permission = new OCLPermission();
        permission.setEntity(this.client2.getValues().getUserId());
        permission.setGroupPermission(false);
        permission.setFolderAdmin(false);
        permission.setAllPermission(4, 2, 4, 4);
        return permission;
    }

    private OCLPermission readAllPermission() throws Exception {
        OCLPermission permission = new OCLPermission();
        permission.setEntity(this.client2.getValues().getUserId());
        permission.setGroupPermission(false);
        permission.setFolderAdmin(false);
        permission.setAllPermission(4, 4, 4, 4);
        return permission;
    }
}

