/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import java.util.Date;

public class Bug19489Test
extends AbstractAJAXSession {
    private Appointment appointment;
    private Appointment updateAppointment;

    public Bug19489Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.appointment = new Appointment();
        this.appointment.setStartDate(TimeTools.D("01.07.2011 08:00"));
        this.appointment.setEndDate(TimeTools.D("01.07.2011 09:00"));
        this.appointment.setRecurrenceType(2);
        this.appointment.setDays(32);
        this.appointment.setInterval(1);
        this.appointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.appointment.setTitle("Bug 19489 Test");
        this.appointment.setIgnoreConflicts(true);
        InsertRequest insertRequest = new InsertRequest(this.appointment, this.getClient().getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.getClient().execute(insertRequest);
        insertResponse.fillAppointment(this.appointment);
        this.updateAppointment = new Appointment();
        this.updateAppointment.setObjectID(this.appointment.getObjectID());
        this.updateAppointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.updateAppointment.setFullTime(false);
        this.updateAppointment.setRecurrenceType(0);
        this.updateAppointment.setIgnoreConflicts(true);
        this.updateAppointment.setLastModified(new Date(Long.MAX_VALUE));
    }

    public void testBug19489() throws Exception {
        UpdateRequest updateRequest = new UpdateRequest(this.updateAppointment, this.getClient().getValues().getTimeZone());
        UpdateResponse updateResponse = this.getClient().execute(updateRequest);
        updateResponse.fillObject((DataObject)this.appointment);
        GetRequest getRequest = new GetRequest(this.appointment);
        GetResponse getResponse = this.getClient().execute(getRequest);
        Appointment loadedAppointment = getResponse.getAppointment(this.getClient().getValues().getTimeZone());
        Bug19489Test.assertEquals((String)"Wrong start date", (Object)this.appointment.getStartDate(), (Object)loadedAppointment.getStartDate());
        Bug19489Test.assertEquals((String)"Wrong end date", (Object)this.appointment.getEndDate(), (Object)loadedAppointment.getEndDate());
    }

    @Override
    public void tearDown() throws Exception {
        this.getClient().execute(new DeleteRequest(this.appointment));
        super.tearDown();
    }
}

