/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.osgi.NearRegistryServiceTracker;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.helpers.PropertyMixin;
import com.openexchange.webdav.protocol.helpers.PropertyMixinFactory;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;

public class OSGiPropertyMixin
implements PropertyMixin {
    private final NearRegistryServiceTracker<PropertyMixin> mixinTracker;
    private final NearRegistryServiceTracker<PropertyMixinFactory> factoryTracker;
    private final SessionHolder sessionHolder;

    public OSGiPropertyMixin(BundleContext context, SessionHolder sessionHolder) {
        this.sessionHolder = sessionHolder;
        this.mixinTracker = new NearRegistryServiceTracker(context, PropertyMixin.class);
        this.mixinTracker.open();
        this.factoryTracker = new NearRegistryServiceTracker(context, PropertyMixinFactory.class);
        this.factoryTracker.open();
    }

    public void close() {
        this.mixinTracker.close();
        this.factoryTracker.close();
    }

    @Override
    public List<WebdavProperty> getAllProperties() throws OXException {
        List factories;
        ArrayList<WebdavProperty> allProperties = new ArrayList<WebdavProperty>();
        List mixins = this.mixinTracker.getServiceList();
        if (mixins != null && !mixins.isEmpty()) {
            for (PropertyMixin mixin : mixins) {
                allProperties.addAll(mixin.getAllProperties());
            }
        }
        if ((factories = this.factoryTracker.getServiceList()) != null && !factories.isEmpty()) {
            for (PropertyMixinFactory factory : factories) {
                PropertyMixin mixin = factory.create(this.sessionHolder);
                allProperties.addAll(mixin.getAllProperties());
            }
        }
        return allProperties;
    }

    @Override
    public WebdavProperty getProperty(String namespace, String name) throws OXException {
        List factories;
        List mixins = this.mixinTracker.getServiceList();
        if (mixins != null && !mixins.isEmpty()) {
            for (PropertyMixin mixin : mixins) {
                WebdavProperty property = mixin.getProperty(namespace, name);
                if (property == null) continue;
                return property;
            }
        }
        if ((factories = this.factoryTracker.getServiceList()) != null && !factories.isEmpty()) {
            for (PropertyMixinFactory factory : factories) {
                PropertyMixin mixin = factory.create(this.sessionHolder);
                WebdavProperty property = mixin.getProperty(namespace, name);
                if (property == null) continue;
                return property;
            }
        }
        return null;
    }
}

