/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.groupware.EnumComponent;

public enum WebdavExceptionCode implements DisplayableOXExceptionCode
{
    INVALID_VALUE("Invalid value in element \"%1$s\": %2$s.", CATEGORY_ERROR, 1, null),
    IO_ERROR("An I/O error occurred.", CATEGORY_ERROR, 2, null),
    MISSING_FIELD("Missing field %1$s.", CATEGORY_ERROR, 3, null),
    MISSING_HEADER_FIELD("Missing header field %1$s.", CATEGORY_ERROR, 4, null),
    INVALID_ACTION("Invalid action %1$s.", CATEGORY_ERROR, 5, null),
    NOT_A_NUMBER("%1$s is not a number.", CATEGORY_USER_INPUT, 6, "%1$s is not a number."),
    NO_PRINCIPAL("No principal found: %1$s.", CATEGORY_ERROR, 7, null),
    EMPTY_PASSWORD("Empty passwords are not allowed.", CATEGORY_USER_INPUT, 8, "Empty passwords are not allowed."),
    UNSUPPORTED_AUTH_MECH("Unsupported authorization mechanism in \"Authorization\" header: %1$s.", CATEGORY_ERROR, 9, null),
    RESOLVING_USER_NAME_FAILED("Resolving user name \"%1$s\" failed.", CATEGORY_ERROR, 10, null),
    AUTH_FAILED("Authentication failed for user name: %1$s", CATEGORY_ERROR, 11, "Authentication failed for user name: %1$s"),
    UNEXPECTED_ERROR("Unexpected error: %1$s", CATEGORY_ERROR, 11, null);

    private final String message;
    private final int detailNumber;
    private final Category category;
    private String displayMessage;

    private WebdavExceptionCode(String message, Category category, int detailNumber, String displayMessage) {
        this.message = message;
        this.detailNumber = detailNumber;
        this.category = category;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
    }

    public String getPrefix() {
        return EnumComponent.WEBDAV.getAbbreviation();
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

