/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.valuedefinitions.rfc2425;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.ValueDefinition;
import com.openexchange.tools.versit.VersitException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.regex.Pattern;

public class FloatValueDefinition
extends ValueDefinition {
    public static final ValueDefinition Default = new FloatValueDefinition();
    private static Pattern FloatPattern = Pattern.compile("[-+]\\d+(\\.\\d+)?");
    private static final DecimalFormat Format = new DecimalFormat("0.################");

    @Override
    public Object createValue(StringScanner s, Property property) throws IOException {
        String value = s.regex(FloatPattern);
        if (value == null) {
            throw new VersitException(s, "Float expected");
        }
        return Double.valueOf(value);
    }

    @Override
    public String writeValue(Object value) {
        return Format.format((Double)value);
    }
}

