/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.stack;

import com.openexchange.tools.stack.Stack;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.EmptyStackException;

public final class ArrayStack<T>
implements Stack<T> {
    private T[] arr;
    private int top;
    private final Class<T> clazz;
    private static final int DEFAULT_CAPACITY = 10;

    public ArrayStack(Class<T> clazz) {
        this(clazz, 10);
    }

    public ArrayStack(Class<T> clazz, int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Stack capacity must be greater than 0");
        }
        this.clazz = clazz;
        this.arr = (Object[])Array.newInstance(clazz, capacity);
        this.top = -1;
    }

    @Override
    public boolean isEmpty() {
        return this.top == -1;
    }

    @Override
    public void clear() {
        Arrays.fill(this.arr, null);
        this.top = -1;
    }

    @Override
    public T top() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.arr[this.top];
    }

    @Override
    public void pop() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        this.arr[this.top--] = null;
    }

    @Override
    public T topAndPop() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        T retval = this.arr[this.top];
        this.arr[this.top--] = null;
        return retval;
    }

    @Override
    public void push(T x) {
        if (this.top + 1 == this.arr.length) {
            this.doubleArray();
        }
        this.arr[++this.top] = x;
    }

    @Override
    public int size() {
        return this.top + 1;
    }

    private void doubleArray() {
        Object[] newArr = (Object[])Array.newInstance(this.clazz, this.arr.length << 1);
        System.arraycopy(this.arr, 0, newArr, 0, this.arr.length);
        this.arr = newArr;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder(1024);
        tmp.append('[');
        if (this.arr[0] != null) {
            tmp.append(this.arr[0].toString());
            for (int i = 1; i < this.arr.length && this.arr[i] != null; ++i) {
                tmp.append(',').append(this.arr[i].toString());
            }
        }
        tmp.append(']');
        return tmp.toString();
    }
}

