/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.file.external.FileStorage;
import com.openexchange.tools.file.external.FileStorageCodes;
import com.openexchange.tools.file.external.QuotaFileStorage;
import com.openexchange.tools.file.external.QuotaFileStorageExceptionCodes;
import com.openexchange.tools.file.external.QuotaFileStorages;
import com.openexchange.tools.sql.DBUtils;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBQuotaFileStorage
implements QuotaFileStorage {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaFileStorage.class);
    private final Context context;
    private final FileStorage fileStorage;
    private final DatabaseService db;

    public DBQuotaFileStorage(Context context, FileStorage fs, DatabaseService db) throws OXException {
        this.context = context;
        this.fileStorage = fs;
        this.db = db;
        if (this.fileStorage == null) {
            throw QuotaFileStorageExceptionCodes.INSTANTIATIONERROR.create();
        }
    }

    @Override
    public long getQuota() {
        return this.context.getFileStorageQuota();
    }

    @Override
    public boolean deleteFile(String identifier) throws OXException {
        long fileSize = this.fileStorage.getFileSize(identifier);
        boolean deleted = this.fileStorage.deleteFile(identifier);
        if (!deleted) {
            return false;
        }
        this.decUsage(fileSize);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean incUsage(long usage) throws OXException {
        ResultSet rs;
        PreparedStatement ustmt;
        PreparedStatement sstmt;
        Connection con;
        block10: {
            long newUsage;
            boolean rollback;
            boolean hasUserColumn;
            int contextId;
            block8: {
                boolean bl;
                block9: {
                    con = this.db.getWritable(this.context);
                    contextId = this.context.getContextId();
                    hasUserColumn = QuotaFileStorages.hasUserColumn(con, contextId);
                    sstmt = null;
                    ustmt = null;
                    rs = null;
                    rollback = false;
                    con.setAutoCommit(false);
                    rollback = true;
                    sstmt = con.prepareStatement(hasUserColumn ? "SELECT used FROM filestore_usage WHERE cid=? AND user=0 FOR UPDATE" : "SELECT used FROM filestore_usage WHERE cid=? FOR UPDATE");
                    sstmt.setInt(1, contextId);
                    rs = sstmt.executeQuery();
                    if (!rs.next()) {
                        throw QuotaFileStorageExceptionCodes.NO_USAGE.create(Autoboxing.I((int)contextId));
                    }
                    long oldUsage = rs.getLong(1);
                    newUsage = oldUsage + usage;
                    long quota = this.context.getFileStorageQuota();
                    if (quota <= 0L || newUsage <= quota) break block8;
                    bl = true;
                    if (!rollback) break block9;
                    DBUtils.rollback(con);
                }
                DBUtils.autocommit(con);
                DBUtils.closeSQLStuff(rs);
                DBUtils.closeSQLStuff(sstmt);
                DBUtils.closeSQLStuff(ustmt);
                this.db.backWritable(this.context, con);
                return bl;
            }
            try {
                ustmt = con.prepareStatement(hasUserColumn ? "UPDATE filestore_usage SET used=? WHERE cid=? AND user=0" : "UPDATE filestore_usage SET used=? WHERE cid=?");
                ustmt.setLong(1, newUsage);
                ustmt.setInt(2, contextId);
                int rows = ustmt.executeUpdate();
                if (rows == 0) {
                    throw QuotaFileStorageExceptionCodes.UPDATE_FAILED.create(Autoboxing.I((int)contextId));
                }
                con.commit();
                rollback = false;
                if (!rollback) break block10;
            }
            catch (SQLException s) {
                try {
                    throw QuotaFileStorageExceptionCodes.SQLSTATEMENTERROR.create(s, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (rollback) {
                        DBUtils.rollback(con);
                    }
                    DBUtils.autocommit(con);
                    DBUtils.closeSQLStuff(rs);
                    DBUtils.closeSQLStuff(sstmt);
                    DBUtils.closeSQLStuff(ustmt);
                    this.db.backWritable(this.context, con);
                    throw throwable;
                }
            }
            DBUtils.rollback(con);
        }
        DBUtils.autocommit(con);
        DBUtils.closeSQLStuff(rs);
        DBUtils.closeSQLStuff(sstmt);
        DBUtils.closeSQLStuff(ustmt);
        this.db.backWritable(this.context, con);
        return false;
    }

    protected void decUsage(long usage) throws OXException {
        Connection con = this.db.getWritable(this.context);
        int contextId = this.context.getContextId();
        boolean hasUserColumn = QuotaFileStorages.hasUserColumn(con, contextId);
        PreparedStatement sstmt = null;
        PreparedStatement ustmt = null;
        ResultSet rs = null;
        try {
            con.setAutoCommit(false);
            sstmt = con.prepareStatement(hasUserColumn ? "SELECT used FROM filestore_usage WHERE cid=? AND user=0 FOR UPDATE" : "SELECT used FROM filestore_usage WHERE cid=? FOR UPDATE");
            sstmt.setInt(1, contextId);
            rs = sstmt.executeQuery();
            if (!rs.next()) {
                throw QuotaFileStorageExceptionCodes.NO_USAGE.create(Autoboxing.I((int)contextId));
            }
            long oldUsage = rs.getLong("used");
            long newUsage = oldUsage - usage;
            if (newUsage < 0L) {
                newUsage = 0L;
                OXException e = QuotaFileStorageExceptionCodes.QUOTA_UNDERRUN.create(Autoboxing.I((int)contextId));
                LOG.error("", (Throwable)e);
            }
            ustmt = con.prepareStatement(hasUserColumn ? "UPDATE filestore_usage SET used=? WHERE cid=? AND user=0" : "UPDATE filestore_usage SET used=? WHERE cid=?");
            ustmt.setLong(1, newUsage);
            ustmt.setInt(2, contextId);
            int rows = ustmt.executeUpdate();
            if (1 != rows) {
                throw QuotaFileStorageExceptionCodes.UPDATE_FAILED.create(Autoboxing.I((int)contextId));
            }
            con.commit();
        }
        catch (SQLException s) {
            try {
                DBUtils.rollback(con);
                throw QuotaFileStorageExceptionCodes.SQLSTATEMENTERROR.create(s, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.autocommit(con);
                DBUtils.closeSQLStuff(rs);
                DBUtils.closeSQLStuff(sstmt);
                DBUtils.closeSQLStuff(ustmt);
                this.db.backWritable(this.context, con);
                throw throwable;
            }
        }
        DBUtils.autocommit(con);
        DBUtils.closeSQLStuff(rs);
        DBUtils.closeSQLStuff(sstmt);
        DBUtils.closeSQLStuff(ustmt);
        this.db.backWritable(this.context, con);
    }

    @Override
    public Set<String> deleteFiles(String[] identifiers) throws OXException {
        HashMap<String, Long> fileSizes = new HashMap<String, Long>();
        TreeSet<String> set = new TreeSet<String>();
        for (String identifier : identifiers) {
            boolean deleted;
            try {
                Long size = Autoboxing.L((long)this.getFileSize(identifier));
                deleted = this.fileStorage.deleteFile(identifier);
                fileSizes.put(identifier, size);
            }
            catch (OXException e) {
                if (!FileStorageCodes.FILE_NOT_FOUND.equals(e)) {
                    throw e;
                }
                deleted = false;
            }
            if (deleted) continue;
            set.add(identifier);
        }
        fileSizes.keySet().removeAll(set);
        long sum = 0L;
        Iterator i$ = fileSizes.values().iterator();
        while (i$.hasNext()) {
            long fileSize = (Long)i$.next();
            sum += fileSize;
        }
        this.decUsage(sum);
        return set;
    }

    @Override
    public long getUsage() throws OXException {
        long usage;
        Connection con = this.db.getReadOnly(this.context);
        int contextId = this.context.getContextId();
        boolean hasUserColumn = QuotaFileStorages.hasUserColumn(con, contextId);
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(hasUserColumn ? "SELECT used FROM filestore_usage WHERE cid=? AND user=0" : "SELECT used FROM filestore_usage WHERE cid=?");
            stmt.setInt(1, contextId);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw QuotaFileStorageExceptionCodes.NO_USAGE.create(Autoboxing.I((int)contextId));
            }
            usage = result.getLong(1);
        }
        catch (SQLException e) {
            try {
                throw QuotaFileStorageExceptionCodes.SQLSTATEMENTERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result);
                DBUtils.closeSQLStuff(stmt);
                this.db.backReadOnly(this.context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result);
        DBUtils.closeSQLStuff(stmt);
        this.db.backReadOnly(this.context, con);
        return usage;
    }

    @Override
    public String saveNewFile(InputStream is) throws OXException {
        return this.saveNewFile(is, -1L);
    }

    @Override
    public String saveNewFile(InputStream is, long sizeHint) throws OXException {
        boolean full;
        if (0L < sizeHint) {
            this.checkAvailable(sizeHint);
        }
        String file = null;
        String retval = null;
        try {
            file = this.fileStorage.saveNewFile(is);
            long fileSize = this.fileStorage.getFileSize(file);
            retval = file;
            full = this.incUsage(fileSize);
            if (full) {
                retval = null;
                this.fileStorage.deleteFile(file);
            }
        }
        catch (OXException q) {
            if (file != null) {
                this.fileStorage.deleteFile(file);
            }
            throw q;
        }
        if (full) {
            throw QuotaFileStorageExceptionCodes.STORE_FULL.create();
        }
        return retval;
    }

    @Override
    public void recalculateUsage() throws OXException {
        Set<String> filesToIgnore = Collections.emptySet();
        this.recalculateUsage(filesToIgnore);
    }

    @Override
    public void recalculateUsage(Set<String> filesToIgnore) throws OXException {
        int contextId = this.context.getContextId();
        SortedSet<String> filenames = this.fileStorage.getFileList();
        long entireFileSize = 0L;
        LOG.info("Recalculating usage for Context {}", (Object)contextId);
        for (String filename : filenames) {
            if (filesToIgnore.contains(filename)) continue;
            entireFileSize += this.fileStorage.getFileSize(filename);
        }
        Connection con = this.db.getWritable(this.context);
        boolean hasUserColumn = QuotaFileStorages.hasUserColumn(con, contextId);
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(hasUserColumn ? "UPDATE filestore_usage SET used=? WHERE cid=? AND user=0" : "UPDATE filestore_usage SET used=? WHERE cid=?");
            stmt.setLong(1, entireFileSize);
            stmt.setInt(2, contextId);
            int rows = stmt.executeUpdate();
            if (1 != rows) {
                throw QuotaFileStorageExceptionCodes.UPDATE_FAILED.create(Autoboxing.I((int)contextId));
            }
        }
        catch (SQLException s) {
            DBUtils.rollback(con);
            throw QuotaFileStorageExceptionCodes.SQLSTATEMENTERROR.create(s, new Object[0]);
        }
        catch (RuntimeException s) {
            DBUtils.rollback(con);
            throw QuotaFileStorageExceptionCodes.SQLSTATEMENTERROR.create(s, new Object[0]);
        }
        finally {
            DBUtils.autocommit(con);
            DBUtils.closeSQLStuff(result, stmt);
            this.db.backWritable(this.context, con);
        }
    }

    @Override
    public SortedSet<String> getFileList() throws OXException {
        return this.fileStorage.getFileList();
    }

    @Override
    public InputStream getFile(String file) throws OXException {
        return this.fileStorage.getFile(file);
    }

    @Override
    public long getFileSize(String name) throws OXException {
        return this.fileStorage.getFileSize(name);
    }

    @Override
    public String getMimeType(String name) throws OXException {
        return this.fileStorage.getMimeType(name);
    }

    @Override
    public void remove() throws OXException {
        this.fileStorage.remove();
    }

    @Override
    public void recreateStateFile() throws OXException {
        this.fileStorage.recreateStateFile();
    }

    @Override
    public boolean stateFileIsCorrect() throws OXException {
        return this.fileStorage.stateFileIsCorrect();
    }

    @Override
    public long appendToFile(InputStream is, String name, long offset) throws OXException {
        return this.appendToFile(is, name, offset, -1L);
    }

    @Override
    public long appendToFile(InputStream is, String name, long offset, long sizeHint) throws OXException {
        if (0L < sizeHint) {
            this.checkAvailable(sizeHint);
        }
        long newSize = -1L;
        boolean notFoundError = false;
        try {
            newSize = this.fileStorage.appendToFile(is, name, offset);
            if (this.incUsage(newSize - offset)) {
                throw QuotaFileStorageExceptionCodes.STORE_FULL.create();
            }
        }
        catch (OXException e) {
            if (FileStorageCodes.FILE_NOT_FOUND.equals(e)) {
                notFoundError = true;
            }
            throw e;
        }
        finally {
            if (!notFoundError && -1L == newSize) {
                try {
                    this.fileStorage.setFileLength(offset, name);
                }
                catch (OXException e) {
                    LOG.warn("Error rolling back 'append' operation", (Throwable)e);
                }
            }
        }
        return newSize;
    }

    @Override
    public void setFileLength(long length, String name) throws OXException {
        this.fileStorage.setFileLength(length, name);
    }

    @Override
    public InputStream getFile(String name, long offset, long length) throws OXException {
        return this.fileStorage.getFile(name, offset, length);
    }

    private void checkAvailable(long required) throws OXException {
        long quota;
        if (0L < required && 0L < (quota = this.getQuota()) && quota < this.getUsage() + required) {
            throw QuotaFileStorageExceptionCodes.STORE_FULL.create();
        }
    }
}

