/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.encoding;

import com.openexchange.java.Charsets;
import com.openexchange.tools.encoding.Hex;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URLCoder {
    private static final Logger LOG;
    private static BitSet needToBeEncoded;

    private URLCoder() {
    }

    public static String encode(String source) {
        return URLCoder.encode(source, Charsets.UTF_8);
    }

    public static String decode(String url) {
        return URLCoder.decode(url, Charsets.UTF_8);
    }

    public static String decode(String source, Charset charset) {
        UnsynchronizedByteArrayOutputStream baos = new UnsynchronizedByteArrayOutputStream();
        int pos = 0;
        while (pos < source.length()) {
            char chr;
            if ('%' == (chr = source.charAt(pos++))) {
                baos.write(Hex.toByte(source.substring(pos, pos + 2)));
                pos += 2;
                continue;
            }
            baos.write((byte)chr);
        }
        return Charsets.toString((byte[])baos.toByteArray(), (Charset)charset);
    }

    public static String encode(String source, Charset charset) {
        byte[] bytes = Charsets.getBytes((String)source, (Charset)charset);
        StringBuilder builder = new StringBuilder(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            if (needToBeEncoded.get(bytes[i] < 0 ? 256 + bytes[i] : bytes[i])) {
                builder.append('%');
                builder.append(Hex.toHex(bytes[i]));
                continue;
            }
            builder.append((char)bytes[i]);
        }
        return builder.toString();
    }

    static {
        int i;
        LOG = LoggerFactory.getLogger(URLCoder.class);
        needToBeEncoded = new BitSet(256);
        for (i = 0; i < 32; ++i) {
            needToBeEncoded.set(i);
        }
        for (i = 128; i <= 255; ++i) {
            needToBeEncoded.set(i);
        }
        needToBeEncoded.set(36);
        needToBeEncoded.set(38);
        needToBeEncoded.set(43);
        needToBeEncoded.set(44);
        needToBeEncoded.set(47);
        needToBeEncoded.set(58);
        needToBeEncoded.set(59);
        needToBeEncoded.set(61);
        needToBeEncoded.set(63);
        needToBeEncoded.set(64);
        needToBeEncoded.set(32);
        needToBeEncoded.set(34);
        needToBeEncoded.set(60);
        needToBeEncoded.set(62);
        needToBeEncoded.set(35);
        needToBeEncoded.set(37);
        needToBeEncoded.set(123);
        needToBeEncoded.set(125);
        needToBeEncoded.set(124);
        needToBeEncoded.set(92);
        needToBeEncoded.set(94);
        needToBeEncoded.set(126);
        needToBeEncoded.set(91);
        needToBeEncoded.set(93);
        needToBeEncoded.set(96);
    }
}

