/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools;

import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.java.AllocatingStringWriter;
import com.openexchange.java.Strings;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public final class StringCollection {
    static final byte[] DSO = "\\".getBytes();
    static final byte[] DSOR = "\\\\".getBytes();
    static final byte[] DAP = "'".getBytes();
    static final byte[] DAPR = "\\'".getBytes();
    private static final Class<? extends CalendarCollectionService> CalendarCollectionService = CalendarCollectionService.class;
    private static final Pattern ESCAPED_REGEX_WILDCARD_PATTERN = Pattern.compile("(([\\\\]+)(\\*|\\?))");
    private static final Pattern REGEX_WILDCARD_PATTERN = Pattern.compile("((\\*|\\?))");

    private StringCollection() {
    }

    public static String prepareForSearch(String s) {
        return StringCollection.prepareForSearch(s, true);
    }

    public static String prepareForSearch(String s, boolean surroundWithWildcard) {
        return StringCollection.prepareForSearch(s, surroundWithWildcard, true);
    }

    public static String prepareForSearch(String s, boolean surroundWithWildcard, boolean preparedStatement) {
        if (s == null) {
            return s;
        }
        String value = s.trim();
        if (!preparedStatement) {
            value = value.replaceAll("\\\\", StringCollection.quoteReplacement("\\\\")).replaceAll("'", StringCollection.quoteReplacement("\\'"));
        }
        value = value.replaceAll("%", StringCollection.quoteReplacement("\\%")).replaceAll("_", StringCollection.quoteReplacement("\\_")).replaceAll("\\*", StringCollection.quoteReplacement("%")).replaceAll("\\?", StringCollection.quoteReplacement("_"));
        if (surroundWithWildcard) {
            if (value.length() > 0) {
                int length;
                if (value.charAt(0) != '%') {
                    value = new StringBuilder(value.length() + 1).append('%').append(value).toString();
                }
                if (value.charAt((length = value.length()) - 1) != '%' || length > 1 && value.charAt(length - 2) == '\\') {
                    value = new StringBuilder(length + 1).append(value).append('%').toString();
                }
            } else {
                value = "%";
            }
        }
        return value;
    }

    public static String prepareForSearch(String s, boolean prependWildcard, boolean appendWildcard, boolean preparedStatement) {
        int length;
        if (s == null) {
            return s;
        }
        String value = s.trim();
        if (!preparedStatement) {
            value = value.replaceAll("\\\\", StringCollection.quoteReplacement("\\\\")).replaceAll("'", StringCollection.quoteReplacement("\\'"));
        }
        value = value.replaceAll("%", StringCollection.quoteReplacement("\\%")).replaceAll("_", StringCollection.quoteReplacement("\\_")).replaceAll("\\*", StringCollection.quoteReplacement("%")).replaceAll("\\?", StringCollection.quoteReplacement("_"));
        if (prependWildcard) {
            length = value.length();
            if (length > 0) {
                if (value.charAt(0) != '%') {
                    value = new StringBuilder(length + 1).append('%').append(value).toString();
                }
            } else {
                value = "%";
            }
        }
        if (appendWildcard) {
            length = value.length();
            if (length > 0) {
                if (value.charAt(length - 1) != '%' || length > 1 && value.charAt(length - 2) == '\\') {
                    value = new StringBuilder(length + 1).append(value).append('%').toString();
                }
            } else {
                value = "%";
            }
        }
        return value;
    }

    public static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String disarmSQLString(String s) {
        return new String(StringCollection.replaceGivenBytes(StringCollection.replaceGivenBytes(s.getBytes(), DSO, DSOR), DAP, DAPR));
    }

    public static byte[] replaceGivenBytes(byte[] b, byte[] replace, byte[] replacement) {
        byte[] r = new byte[b.length + (replacement.length << 1)];
        int c = 0;
        int l = replace.length;
        for (int a = 0; a < b.length; ++a) {
            boolean found = false;
            int fc = 1;
            if (b[a] == replace[0]) {
                found = true;
                for (int n = 1; n < l; ++n) {
                    int m = a + n;
                    if (m < b.length) {
                        if (b[a + n] == replace[n]) {
                            found = true;
                            ++fc;
                            continue;
                        }
                        found = false;
                        continue;
                    }
                    found = false;
                }
            }
            if (r.length < c + replacement.length) {
                r = StringCollection.expandArray(r, c, c + replacement.length);
            }
            if (found && fc == replace.length) {
                System.arraycopy(replacement, 0, r, c, replacement.length);
                c += replacement.length;
                a = a + l - 1;
                continue;
            }
            r[c] = b[a];
            ++c;
        }
        r = StringCollection.blurTrim(r, c);
        return r;
    }

    public static String getSqlInString(int[] arr) {
        if (arr == null) {
            return null;
        }
        int length = arr.length;
        if (length <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(length << 2);
        sb.append('(');
        sb.append(arr[0]);
        for (int a = 1; a < length; ++a) {
            sb.append(',');
            sb.append(arr[a]);
        }
        sb.append(')');
        return sb.toString();
    }

    public static String getSqlInString(Set<Integer> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        int size = set.size();
        StringBuilder sb = new StringBuilder(size * 5);
        Integer[] values = set.toArray(new Integer[set.size()]);
        sb.append('(');
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(',');
                sb.append(values[i]);
                continue;
            }
            sb.append(values[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    public static String getSqlInString(Object[] arr) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(arr.length * 5);
        sb.append('(');
        for (int a = 0; a < arr.length; ++a) {
            if (a > 0) {
                sb.append(',');
                sb.append(arr[a]);
                continue;
            }
            sb.append(arr[a]);
        }
        sb.append(')');
        return sb.toString();
    }

    public static String getSqlInString(int[][] arr) {
        StringBuilder sb = new StringBuilder();
        if (arr.length > 0) {
            sb.append('(');
            for (int a = 0; a < arr.length; ++a) {
                if (a > 0) {
                    sb.append(',');
                    sb.append(arr[a][0]);
                    continue;
                }
                sb.append(arr[a][0]);
            }
        } else {
            return null;
        }
        sb.append(')');
        return sb.toString();
    }

    public static String getSqlInString(int i, int[] arr) {
        if (null == arr) {
            return new StringBuilder(8).append('(').append(i).append(')').toString();
        }
        int length = arr.length;
        if (0 == length) {
            return new StringBuilder(8).append('(').append(i).append(')').toString();
        }
        StringBuilder sb = new StringBuilder(length << 1);
        sb.append('(');
        sb.append(i);
        if (length > 0) {
            for (int a = 0; a < length; ++a) {
                sb.append(',');
                sb.append(arr[a]);
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public static String getSqlInStringFromMap(Map<?, ?> m) {
        if (m == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        int size = m.size();
        if (size > 0) {
            Iterator<?> it = m.keySet().iterator();
            sb.append(it.next().toString());
            for (int k = 1; k < size; ++k) {
                sb.append(',');
                sb.append(it.next().toString());
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public static byte[] blurTrim(byte[] b, int c) {
        byte[] r = new byte[c];
        System.arraycopy(b, 0, r, 0, c);
        return r;
    }

    public static byte[] expandArray(byte[] b, int c, int l) {
        byte[] r = new byte[b.length + l << 1];
        System.arraycopy(b, 0, r, 0, c);
        return r;
    }

    public static String date2SQLString(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        return sdf.format(d);
    }

    public static String date2String(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm", Locale.ENGLISH);
        return sdf.format(d);
    }

    public static String getSelect(int[] cols, String table) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("SELECT ");
        boolean first = true;
        for (int a = 0; a < cols.length; ++a) {
            CalendarCollectionService calColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService);
            String temp = calColl.getFieldName(cols[a]);
            if (temp == null) continue;
            if (first) {
                sb.append(temp);
                first = false;
                continue;
            }
            sb.append(',');
            sb.append(temp);
        }
        sb.append(" FROM ");
        sb.append(table);
        return sb.toString();
    }

    public static String convertArray2String(int[] i) {
        if (i == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int a = 0; a < i.length; ++a) {
            sb.append(i[a]);
            sb.append(',');
        }
        return sb.delete(sb.length() - 1, sb.length()).toString();
    }

    public static String convertArray2String(String[] s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int a = 0; a < s.length; ++a) {
            sb.append(s[a]);
            sb.append(',');
        }
        return sb.delete(sb.length() - 1, sb.length()).toString();
    }

    public static int[] convertStringArray2IntArray(String[] s) {
        int[] i = new int[s.length];
        for (int a = 0; a < i.length; ++a) {
            i[a] = Integer.parseInt(s[a]);
        }
        return i;
    }

    public static boolean isEmpty(String s) {
        int length = s.length();
        for (int a = 0; a < length; ++a) {
            if (Strings.isWhitespace((char)s.charAt(a))) continue;
            return false;
        }
        return true;
    }

    public static String convertArraytoString(Object[] o) {
        StringBuilder sb = new StringBuilder();
        for (int a = 0; a < o.length; ++a) {
            sb.append(o[a]);
        }
        return sb.toString();
    }

    public static String getStackAsString() {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        AllocatingStringWriter sw = new AllocatingStringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static boolean containsWildcards(String s) {
        return REGEX_WILDCARD_PATTERN.matcher(s).find() && !ESCAPED_REGEX_WILDCARD_PATTERN.matcher(s).find();
    }
}

