/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class ByteBuffers {
    private ByteBuffers() {
    }

    public static OutputStream newOutputStream(final ByteBuffer buf) {
        return new OutputStream(){

            @Override
            public synchronized void write(int b) throws IOException {
                buf.put((byte)b);
            }

            @Override
            public synchronized void write(byte[] bytes, int off, int len) throws IOException {
                buf.put(bytes, off, len);
            }
        };
    }

    public static OutputStream newUnsynchronizedOutputStream(final ByteBuffer buf) {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                buf.put((byte)b);
            }

            @Override
            public void write(byte[] bytes, int off, int len) throws IOException {
                buf.put(bytes, off, len);
            }
        };
    }

    public static InputStream newInputStream(final ByteBuffer buf) {
        return new InputStream(){

            @Override
            public synchronized int read() throws IOException {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                return buf.get();
            }

            @Override
            public synchronized int read(byte[] bytes, int off, int len) throws IOException {
                int l = Math.min(len, buf.remaining());
                buf.get(bytes, off, l);
                return l;
            }
        };
    }

    public static InputStream newUnsynchronizedInputStream(final ByteBuffer buf) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                return buf.get();
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                int l = Math.min(len, buf.remaining());
                buf.get(bytes, off, l);
                return l;
            }
        };
    }
}

