/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.services;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentConfig;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.groupware.infostore.InfostoreConfig;
import com.openexchange.groupware.upload.quotachecker.MailUploadQuotaChecker;
import com.openexchange.jslob.DefaultJSlob;
import com.openexchange.jslob.JSlob;
import com.openexchange.jslob.JSlobId;
import com.openexchange.jslob.shared.SharedJSlobService;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.Session;
import com.openexchange.tools.file.QuotaFileStorage;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import org.json.JSONException;
import org.json.JSONObject;

public class SharedInfostoreJSlob
implements SharedJSlobService {
    private final String serviceId;
    private final String id;

    public SharedInfostoreJSlob() {
        this.serviceId = "com.openexchange.jslob.config";
        this.id = "io.ox/core/properties";
    }

    public JSlob getJSlob(Session session) throws OXException {
        try {
            int maxBodySize = ServerConfig.getInt(ServerConfig.Property.MAX_BODY_SIZE);
            long infostoreMaxUploadSize = InfostoreConfig.getMaxUploadSize();
            long attachmentMaxUploadSize = AttachmentConfig.getMaxUploadSize();
            Context ctx = ContextStorage.getStorageContext(session);
            QuotaFileStorage fs = QuotaFileStorage.getInstance(FilestoreStorage.createURI(ctx), ctx);
            long infostoreQuota = fs.getQuota();
            long infostoreUsage = fs.getUsage();
            UserSettingMail userSettingMail = UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), ctx);
            MailUploadQuotaChecker mailUploadQuotaChecker = new MailUploadQuotaChecker(userSettingMail);
            long attachmentQuota = mailUploadQuotaChecker.getQuotaMax();
            long attachmentQuotaPerFile = mailUploadQuotaChecker.getFileQuotaMax();
            JSONObject json = new JSONObject(10);
            json.put("maxBodySize", maxBodySize);
            json.put("infostoreMaxUploadSize", infostoreMaxUploadSize);
            json.put("attachmentMaxUploadSize", attachmentMaxUploadSize);
            json.put("infostoreQuota", infostoreQuota);
            json.put("infostoreUsage", infostoreUsage);
            json.put("attachmentQuota", attachmentQuota);
            json.put("attachmentQuotaPerFile", attachmentQuotaPerFile);
            DefaultJSlob jslob = new DefaultJSlob();
            jslob.setJsonObject(json);
            jslob.setId(new JSlobId(this.serviceId, this.id, session.getUserId(), session.getContextId()));
            return jslob;
        }
        catch (JSONException e) {
            throw OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]);
        }
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getId() {
        return this.id;
    }
}

