/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.internal;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.cache.memory.FolderMap;
import com.openexchange.folderstorage.cache.memory.FolderMapManagement;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.mail.utils.ProviderUtility;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.internal.CachedResolveType;
import com.openexchange.mailaccount.internal.RdbMailAccountStorage;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.sql.DBUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

final class CachingMailAccountStorage
implements MailAccountStorageService {
    private static final String PROP_DRAFTS_FULL_NAME = "com.openexchange.mailaccount.draftsFullName";
    private static final String PROP_SENT_FULL_NAME = "com.openexchange.mailaccount.sentFullName";
    private static final String PROP_SPAM_FULL_NAME = "com.openexchange.mailaccount.spamFullName";
    private static final String PROP_TRASH_FULL_NAME = "com.openexchange.mailaccount.trashFullName";
    private static final String PROP_CONFIRMED_SPAM_FULL_NAME = "com.openexchange.mailaccount.confirmedSpamFullName";
    private static final String PROP_CONFIRMED_HAM_FULL_NAME = "com.openexchange.mailaccount.confirmedHamFullName";
    private static final String PROP_DRAFTS_NAME = "com.openexchange.mailaccount.draftsName";
    private static final String PROP_SENT_NAME = "com.openexchange.mailaccount.sentName";
    private static final String PROP_SPAM_NAME = "com.openexchange.mailaccount.spamName";
    private static final String PROP_TRASH_NAME = "com.openexchange.mailaccount.trashName";
    private static final String PROP_CONFIRMED_SPAM_NAME = "com.openexchange.mailaccount.confirmedSpamName";
    private static final String PROP_CONFIRMED_HAM_NAME = "com.openexchange.mailaccount.confirmedHamName";
    private static final String PROP_ACCOUNT_ID = "com.openexchange.mailaccount.accountId";
    private static final String PROP_USER_ID = "com.openexchange.mailaccount.userId";
    private static final String PROP_CONTEXT_ID = "com.openexchange.mailaccount.contextId";
    private static final String TOPIC_CHANGED_DEFAULT_FOLDERS = "com/openexchange/mailaccount/changeddefaultfolders";
    private static final String REGION_NAME = "MailAccount";
    private final RdbMailAccountStorage delegate;

    CachingMailAccountStorage(RdbMailAccountStorage delegate) {
        this.delegate = delegate;
    }

    RdbMailAccountStorage getDelegate() {
        return this.delegate;
    }

    private void postChangedDefaultFolders(int id, int[] indexes, String[] values, boolean isFullName, boolean distributeRemotely, int userId, int contextId) {
        EventAdmin eventAdmin = ServerServiceRegistry.getInstance().getService(EventAdmin.class);
        if (null != eventAdmin) {
            HashMap<String, Object> properties = new HashMap<String, Object>(9);
            properties.put(PROP_CONTEXT_ID, contextId);
            properties.put(PROP_USER_ID, userId);
            properties.put(PROP_ACCOUNT_ID, id);
            if (distributeRemotely) {
                properties.put("__publishRemote", Boolean.TRUE);
            }
            if (null != indexes && null != values) {
                block8: for (int i = 0; i < indexes.length; ++i) {
                    switch (indexes[i]) {
                        case 0: {
                            properties.put(isFullName ? PROP_DRAFTS_FULL_NAME : PROP_DRAFTS_NAME, values[i]);
                            continue block8;
                        }
                        case 1: {
                            properties.put(isFullName ? PROP_SENT_FULL_NAME : PROP_SENT_NAME, values[i]);
                            continue block8;
                        }
                        case 2: {
                            properties.put(isFullName ? PROP_SPAM_FULL_NAME : PROP_SPAM_NAME, values[i]);
                            continue block8;
                        }
                        case 3: {
                            properties.put(isFullName ? PROP_TRASH_FULL_NAME : PROP_TRASH_NAME, values[i]);
                            continue block8;
                        }
                        case 4: {
                            properties.put(isFullName ? PROP_CONFIRMED_SPAM_FULL_NAME : PROP_CONFIRMED_SPAM_NAME, values[i]);
                            continue block8;
                        }
                        case 5: {
                            properties.put(isFullName ? PROP_CONFIRMED_HAM_FULL_NAME : PROP_CONFIRMED_HAM_NAME, values[i]);
                            continue block8;
                        }
                    }
                }
            }
            eventAdmin.postEvent(new Event(TOPIC_CHANGED_DEFAULT_FOLDERS, properties));
        }
    }

    static CacheKey newCacheKey(CacheService cacheService, int id, int userId, int contextId) {
        return cacheService.newCacheKey(contextId, new String[]{String.valueOf(id), String.valueOf(userId)});
    }

    static CacheKey accountsCacheKey(CacheService cacheService, int userId, int contextId) {
        return cacheService.newCacheKey(contextId, String.valueOf(userId));
    }

    @Override
    public void invalidateMailAccount(int id, int userId, int contextId) throws OXException {
        FolderMap folderMap;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null != cacheService) {
            Cache cache = cacheService.getCache(REGION_NAME);
            cache.remove((Serializable)CachingMailAccountStorage.newCacheKey(cacheService, id, userId, contextId));
            cache.remove((Serializable)CachingMailAccountStorage.accountsCacheKey(cacheService, userId, contextId));
            cache.invalidateGroup(Integer.toString(contextId));
        }
        if (null != (folderMap = FolderMapManagement.getInstance().optFor(userId, contextId))) {
            folderMap.remove("default" + id, FolderStorage.REAL_TREE_ID);
            folderMap.remove("default" + id, "1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateMailAccounts(int userId, int contextId) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null != cacheService) {
            int[] ids;
            DatabaseService db = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
            Connection con = db.getWritable(contextId);
            try {
                ids = this.delegate.getUserMailAccountIDs(userId, contextId, con);
            }
            finally {
                db.backWritableAfterReading(contextId, con);
            }
            Cache cache = cacheService.getCache(REGION_NAME);
            cache.remove((Serializable)CachingMailAccountStorage.accountsCacheKey(cacheService, userId, contextId));
            for (int id : ids) {
                cache.remove((Serializable)CachingMailAccountStorage.newCacheKey(cacheService, id, userId, contextId));
                cache.invalidateGroup(Integer.toString(contextId));
            }
        }
        FolderMapManagement.getInstance().dropFor(userId, contextId);
    }

    @Override
    public void clearFullNamesForMailAccount(int id, int userId, int contextId) throws OXException {
        this.delegate.clearFullNamesForMailAccount(id, userId, contextId);
        this.invalidateMailAccount(id, userId, contextId);
        this.postChangedDefaultFolders(id, null, null, false, true, userId, contextId);
    }

    @Override
    public void clearFullNamesForMailAccount(int id, int[] indexes, int userId, int contextId) throws OXException {
        this.delegate.clearFullNamesForMailAccount(id, indexes, userId, contextId);
        this.invalidateMailAccount(id, userId, contextId);
        this.postChangedDefaultFolders(id, null, null, false, true, userId, contextId);
    }

    @Override
    public void setFullNamesForMailAccount(int id, int[] indexes, String[] fullNames, int userId, int contextId) throws OXException {
        this.delegate.setFullNamesForMailAccount(id, indexes, fullNames, userId, contextId);
        this.invalidateMailAccount(id, userId, contextId);
        this.postChangedDefaultFolders(id, indexes, fullNames, true, true, userId, contextId);
    }

    @Override
    public void setNamesForMailAccount(int id, int[] indexes, String[] names, int userId, int contextId) throws OXException {
        this.delegate.setNamesForMailAccount(id, indexes, names, userId, contextId);
        this.invalidateMailAccount(id, userId, contextId);
        this.postChangedDefaultFolders(id, indexes, names, false, true, userId, contextId);
    }

    @Override
    public void deleteMailAccount(int id, Map<String, Object> properties, int userId, int contextId, boolean deletePrimary, Connection con) throws OXException {
        this.dropSessionParameter(userId, contextId);
        this.delegate.deleteMailAccount(id, properties, userId, contextId, deletePrimary, con);
        this.invalidateMailAccount(id, userId, contextId);
    }

    @Override
    public void deleteMailAccount(int id, Map<String, Object> properties, int userId, int contextId, boolean deletePrimary) throws OXException {
        this.dropSessionParameter(userId, contextId);
        this.delegate.deleteMailAccount(id, properties, userId, contextId, deletePrimary);
        this.invalidateMailAccount(id, userId, contextId);
    }

    @Override
    public void deleteMailAccount(int id, Map<String, Object> properties, int userId, int contextId) throws OXException {
        this.dropSessionParameter(userId, contextId);
        this.delegate.deleteMailAccount(id, properties, userId, contextId);
        this.invalidateMailAccount(id, userId, contextId);
    }

    private void dropSessionParameter(final int userId, final int contextId) {
        AbstractTask<Void> task = new AbstractTask<Void>(){

            public Void call() {
                SessiondService service = ServerServiceRegistry.getInstance().getService(SessiondService.class);
                if (null != service) {
                    for (Session session : service.getSessions(userId, contextId)) {
                        session.setParameter("com.openexchange.mailaccount.unifiedMailEnabled", null);
                    }
                }
                return null;
            }
        };
        ThreadPools.getThreadPool().submit((Task)task);
    }

    @Override
    public MailAccount getDefaultMailAccount(int userId, int contextId) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getDefaultMailAccount(userId, contextId);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        Object object = cache.get((Serializable)CachingMailAccountStorage.newCacheKey(cacheService, 0, userId, contextId));
        if (object instanceof MailAccount) {
            return (MailAccount)object;
        }
        MailAccount defaultMailAccount = this.delegate.getDefaultMailAccount(userId, contextId);
        cache.put((Serializable)CachingMailAccountStorage.newCacheKey(cacheService, 0, userId, contextId), (Serializable)defaultMailAccount, false);
        return defaultMailAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailAccount getMailAccount(int id, int userId, int contextId) throws OXException {
        CacheKey key;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getMailAccount(id, userId, contextId);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        Object object = cache.get((Serializable)(key = CachingMailAccountStorage.newCacheKey(cacheService, id, userId, contextId)));
        if (object instanceof MailAccount) {
            return (MailAccount)object;
        }
        RdbMailAccountStorage d = this.delegate;
        try {
            MailAccount mailAccount = d.getMailAccount(id, userId, contextId);
            cache.put((Serializable)key, (Serializable)mailAccount, false);
            return mailAccount;
        }
        catch (OXException e) {
            if (!MailAccountExceptionCodes.NOT_FOUND.equals(e)) {
                throw e;
            }
            Connection wcon = Database.get(contextId, true);
            try {
                MailAccount mailAccount = d.getMailAccount(id, userId, contextId, wcon);
                cache.put((Serializable)key, (Serializable)mailAccount, false);
                MailAccount mailAccount2 = mailAccount;
                return mailAccount2;
            }
            finally {
                Database.backAfterReading(contextId, wcon);
            }
        }
    }

    @Override
    public int getByPrimaryAddress(String primaryAddress, int userId, int contextId) throws OXException {
        return this.delegate.getByPrimaryAddress(primaryAddress, userId, contextId);
    }

    @Override
    public int[] getByHostNames(Collection<String> hostNames, int userId, int contextId) throws OXException {
        return this.delegate.getByHostNames(hostNames, userId, contextId);
    }

    @Override
    public MailAccount[] getUserMailAccounts(int userId, int contextId, Connection con) throws OXException {
        int[] ids = this.delegate.getUserMailAccountIDs(userId, contextId, con);
        MailAccount[] accounts = new MailAccount[ids.length];
        for (int i = 0; i < accounts.length; ++i) {
            accounts[i] = this.getMailAccount0(ids[i], userId, contextId, con);
        }
        return accounts;
    }

    @Override
    public MailAccount getRawMailAccount(int id, int userId, int contextId) throws OXException {
        return this.delegate.getRawMailAccount(id, userId, contextId);
    }

    @Override
    public MailAccount getMailAccount(int id, int userId, int contextId, Connection con) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getMailAccount(id, userId, contextId, con);
        }
        CacheKey key = CachingMailAccountStorage.newCacheKey(cacheService, id, userId, contextId);
        Cache cache = cacheService.getCache(REGION_NAME);
        Object object = cache.get((Serializable)key);
        if (object instanceof MailAccount) {
            return (MailAccount)object;
        }
        MailAccount mailAccount = this.delegate.getMailAccount(id, userId, contextId, con);
        cache.put((Serializable)key, (Serializable)mailAccount, false);
        return mailAccount;
    }

    private MailAccount getMailAccount0(int id, int userId, int contextId, Connection con) throws OXException {
        MailAccount mailAccount;
        CacheKey key;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getMailAccount(id, userId, contextId, con);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        Object object = cache.get((Serializable)(key = CachingMailAccountStorage.newCacheKey(cacheService, id, userId, contextId)));
        if (object == null) {
            mailAccount = this.delegate.getMailAccount(id, userId, contextId, con);
            cache.put((Serializable)key, (Serializable)mailAccount, false);
        }
        if (object instanceof MailAccount) {
            return (MailAccount)object;
        }
        mailAccount = this.delegate.getMailAccount(id, userId, contextId, con);
        cache.put((Serializable)key, (Serializable)mailAccount, false);
        return mailAccount;
    }

    @Override
    public MailAccount[] getUserMailAccounts(int userId, int contextId) throws OXException {
        int[] ids;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            ids = this.delegate.getUserMailAccountIDs(userId, contextId);
        } else {
            CacheKey key;
            Cache cache = cacheService.getCache(REGION_NAME);
            Object object = cache.get((Serializable)(key = CachingMailAccountStorage.accountsCacheKey(cacheService, userId, contextId)));
            if (object instanceof int[]) {
                ids = (int[])object;
            } else {
                ids = this.delegate.getUserMailAccountIDs(userId, contextId);
                cache.put((Serializable)key, (Serializable)ids, false);
            }
        }
        MailAccount[] accounts = new MailAccount[ids.length];
        for (int i = 0; i < accounts.length; ++i) {
            accounts[i] = this.getMailAccount(ids[i], userId, contextId);
        }
        return accounts;
    }

    @Override
    public MailAccount[] resolveLogin(String login, int contextId) throws OXException {
        int[][] idsAndUsers = CachingMailAccountStorage.resolveFromCache(login, contextId, new FromDelegate(){

            @Override
            public int[][] getFromDelegate(String pattern, int contextId) throws OXException {
                return CachingMailAccountStorage.this.getDelegate().resolveLogin2IDs(pattern, contextId);
            }
        }, CachedResolveType.LOGIN);
        MailAccount[] accounts = new MailAccount[idsAndUsers.length];
        for (int i = 0; i < accounts.length; ++i) {
            int[] idAndUser = idsAndUsers[i];
            accounts[i] = this.getMailAccount(idAndUser[0], idAndUser[1], contextId);
        }
        return accounts;
    }

    @Override
    public MailAccount[] resolveLogin(String login, String serverUrl, int contextId) throws OXException {
        int[][] idsAndUsers = CachingMailAccountStorage.resolveFromCache(login, contextId, new FromDelegate(){

            @Override
            public int[][] getFromDelegate(String pattern, int contextId) throws OXException {
                return CachingMailAccountStorage.this.getDelegate().resolveLogin2IDs(pattern, contextId);
            }
        }, CachedResolveType.LOGIN);
        ArrayList<MailAccount> l = new ArrayList<MailAccount>(idsAndUsers.length);
        for (int[] idAndUser : idsAndUsers) {
            MailAccount candidate = this.getMailAccount(idAndUser[0], idAndUser[1], contextId);
            if (!serverUrl.equals(ProviderUtility.toSocketAddrString(candidate.generateMailServerURL(), 143))) continue;
            l.add(candidate);
        }
        return l.toArray(new MailAccount[l.size()]);
    }

    @Override
    public void updateMailAccount(MailAccountDescription mailAccount, Set<Attribute> attributes, int userId, int contextId, Session session) throws OXException {
        if (null != session) {
            session.setParameter("com.openexchange.mailaccount.unifiedMailEnabled", null);
        }
        this.dropSessionParameter(userId, contextId);
        Connection con = Database.get(contextId, true);
        boolean rollback = false;
        try {
            con.setAutoCommit(false);
            rollback = true;
            this.updateMailAccount(mailAccount, attributes, userId, contextId, session, con, false);
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            Database.back(contextId, true, con);
        }
    }

    @Override
    public void updateMailAccount(MailAccountDescription mailAccount, Set<Attribute> attributes, int userId, int contextId, Session session, Connection con, boolean changePrimary) throws OXException {
        CacheService cacheService;
        if (null != session) {
            session.setParameter("com.openexchange.mailaccount.unifiedMailEnabled", null);
        }
        this.dropSessionParameter(userId, contextId);
        this.delegate.updateMailAccount(mailAccount, attributes, userId, contextId, session, con, changePrimary);
        this.invalidateMailAccount(mailAccount.getId(), userId, contextId);
        if (null != con && (cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class)) != null) {
            Cache cache = cacheService.getCache(REGION_NAME);
            CacheKey key = CachingMailAccountStorage.newCacheKey(cacheService, mailAccount.getId(), userId, contextId);
            MailAccount macc = this.delegate.getMailAccount(mailAccount.getId(), userId, contextId, con);
            cache.put((Serializable)key, (Serializable)macc, false);
        }
    }

    @Override
    public void updateMailAccount(MailAccountDescription mailAccount, int userId, int contextId, Session session) throws OXException {
        if (null != session) {
            session.setParameter("com.openexchange.mailaccount.unifiedMailEnabled", null);
        }
        this.dropSessionParameter(userId, contextId);
        MailAccount changedAccount = this.delegate.updateAndReturnMailAccount(mailAccount, userId, contextId, session);
        this.invalidateMailAccount(mailAccount.getId(), userId, contextId);
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService != null) {
            Cache cache = cacheService.getCache(REGION_NAME);
            CacheKey key = CachingMailAccountStorage.newCacheKey(cacheService, mailAccount.getId(), userId, contextId);
            cache.put((Serializable)key, (Serializable)changedAccount, false);
        }
    }

    @Override
    public int insertMailAccount(MailAccountDescription mailAccount, int userId, Context ctx, Session session) throws OXException {
        int id = this.delegate.insertMailAccount(mailAccount, userId, ctx, session);
        this.invalidateMailAccount(id, userId, ctx.getContextId());
        return id;
    }

    @Override
    public int insertMailAccount(MailAccountDescription mailAccount, int userId, Context ctx, Session session, Connection con) throws OXException {
        int id = this.delegate.insertMailAccount(mailAccount, userId, ctx, session, con);
        this.invalidateMailAccount(id, userId, ctx.getContextId());
        return id;
    }

    @Override
    public MailAccount[] resolvePrimaryAddr(String primaryAddress, int contextId) throws OXException {
        int[][] idsAndUsers = CachingMailAccountStorage.resolveFromCache(primaryAddress, contextId, new FromDelegate(){

            @Override
            public int[][] getFromDelegate(String pattern, int contextId) throws OXException {
                return CachingMailAccountStorage.this.getDelegate().resolvePrimaryAddr2IDs(pattern, contextId);
            }
        }, CachedResolveType.PRIMARY_ADDRESS);
        ArrayList<MailAccount> l = new ArrayList<MailAccount>(idsAndUsers.length);
        for (int[] idAndUser : idsAndUsers) {
            l.add(this.getMailAccount(idAndUser[0], idAndUser[1], contextId));
        }
        return l.toArray(new MailAccount[l.size()]);
    }

    private static int[][] resolveFromCache(String pattern, int contextId, FromDelegate delegate, CachedResolveType type) throws OXException {
        int[][] idsAndUsers;
        int[][] tmp;
        Cache cache;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null == cacheService) {
            return delegate.getFromDelegate(pattern, contextId);
        }
        try {
            cache = cacheService.getCache(REGION_NAME);
        }
        catch (OXException e) {
            cache = null;
        }
        if (null == cache) {
            return delegate.getFromDelegate(pattern, contextId);
        }
        CacheKey key = cacheService.newCacheKey(type.ordinal(), pattern);
        try {
            tmp = (int[][])cache.getFromGroup((Serializable)key, Integer.toString(contextId));
        }
        catch (ClassCastException e) {
            tmp = null;
        }
        if (null == tmp) {
            idsAndUsers = delegate.getFromDelegate(pattern, contextId);
            cache.putInGroup((Serializable)key, Integer.toString(contextId), (Serializable)idsAndUsers, false);
        } else {
            idsAndUsers = tmp;
        }
        return idsAndUsers;
    }

    @Override
    public MailAccount getTransportAccountForID(int id, int userId, int contextId) throws OXException {
        MailAccount account = this.getMailAccount(id, userId, contextId);
        if (null == account.getTransportServer()) {
            return this.getDefaultMailAccount(userId, contextId);
        }
        return account;
    }

    @Override
    public void migratePasswords(String oldSecret, String newSecret, Session session) throws OXException {
        this.delegate.migratePasswords(oldSecret, newSecret, session);
        this.invalidateMailAccounts(session.getUserId(), session.getContextId());
    }

    @Override
    public boolean hasAccounts(Session session) throws OXException {
        return this.delegate.hasAccounts(session);
    }

    @Override
    public void cleanUp(String secret, Session session) throws OXException {
        this.delegate.cleanUp(secret, session);
    }

    @Override
    public void removeUnrecoverableItems(String secret, Session session) throws OXException {
        this.delegate.removeUnrecoverableItems(secret, session);
    }

    private static interface FromDelegate {
        public int[][] getFromDelegate(String var1, int var2) throws OXException;
    }
}

