/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import com.openexchange.mail.utils.StorageUtility;
import java.util.Collection;
import javax.mail.FetchProfile;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.search.RecipientStringTerm;
import org.slf4j.LoggerFactory;

public final class CcTerm
extends SearchTerm<String> {
    private static final long serialVersionUID = 4340549452409949555L;
    private String addr;

    public CcTerm(String pattern) {
        try {
            this.addr = new QuotedInternetAddress(pattern, false).getUnicodeAddress();
        }
        catch (AddressException e) {
            this.addr = pattern;
        }
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getPattern() {
        return this.addr;
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        col.add(MailField.CC);
    }

    @Override
    public boolean matches(MailMessage mailMessage) {
        if (this.containsWildcard()) {
            return CcTerm.toRegex(this.addr).matcher(StorageUtility.getAllAddresses(mailMessage.getCc())).find();
        }
        return Strings.asciiLowerCase((String)StorageUtility.getAllAddresses(mailMessage.getCc())).indexOf(Strings.asciiLowerCase((String)this.addr)) != -1;
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        try {
            String[] headers = msg.getHeader("Cc");
            if (null == headers || headers.length == 0) {
                return false;
            }
            InternetAddress[] addresses = MimeMessageUtility.parseAddressList(MimeMessageUtility.decodeMultiEncodedHeader(headers[0]), false, false);
            if (this.containsWildcard()) {
                return CcTerm.toRegex(this.addr).matcher(StorageUtility.getAllAddresses(addresses)).find();
            }
            return Strings.asciiLowerCase((String)StorageUtility.getAllAddresses(addresses)).indexOf(Strings.asciiLowerCase((String)this.addr)) != -1;
        }
        catch (MessagingException e) {
            LoggerFactory.getLogger(CcTerm.class).warn("Error during search.", (Throwable)e);
            return false;
        }
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        return new RecipientStringTerm(Message.RecipientType.CC, this.addr);
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return new RecipientStringTerm(Message.RecipientType.CC, CcTerm.getNonWildcardPart(this.addr));
    }

    @Override
    public void contributeTo(FetchProfile fetchProfile) {
        if (!fetchProfile.contains(FetchProfile.Item.ENVELOPE)) {
            fetchProfile.add(FetchProfile.Item.ENVELOPE);
        }
    }

    @Override
    public boolean isAscii() {
        return CcTerm.isAscii(this.addr);
    }

    @Override
    public boolean containsWildcard() {
        return null == this.addr ? false : this.addr.indexOf(42) >= 0 || this.addr.indexOf(63) >= 0;
    }
}

