/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects.compose;

import com.openexchange.exception.OXException;
import com.openexchange.html.HtmlService;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailPart;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessageRemovedException;

public abstract class TextBodyMailPart
extends MailPart
implements ComposedMailPart {
    private static final long serialVersionUID = 5748081743621854608L;
    private StringBuilder mailBody;
    private StringBuilder plainText;
    private transient DataSource dataSource;

    public TextBodyMailPart(String mailBody) {
        this.mailBody = null == mailBody ? null : new StringBuilder(mailBody);
    }

    public abstract TextBodyMailPart copy() throws OXException;

    protected final void fillInstance(TextBodyMailPart newInstance) {
        newInstance.mailBody = null == this.mailBody ? null : new StringBuilder(this.mailBody.toString());
        newInstance.plainText = null == this.plainText ? null : new StringBuilder(this.plainText.toString());
        newInstance.dataSource = null;
    }

    public void setText(String mailBody) {
        if (null == mailBody) {
            this.mailBody = null;
        }
        if (null == this.mailBody) {
            this.mailBody = new StringBuilder(mailBody);
            return;
        }
        this.mailBody.setLength(0);
        this.mailBody.append(mailBody);
    }

    public void append(String html) {
        if (null == html) {
            return;
        }
        if (null == this.mailBody) {
            this.mailBody = new StringBuilder(html);
            return;
        }
        this.mailBody.append(html);
    }

    public void setPlainText(String text) {
        if (null == text) {
            this.plainText = null;
        } else if (null == this.plainText) {
            this.plainText = new StringBuilder(text);
        } else {
            this.plainText.setLength(0);
            this.plainText.append(text);
        }
    }

    public String getPlainText() {
        return null == this.plainText ? null : this.plainText.toString();
    }

    public String getHTML() {
        return null == this.mailBody ? null : this.mailBody.toString();
    }

    public void appendPlainText(String text) {
        if (null == this.plainText) {
            this.plainText = new StringBuilder(text);
        } else {
            this.plainText.append(text);
        }
    }

    private DataSource getDataSource() throws OXException {
        if (null == this.dataSource) {
            try {
                this.dataSource = new MessageDataSource(this.getHTMLContent(), this.getContentType());
            }
            catch (UnsupportedEncodingException e) {
                throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
            }
        }
        return this.dataSource;
    }

    @Override
    public Object getContent() throws OXException {
        return this.getHTMLContent();
    }

    private String getHTMLContent() throws OXException {
        if (null != this.mailBody) {
            return this.mailBody.toString();
        }
        if (null != this.plainText) {
            HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
            return htmlService.htmlFormat(this.plainText.toString());
        }
        throw MailExceptionCode.UNEXPECTED_ERROR.create("Missing text.");
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        return new DataHandler(this.getDataSource());
    }

    @Override
    public int getEnclosedCount() throws OXException {
        return -1;
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws OXException {
        try {
            return this.getDataSource().getInputStream();
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void loadContent() {
    }

    @Override
    public void prepareForCaching() {
    }

    @Override
    public ComposedMailPart.ComposedPartType getType() {
        return ComposedMailPart.ComposedPartType.BODY;
    }
}

