/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.HeaderName;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.PlainTextAddress;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.tools.TimeZoneUtils;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MailMessage
extends MailPart {
    private static final long serialVersionUID = 8585899349289256569L;
    private static final transient Logger LOG = LoggerFactory.getLogger(MailMessage.class);
    private static final String HDR_REFERENCES = MessageHeaders.HDR_REFERENCES;
    private static final String HDR_MESSAGE_ID = MessageHeaders.HDR_MESSAGE_ID;
    private static final String HDR_IN_REPLY_TO = MessageHeaders.HDR_IN_REPLY_TO;
    public static final int FLAG_ANSWERED = 1;
    public static final int FLAG_DELETED = 2;
    public static final int FLAG_DRAFT = 4;
    public static final int FLAG_FLAGGED = 8;
    public static final int FLAG_RECENT = 16;
    public static final int FLAG_SEEN = 32;
    public static final int FLAG_USER = 64;
    public static final int FLAG_SPAM = 128;
    public static final int FLAG_FORWARDED = 256;
    public static final int FLAG_READ_ACK = 512;
    public static final String USER_FORWARDED = "$Forwarded";
    public static final String USER_READ_ACK = "$MDNSent";
    public static final int PRIORITY_HIGHEST = 1;
    public static final int PRIORITY_HIGH = 2;
    public static final int PRIORITY_NORMAL = 3;
    public static final int PRIORITY_LOW = 4;
    public static final int PRIORITY_LOWEST = 5;
    public static final String COLOR_LABEL_PREFIX = "$cl_";
    public static final String COLOR_LABEL_PREFIX_OLD = "cl_";
    public static final int COLOR_LABEL_NONE = 0;
    private static final Set<String> ALL_COLOR_LABELS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("$cl_0", "$cl_1", "$cl_2", "$cl_3", "$cl_4", "$cl_5", "$cl_6", "$cl_7", "$cl_8", "$cl_9", "$cl_10", "cl_0", "cl_1", "cl_2", "cl_3", "cl_4", "cl_5", "cl_6", "cl_7", "cl_8", "cl_9", "cl_10")));
    private static final InternetAddress[] EMPTY_ADDRS = new InternetAddress[0];
    private int flags;
    private boolean b_flags;
    private boolean prevSeen;
    private boolean b_prevSeen;
    private String[] references;
    private boolean b_references;
    private HashSet<InternetAddress> from;
    private boolean b_from;
    private HashSet<InternetAddress> to;
    private boolean b_to;
    private HashSet<InternetAddress> cc;
    private boolean b_cc;
    private HashSet<InternetAddress> bcc;
    private boolean b_bcc;
    private HashSet<InternetAddress> replyTo;
    private boolean b_replyTo;
    private int threadLevel;
    private boolean b_threadLevel;
    private String subject;
    private boolean b_subject;
    private Date sentDate;
    private boolean b_sentDate;
    private Date receivedDate;
    private boolean b_receivedDate;
    private HashSet<HeaderName> userFlags;
    private boolean b_userFlags;
    private int colorLabel = 0;
    private boolean b_colorLabel;
    private int priority = 3;
    private boolean b_priority;
    private InternetAddress dispositionNotification;
    private boolean b_dispositionNotification;
    private String folder;
    private boolean b_folder;
    private int accountId = 0;
    private boolean b_accountId;
    private String accountName;
    private boolean b_accountName;
    private boolean hasAttachment;
    private boolean b_hasAttachment;
    private boolean appendVCard;
    private boolean b_appendVCard;
    private int recentCount;
    private boolean b_recentCount;
    private String messageId;
    private boolean b_messageId;
    private static final MailDateFormat MAIL_DATE_FORMAT = new MailDateFormat();
    private static final String[] EMPTY_UF;
    private static final Pattern SPLIT;

    public static int getColorLabelIntValue(String cl) throws OXException {
        if (!MailMessage.isColorLabel(cl)) {
            throw MailExceptionCode.UNKNOWN_COLOR_LABEL.create(cl);
        }
        if (!MailMessage.isValidColorLabel(cl)) {
            return 0;
        }
        try {
            return Integer.parseInt(cl.substring(cl.charAt(0) == '$' ? COLOR_LABEL_PREFIX.length() : COLOR_LABEL_PREFIX_OLD.length()));
        }
        catch (NumberFormatException e) {
            throw MailExceptionCode.UNKNOWN_COLOR_LABEL.create(e, cl);
        }
    }

    public static boolean isColorLabel(String cl) {
        return cl != null && (cl.startsWith(COLOR_LABEL_PREFIX) || cl.startsWith(COLOR_LABEL_PREFIX_OLD));
    }

    public static boolean isValidColorLabel(String cl) {
        return ALL_COLOR_LABELS.contains(cl);
    }

    public static int parseColorLabel(String cl, int defaultValue) {
        try {
            return Integer.parseInt(cl.substring('$' == cl.charAt(0) ? COLOR_LABEL_PREFIX.length() : COLOR_LABEL_PREFIX_OLD.length()));
        }
        catch (NumberFormatException e) {
            LOG.debug("Invalid color label: {}", (Object)cl, (Object)e);
            return defaultValue;
        }
    }

    public static String getColorLabelStringValue(int cl) {
        return COLOR_LABEL_PREFIX + cl;
    }

    protected MailMessage() {
    }

    protected void removePersonalsFrom(Set<InternetAddress> addrs) {
        if (null != addrs) {
            for (InternetAddress addr : addrs) {
                try {
                    addr.setPersonal(null);
                }
                catch (UnsupportedEncodingException e) {}
            }
        }
    }

    public void addFrom(InternetAddress addr) {
        if (null == addr) {
            this.b_from = true;
            return;
        }
        if (null == this.from) {
            this.from = new LinkedHashSet<InternetAddress>();
            this.b_from = true;
        }
        this.from.add(addr);
    }

    public void addFrom(InternetAddress[] addrs) {
        if (null == addrs) {
            this.b_from = true;
            return;
        }
        if (null == this.from) {
            this.from = new LinkedHashSet<InternetAddress>();
            this.b_from = true;
        }
        this.from.addAll(Arrays.asList(addrs));
    }

    public void addFrom(Collection<InternetAddress> addrs) {
        if (null == addrs) {
            this.b_from = true;
            return;
        }
        if (null == this.from) {
            this.from = new LinkedHashSet<InternetAddress>();
            this.b_from = true;
        }
        this.from.addAll(addrs);
    }

    public boolean containsFrom() {
        return this.b_from || this.containsHeader(MessageHeaders.HDR_FROM);
    }

    public void removeFrom() {
        this.from = null;
        this.removeHeader(MessageHeaders.HDR_FROM);
        this.b_from = false;
    }

    public InternetAddress[] getFrom() {
        if (!this.b_from) {
            String fromStr = this.getFirstHeader(MessageHeaders.HDR_FROM);
            if (fromStr == null) {
                return EMPTY_ADDRS;
            }
            try {
                this.addFrom(QuotedInternetAddress.parse(fromStr, true));
            }
            catch (AddressException e) {
                LOG.debug("", (Throwable)e);
                this.addFrom(new PlainTextAddress(fromStr));
            }
        }
        return this.from == null ? EMPTY_ADDRS : this.from.toArray(new InternetAddress[this.from.size()]);
    }

    public void removeFromPersonals() {
        this.removePersonalsFrom(this.from);
    }

    public void addTo(InternetAddress addr) {
        if (null == addr) {
            this.b_to = true;
            return;
        }
        if (null == this.to) {
            this.to = new LinkedHashSet<InternetAddress>();
            this.b_to = true;
        }
        this.to.add(addr);
    }

    public void addTo(InternetAddress[] addrs) {
        if (null == addrs) {
            this.b_to = true;
            return;
        }
        if (null == this.to) {
            this.to = new LinkedHashSet<InternetAddress>();
            this.b_to = true;
        }
        this.to.addAll(Arrays.asList(addrs));
    }

    public void addTo(Collection<InternetAddress> addrs) {
        if (null == addrs) {
            this.b_to = true;
            return;
        }
        if (null == this.to) {
            this.to = new LinkedHashSet<InternetAddress>();
            this.b_to = true;
        }
        this.to.addAll(addrs);
    }

    public boolean containsTo() {
        return this.b_to || this.containsHeader(MessageHeaders.HDR_TO);
    }

    public void removeTo() {
        this.to = null;
        this.removeHeader(MessageHeaders.HDR_TO);
        this.b_to = false;
    }

    public InternetAddress[] getTo() {
        if (!this.b_to) {
            String toStr = this.getFirstHeader(MessageHeaders.HDR_TO);
            if (toStr == null) {
                return EMPTY_ADDRS;
            }
            try {
                this.addTo(QuotedInternetAddress.parse(toStr, true));
            }
            catch (AddressException e) {
                LOG.debug("", (Throwable)e);
                this.addTo(new PlainTextAddress(toStr));
            }
        }
        return this.to == null ? EMPTY_ADDRS : this.to.toArray(new InternetAddress[this.to.size()]);
    }

    public void removeToPersonals() {
        this.removePersonalsFrom(this.to);
    }

    public void addCc(InternetAddress addr) {
        if (null == addr) {
            this.b_cc = true;
            return;
        }
        if (null == this.cc) {
            this.cc = new LinkedHashSet<InternetAddress>();
            this.b_cc = true;
        }
        this.cc.add(addr);
    }

    public void addCc(InternetAddress[] addrs) {
        if (null == addrs) {
            this.b_cc = true;
            return;
        }
        if (null == this.cc) {
            this.cc = new LinkedHashSet<InternetAddress>();
            this.b_cc = true;
        }
        this.cc.addAll(Arrays.asList(addrs));
    }

    public void addCc(Collection<InternetAddress> addrs) {
        if (null == addrs) {
            this.b_cc = true;
            return;
        }
        if (null == this.cc) {
            this.cc = new LinkedHashSet<InternetAddress>();
            this.b_cc = true;
        }
        this.cc.addAll(addrs);
    }

    public boolean containsCc() {
        return this.b_cc || this.containsHeader(MessageHeaders.HDR_CC);
    }

    public void removeCc() {
        this.cc = null;
        this.removeHeader(MessageHeaders.HDR_CC);
        this.b_cc = false;
    }

    public InternetAddress[] getCc() {
        if (!this.b_cc) {
            String ccStr = this.getFirstHeader(MessageHeaders.HDR_CC);
            if (ccStr == null) {
                return EMPTY_ADDRS;
            }
            try {
                this.addCc(QuotedInternetAddress.parse(ccStr, true));
            }
            catch (AddressException e) {
                LOG.debug("", (Throwable)e);
                this.addCc(new PlainTextAddress(ccStr));
            }
        }
        return this.cc == null ? EMPTY_ADDRS : this.cc.toArray(new InternetAddress[this.cc.size()]);
    }

    public void removeCcPersonals() {
        this.removePersonalsFrom(this.cc);
    }

    public void addBcc(InternetAddress addr) {
        if (null == addr) {
            this.b_bcc = true;
            return;
        }
        if (null == this.bcc) {
            this.bcc = new LinkedHashSet<InternetAddress>();
            this.b_bcc = true;
        }
        this.bcc.add(addr);
    }

    public void addBcc(InternetAddress[] addrs) {
        if (null == addrs) {
            this.b_bcc = true;
            return;
        }
        if (null == this.bcc) {
            this.bcc = new LinkedHashSet<InternetAddress>();
            this.b_bcc = true;
        }
        this.bcc.addAll(Arrays.asList(addrs));
    }

    public void addBcc(Collection<InternetAddress> addrs) {
        if (null == addrs) {
            this.b_bcc = true;
            return;
        }
        if (null == this.bcc) {
            this.bcc = new LinkedHashSet<InternetAddress>();
            this.b_bcc = true;
        }
        this.bcc.addAll(addrs);
    }

    public boolean containsBcc() {
        return this.b_bcc || this.containsHeader(MessageHeaders.HDR_BCC);
    }

    public void removeBcc() {
        this.bcc = null;
        this.removeHeader(MessageHeaders.HDR_BCC);
        this.b_bcc = false;
    }

    public InternetAddress[] getBcc() {
        if (!this.b_bcc) {
            String bccStr = this.getFirstHeader(MessageHeaders.HDR_BCC);
            if (bccStr == null) {
                return EMPTY_ADDRS;
            }
            try {
                this.addBcc(QuotedInternetAddress.parse(bccStr, true));
            }
            catch (AddressException e) {
                LOG.debug("", (Throwable)e);
                this.addBcc(new PlainTextAddress(bccStr));
            }
        }
        return this.bcc == null ? EMPTY_ADDRS : this.bcc.toArray(new InternetAddress[this.bcc.size()]);
    }

    public void removeBccPersonals() {
        this.removePersonalsFrom(this.bcc);
    }

    public InternetAddress[] getAllRecipients() {
        LinkedHashSet<InternetAddress> set = new LinkedHashSet<InternetAddress>(6);
        set.addAll(Arrays.asList(this.getTo()));
        set.addAll(Arrays.asList(this.getCc()));
        set.addAll(Arrays.asList(this.getBcc()));
        return set.toArray(new InternetAddress[set.size()]);
    }

    public void addReplyTo(InternetAddress addr) {
        if (null == addr) {
            this.b_replyTo = true;
            return;
        }
        if (null == this.replyTo) {
            this.replyTo = new LinkedHashSet<InternetAddress>();
            this.b_replyTo = true;
        }
        this.replyTo.add(addr);
    }

    public void addReplyTo(InternetAddress[] addrs) {
        if (null == addrs) {
            this.b_replyTo = true;
            return;
        }
        if (null == this.replyTo) {
            this.replyTo = new LinkedHashSet<InternetAddress>();
            this.b_replyTo = true;
        }
        this.replyTo.addAll(Arrays.asList(addrs));
    }

    public void addReplyTo(Collection<InternetAddress> addrs) {
        if (null == addrs) {
            this.b_replyTo = true;
            return;
        }
        if (null == this.replyTo) {
            this.replyTo = new LinkedHashSet<InternetAddress>();
            this.b_replyTo = true;
        }
        this.replyTo.addAll(addrs);
    }

    public boolean containsReplyTo() {
        return this.b_replyTo || this.containsHeader(MessageHeaders.HDR_REPLY_TO);
    }

    public void removeReplyTo() {
        this.replyTo = null;
        this.removeHeader(MessageHeaders.HDR_REPLY_TO);
        this.b_replyTo = false;
    }

    public InternetAddress[] getReplyTo() {
        if (!this.b_replyTo) {
            String replyToStr = this.getFirstHeader(MessageHeaders.HDR_REPLY_TO);
            if (replyToStr == null) {
                return EMPTY_ADDRS;
            }
            try {
                this.addReplyTo(QuotedInternetAddress.parse(replyToStr, true));
            }
            catch (AddressException e) {
                LOG.debug("", (Throwable)e);
                this.addReplyTo(new PlainTextAddress(replyToStr));
            }
        }
        return this.replyTo == null ? EMPTY_ADDRS : this.replyTo.toArray(new InternetAddress[this.replyTo.size()]);
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isAnswered() {
        return (this.flags & 1) == 1;
    }

    public boolean isDeleted() {
        return (this.flags & 2) == 2;
    }

    public boolean isDraft() {
        return (this.flags & 4) == 4;
    }

    public boolean isFlagged() {
        return (this.flags & 8) == 8;
    }

    public boolean isRecent() {
        return (this.flags & 0x10) == 16;
    }

    public boolean isSeen() {
        return (this.flags & 0x20) == 32;
    }

    public boolean isUnseen() {
        return !this.isSeen();
    }

    public boolean isSpam() {
        return (this.flags & 0x80) == 128;
    }

    public boolean isForwarded() {
        return (this.flags & 0x100) == 256;
    }

    public boolean isReadAcknowledgment() {
        return (this.flags & 0x200) == 512;
    }

    public boolean isUser() {
        return (this.flags & 0x40) == 64;
    }

    public boolean containsFlags() {
        return this.b_flags;
    }

    public void removeFlags() {
        this.flags = 0;
        this.b_flags = false;
    }

    public void setFlags(int flags) {
        this.flags = flags;
        this.b_flags = true;
    }

    public void setFlag(int flag, boolean enable) throws OXException {
        if (flag == 1 || flag % 2 != 0) {
            throw MailExceptionCode.ILLEGAL_FLAG_ARGUMENT.create(flag);
        }
        this.flags = enable ? this.flags | flag : this.flags & ~flag;
        this.b_flags = true;
    }

    public boolean isPrevSeen() {
        return this.prevSeen;
    }

    public boolean containsPrevSeen() {
        return this.b_prevSeen;
    }

    public void removePrevSeen() {
        this.prevSeen = false;
        this.b_prevSeen = false;
    }

    public void setPrevSeen(boolean prevSeen) {
        this.prevSeen = prevSeen;
        this.b_prevSeen = true;
    }

    public int getThreadLevel() {
        return this.threadLevel;
    }

    public boolean containsThreadLevel() {
        return this.b_threadLevel;
    }

    public void removeThreadLevel() {
        this.threadLevel = 0;
        this.b_threadLevel = false;
    }

    public void setThreadLevel(int threadLevel) {
        this.threadLevel = threadLevel;
        this.b_threadLevel = true;
    }

    public String getSubject() {
        String subjectStr;
        if (!this.b_subject && (subjectStr = MimeMessageUtility.checkNonAscii(this.getFirstHeader(MessageHeaders.HDR_SUBJECT))) != null) {
            this.setSubject(MimeMessageUtility.decodeMultiEncodedHeader(subjectStr));
        }
        return this.subject;
    }

    public boolean containsSubject() {
        return this.b_subject || this.containsHeader(MessageHeaders.HDR_SUBJECT);
    }

    public void removeSubject() {
        this.subject = null;
        this.removeHeader(MessageHeaders.HDR_SUBJECT);
        this.b_subject = false;
    }

    public void setSubject(String subject) {
        this.subject = subject;
        this.b_subject = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getSentDate() {
        Date sentDate;
        String sentDateStr;
        if (!this.b_sentDate && (sentDateStr = this.getFirstHeader(MessageHeaders.HDR_DATE)) != null) {
            MailDateFormat mailDateFormat = MAIL_DATE_FORMAT;
            synchronized (mailDateFormat) {
                try {
                    Date parsedDate = MAIL_DATE_FORMAT.parse(sentDateStr);
                    if (null != parsedDate) {
                        this.setSentDate(parsedDate);
                    }
                }
                catch (ParseException e) {
                    LOG.warn("Date string could not be parsed: {}", (Object)sentDateStr, (Object)e);
                }
            }
        }
        return (sentDate = this.sentDate) == null ? null : new Date(sentDate.getTime());
    }

    public boolean containsSentDate() {
        return this.b_sentDate || this.containsHeader(MessageHeaders.HDR_DATE);
    }

    public void removeSentDate() {
        this.sentDate = null;
        this.removeHeader(MessageHeaders.HDR_DATE);
        this.b_sentDate = false;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate == null ? null : new Date(sentDate.getTime());
        this.b_sentDate = true;
    }

    public Date getReceivedDate() {
        Date receivedDate = this.receivedDate;
        return receivedDate == null ? null : new Date(receivedDate.getTime());
    }

    public Date getReceivedDateDirect() {
        return this.receivedDate;
    }

    public boolean containsReceivedDate() {
        return this.b_receivedDate;
    }

    public void removeReceivedDate() {
        this.receivedDate = null;
        this.b_receivedDate = false;
    }

    public void setReceivedDate(Date receivedDate) {
        this.receivedDate = receivedDate == null ? null : new Date(receivedDate.getTime());
        this.b_receivedDate = true;
    }

    public void addUserFlag(String userFlag) {
        if (userFlag == null) {
            return;
        }
        if (this.userFlags == null) {
            this.userFlags = new HashSet();
            this.b_userFlags = true;
        }
        this.userFlags.add(HeaderName.valueOf(userFlag));
    }

    public void addUserFlags(String[] userFlags) {
        if (userFlags == null) {
            return;
        }
        if (this.userFlags == null) {
            this.userFlags = new HashSet();
            this.b_userFlags = true;
        }
        for (String userFlag : userFlags) {
            this.userFlags.add(HeaderName.valueOf(userFlag));
        }
    }

    public void addUserFlags(Collection<String> userFlags) {
        if (userFlags == null) {
            return;
        }
        if (this.userFlags == null) {
            this.userFlags = new HashSet();
            this.b_userFlags = true;
        }
        for (String userFlag : userFlags) {
            this.userFlags.add(HeaderName.valueOf(userFlag));
        }
    }

    public boolean containsUserFlags() {
        return this.b_userFlags;
    }

    public void removeUserFlags() {
        this.userFlags = null;
        this.b_userFlags = false;
    }

    public String[] getUserFlags() {
        if (this.containsUserFlags() && null != this.userFlags) {
            if (this.userFlags.isEmpty()) {
                return EMPTY_UF;
            }
            int size = this.userFlags.size();
            ArrayList<String> retval = new ArrayList<String>(size);
            Iterator<HeaderName> iter = this.userFlags.iterator();
            for (int i = 0; i < size; ++i) {
                retval.add(iter.next().toString());
            }
            return retval.toArray(new String[size]);
        }
        return EMPTY_UF;
    }

    public int getColorLabel() {
        return this.colorLabel;
    }

    public boolean containsColorLabel() {
        return this.b_colorLabel;
    }

    public void removeColorLabel() {
        this.colorLabel = 0;
        this.b_colorLabel = false;
    }

    public void setColorLabel(int colorLabel) {
        this.colorLabel = colorLabel;
        this.b_colorLabel = true;
    }

    public int getPriority() {
        if (!this.b_priority) {
            String imp = this.getFirstHeader(MessageHeaders.HDR_IMPORTANCE);
            if (imp != null) {
                this.setPriority(MimeMessageConverter.parseImportance(imp));
            } else {
                String prioStr = this.getFirstHeader(MessageHeaders.HDR_X_PRIORITY);
                if (prioStr != null) {
                    this.setPriority(MimeMessageConverter.parsePriority(prioStr));
                }
            }
        }
        return this.priority;
    }

    public boolean containsPriority() {
        return this.b_priority || this.containsHeader(MessageHeaders.HDR_IMPORTANCE) || this.containsHeader(MessageHeaders.HDR_X_PRIORITY);
    }

    public void removePriority() {
        this.priority = 3;
        this.removeHeader(MessageHeaders.HDR_IMPORTANCE);
        this.removeHeader(MessageHeaders.HDR_X_PRIORITY);
        this.b_priority = false;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.b_priority = true;
    }

    public InternetAddress getDispositionNotification() {
        String dispNotTo;
        if (!this.b_dispositionNotification && (dispNotTo = this.getFirstHeader(MessageHeaders.HDR_DISP_NOT_TO)) != null) {
            try {
                this.setDispositionNotification(new QuotedInternetAddress(dispNotTo, false));
            }
            catch (AddressException e) {
                LOG.debug("", (Throwable)e);
                this.setDispositionNotification(new PlainTextAddress(dispNotTo));
            }
        }
        return this.dispositionNotification;
    }

    public boolean containsDispositionNotification() {
        return this.b_dispositionNotification || this.containsHeader(MessageHeaders.HDR_DISP_NOT_TO);
    }

    public void removeDispositionNotification() {
        this.dispositionNotification = null;
        this.removeHeader(MessageHeaders.HDR_DISP_NOT_TO);
        this.b_dispositionNotification = false;
    }

    public void setDispositionNotification(InternetAddress dispositionNotification) {
        this.dispositionNotification = dispositionNotification;
        this.b_dispositionNotification = true;
    }

    public String getFolder() {
        return this.folder;
    }

    public boolean containsFolder() {
        return this.b_folder;
    }

    public void removeFolder() {
        this.folder = null;
        this.b_folder = false;
    }

    public void setFolder(String folder) {
        this.folder = folder;
        this.b_folder = true;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public boolean containsAccountId() {
        return this.b_accountId;
    }

    public void removeAccountId() {
        this.accountId = 0;
        this.b_accountId = false;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
        this.b_accountId = true;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public boolean containsAccountName() {
        return this.b_accountName;
    }

    public void removeAccountName() {
        this.accountName = null;
        this.b_accountName = false;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
        this.b_accountName = true;
    }

    public boolean hasAttachment() {
        return this.hasAttachment;
    }

    public boolean containsHasAttachment() {
        return this.b_hasAttachment;
    }

    public void removeHasAttachment() {
        this.hasAttachment = false;
        this.b_hasAttachment = false;
    }

    public void setHasAttachment(boolean hasAttachment) {
        this.hasAttachment = hasAttachment;
        this.b_hasAttachment = true;
    }

    @Override
    public Object clone() {
        MailMessage clone = (MailMessage)super.clone();
        if (this.from != null) {
            clone.from = new LinkedHashSet<InternetAddress>(this.from);
        }
        if (this.to != null) {
            clone.to = new LinkedHashSet<InternetAddress>(this.to);
        }
        if (this.cc != null) {
            clone.cc = new LinkedHashSet<InternetAddress>(this.cc);
        }
        if (this.bcc != null) {
            clone.bcc = new LinkedHashSet<InternetAddress>(this.bcc);
        }
        if (this.receivedDate != null) {
            clone.receivedDate = new Date(this.receivedDate.getTime());
        }
        if (this.sentDate != null) {
            clone.sentDate = new Date(this.sentDate.getTime());
        }
        if (this.userFlags != null) {
            clone.userFlags = new HashSet<HeaderName>(this.userFlags);
        }
        return clone;
    }

    public boolean isAppendVCard() {
        return this.appendVCard;
    }

    public boolean containsAppendVCard() {
        return this.b_appendVCard;
    }

    public void removeAppendVCard() {
        this.appendVCard = false;
        this.b_appendVCard = false;
    }

    public void setAppendVCard(boolean appendVCard) {
        this.appendVCard = appendVCard;
        this.b_appendVCard = true;
    }

    public int getRecentCount() {
        return this.recentCount;
    }

    public boolean containsRecentCount() {
        return this.b_recentCount;
    }

    public void removeRecentCount() {
        this.recentCount = 0;
        this.b_recentCount = false;
    }

    public void setRecentCount(int recentCount) {
        this.recentCount = recentCount;
        this.b_recentCount = true;
    }

    public MailPath getMailPath() {
        return new MailPath(this.getAccountId(), this.getFolder(), this.getMailId());
    }

    public String getMessageId() {
        if (!this.b_messageId) {
            String messageId = this.getFirstHeader(HDR_MESSAGE_ID);
            if (messageId == null) {
                return null;
            }
            this.setMessageId(messageId);
        }
        return this.messageId;
    }

    public boolean containsMessageId() {
        return this.b_messageId;
    }

    public void removeMessageId() {
        this.messageId = null;
        this.b_messageId = false;
    }

    public void setMessageId(String messageId) {
        this.b_messageId = true;
        this.messageId = messageId;
    }

    public String getInReplyTo() {
        return this.getFirstHeader(HDR_IN_REPLY_TO);
    }

    public String[] getReferences() {
        if (!this.b_references) {
            String references = this.getFirstHeader(HDR_REFERENCES);
            if (references == null) {
                return null;
            }
            this.setReferences(SPLIT.split(MimeMessageUtility.decodeMultiEncodedHeader(references)));
        }
        return this.references;
    }

    public String[] getReferencesOrInReplyTo() {
        String[] stringArray;
        String[] references = this.getReferences();
        if (null != references) {
            return references;
        }
        String inReplyTo = this.getInReplyTo();
        if (null == inReplyTo) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = inReplyTo;
        }
        return stringArray;
    }

    public boolean containsReferences() {
        return this.b_references;
    }

    public void removeReferences() {
        this.references = null;
        this.b_references = false;
    }

    public void setReferences(String sReferences) {
        if (null == sReferences) {
            this.references = null;
            this.b_references = true;
        } else {
            this.setReferences(SPLIT.split(MimeMessageUtility.decodeMultiEncodedHeader(sReferences)));
        }
    }

    public void setReferences(String[] references) {
        if (null == references) {
            this.references = null;
        } else {
            int length = references.length;
            this.references = new String[length];
            System.arraycopy(references, 0, this.references, 0, length);
        }
        this.b_references = true;
    }

    public abstract String getMailId();

    public abstract void setMailId(String var1);

    public abstract int getUnreadMessages();

    public abstract void setUnreadMessages(int var1);

    static {
        MAIL_DATE_FORMAT.setTimeZone(TimeZoneUtils.getTimeZone("GMT"));
        EMPTY_UF = new String[0];
        SPLIT = Pattern.compile(" +");
    }
}

