/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.groupware.upload.impl.UploadUtility;
import com.sun.mail.util.MailConnectException;
import java.net.SocketException;

public enum MailExceptionCode implements DisplayableOXExceptionCode
{
    UNEXPECTED_ERROR("Unexpected error: %1$s", CATEGORY_ERROR, 0),
    MISSING_PARAMETER("Missing parameter %1$s", CATEGORY_ERROR, 1),
    INVALID_PERMISSION("Invalid permission values: fp=%1$s orp=%2$s owp=%3$s odp=%4$s", CATEGORY_ERROR, 2),
    JSON_ERROR("A JSON error occurred: %1$s", CATEGORY_ERROR, 3),
    MISSING_CONNECT_PARAM("Missing parameter in user's mail config: %1$s", CATEGORY_ERROR, 4),
    CONFIG_ERROR("Configuration error: %1$s", CATEGORY_CONFIGURATION, 5),
    INVALID_MULTIPART_CONTENT("Invalid multipart content. Number of enclosed contents is 0", CATEGORY_ERROR, 6),
    UNREADBALE_PART_CONTENT("A part's content could not be read from message %1$s in mail folder %2$s", CATEGORY_USER_INPUT, 7),
    IO_ERROR("An I/O error occurred: %1$s", CATEGORY_ERROR, 8),
    INVALID_MAIL_IDENTIFIER("Invalid message path: %1$s", CATEGORY_ERROR, 9),
    UNKNOWN_COLOR_LABEL("Unknown color label: %1$s", CATEGORY_ERROR, 10),
    INSTANTIATION_PROBLEM("Cannot instantiate class %1$s.", CATEGORY_CONFIGURATION, 11),
    INITIALIZATION_PROBLEM("Cannot initialize mail module", CATEGORY_CONFIGURATION, 12),
    NO_MAIL_ACCESS("No mail module access permitted", "No mail module access permitted.", CATEGORY_PERMISSION_DENIED, 13),
    ACCOUNT_DOES_NOT_EXIST("Mail account is disabled for admin user in context %1$s", "Mail access is disabled for context administrator.", CATEGORY_CONFIGURATION, 14),
    INTERRUPT_ERROR("Process was interrupted. Please try again.", "A temporary error occurred inside the server which prevented it from fulfilling the request. Please try again later.", CATEGORY_TRY_AGAIN, 15),
    ENCODING_ERROR("Unsupported charset encoding: %1$s", CATEGORY_ERROR, 16),
    HEADER_PARSE_ERROR("Header %1$s could not be properly parsed", CATEGORY_ERROR, 17),
    MISSING_DEFAULT_FOLDER_NAME("Missing default %1$s folder in user mail settings", CATEGORY_CONFIGURATION, 18),
    SPAM_HANDLER_INIT_FAILED("Spam handler initialization failed: %1$s", CATEGORY_CONFIGURATION, 19),
    INVALID_CONTENT_TYPE("Invalid content type value: %1$s", CATEGORY_ERROR, 20),
    MESSAGING_ERROR("Messaging error: %1$s", CATEGORY_ERROR, 21),
    INVALID_FIELD("Message field %1$s cannot be handled", CATEGORY_ERROR, 22),
    INVALID_FIELD_EXT("Message field %1$s cannot be handled on server %2$s with login %3$s (user=%4$s, context=%5$s)", CATEGORY_ERROR, 22),
    VERSIT_ERROR("Versit error: %1$s", "Error while converting contact to versit object.", CATEGORY_ERROR, 23),
    NO_ATTACHMENT_FOUND("No attachment was found with id %1$s in message", "No attachment was found with id \"%1$s\" in message.", CATEGORY_USER_INPUT, 24),
    UNSUPPORTED_VERSIT_ATTACHMENT("Versit attachment could not be saved due to an unsupported MIME type: %1$s", "Versit attachment could not be saved due to an unsupported MIME type.", CATEGORY_USER_INPUT, 25),
    INVALID_PARAMETER("Invalid parameter name: %1$s", CATEGORY_ERROR, 26),
    PART_MODIFIER_CREATION_FAILED("Could not create a PartModifier instance from name %1$s", CATEGORY_ERROR, 27),
    UPLOAD_QUOTA_EXCEEDED_FOR_FILE("Upload quota (%1$s) exceeded for file %2$s (size=%3$s)", "Upload quota (%1$s) exceeded for file %2$s (size=%3$s).", CATEGORY_USER_INPUT, 28),
    UPLOAD_QUOTA_EXCEEDED("Upload quota (%1$s) exceeded", "Upload quota (%1$s) exceeded.", CATEGORY_USER_INPUT, 29),
    MISSING_PARAM(MISSING_PARAMETER),
    INVALID_INT_VALUE("Invalid integer value %1$s", CATEGORY_ERROR, 31),
    MAIL_NOT_FOUND("Mail(s) %1$s could not be found in folder %2$s", "Mail could not be found.", CATEGORY_USER_INPUT, 32),
    MAIL_NOT_FOUND_SIMPLE("Mail could not be found", "Mail could not be found.", CATEGORY_USER_INPUT, 32),
    UNSUPPORTED_ACTION("Action %1$s is not supported by %2$s", CATEGORY_ERROR, 33),
    SEND_FAILED_UNKNOWN("Message could not be sent", "Message could not be sent.", CATEGORY_USER_INPUT, 35),
    UNKNOWN_ACTION("Unknown or unsupported action: %1$s", CATEGORY_ERROR, 36),
    MISSING_FIELD("Missing field %1$s", CATEGORY_ERROR, 37),
    UNSUPPORTED_MIME_TYPE("Unsupported MIME type %1$s", CATEGORY_ERROR, 38),
    DELETE_FAILED_OVER_QUOTA("This message could not be moved to trash folder as your mailbox is nearly full. Please try to empty your deleted items first, or delete smaller messages first.", "This message could not be moved to trash folder as your mailbox is nearly full. Please try to empty your deleted items first, or delete smaller messages first.", CATEGORY_CAPACITY, 39),
    PART_NOT_FOUND("The message part with sequence ID %1$s could not be found in message %2$s in folder %3$s.", CATEGORY_ERROR, 40),
    NO_CONTENT("No content available in mail part", "No content available in mail part.", CATEGORY_USER_INPUT, 41),
    COPY_TO_SENT_FOLDER_FAILED_QUOTA("Message has been successfully sent. Due to exceeded quota a copy could not be placed in your sent folder though.", "Message has been successfully sent. Due to exceeded quota a copy could not be placed in your sent folder though.", CATEGORY_CAPACITY, 42),
    COPY_TO_SENT_FOLDER_FAILED("Message has been successfully sent. A copy could not be placed in your sent folder though.", "Message has been successfully sent. A copy could not be placed in your sent folder though.", CATEGORY_WARNING, 43),
    UNKNOWN_PROTOCOL("No provider could be found for protocol/URL \"%1$s\"", CATEGORY_CONFIGURATION, 44),
    PROTOCOL_PARSE_ERROR("Protocol cannot be parsed: %1$s", CATEGORY_ERROR, 45),
    BAD_PARAM_VALUE("Bad value %1$s in parameter %2$s", "Bad value \"%1$s\" in parameter \"%2$s\".", CATEGORY_USER_INPUT, 46),
    NO_MULTIPLE_REPLY("No reply on multiple message possible", "No reply on multiple messages possible.", CATEGORY_USER_INPUT, 47),
    ILLEGAL_FLAG_ARGUMENT("Illegal system flag argument %1$s. Flag must be to the power of 2", CATEGORY_ERROR, 48),
    ATTACHMENT_NOT_FOUND("Attachment %1$s not found inside mail %2$s of mail folder %3$s", "Attachment \"%1$s\" not found inside mail \"%2$s\" of mail folder \"%3$s\".", CATEGORY_USER_INPUT, 49),
    FOLDER_DOES_NOT_HOLD_MESSAGES("Folder %1$s does not hold messages and is therefore not selectable", "Folder \"%1$s\" does not hold messages and is therefore not selectable", CATEGORY_PERMISSION_DENIED, 50),
    FOLDER_DOES_NOT_HOLD_MESSAGES_EXT("Folder %1$s does not hold messages and is therefore not selectable on server %2$s withlogin %3$s (user=%4$s, context=%5$s)", "Folder \"%1$s\" does not hold messages and is therefore not selectable", CATEGORY_PERMISSION_DENIED, 50),
    INSUFFICIENT_FOLDER_ATTR("Insufficient folder attributes: Either existence status or full name have to be present to determine if a mail folder create or update shall be performed", CATEGORY_ERROR, 51),
    NO_ROOT_FOLDER_MODIFY_DELETE("Root folder must not be modified or deleted", "Root folder must not be modified or deleted.", CATEGORY_USER_INPUT, 52),
    UNKNOWN_TRANSPORT_PROTOCOL("No transport provider could be found for protocol/URL \"%1$s\"", CATEGORY_CONFIGURATION, 53),
    MISSING_FULLNAME("Missing mail folder full name", CATEGORY_ERROR, 54),
    IMAGE_ATTACHMENT_NOT_FOUND("Image attachment with content id \"%1$s\" not found inside mail %2$s of mail folder %3$s", "Image attachment with content id \"%1$s\" not found inside mail \"%2$s\" of mail folder \"%3$s\".", CATEGORY_USER_INPUT, 55),
    INVALID_SENDER("The specified E-Mail address %1$s is not covered by allowed E-Mail address aliases.", "The specified E-Mail address \"%1$s\" is not covered by allowed E-Mail address aliases.", CATEGORY_USER_INPUT, 56),
    DEFAULT_FOLDER_CHECK_FAILED("Checking default folders on server %1$s for user %2$s (%3$s) in context on %4$s failed: %5$s", "Checking default folders failed for user %2$s.", CATEGORY_USER_INPUT, 57),
    UNSUPPORTED_DATASOURCE("The types of specified data source are not supported", "The types of specified data source are not supported.", CATEGORY_USER_INPUT, 58),
    UNPARSEABLE_MESSAGE("Mail cannot be parsed. Invalid or incomplete mail data.", "Mail cannot be parsed. Invalid or incomplete mail data.", CATEGORY_USER_INPUT, 59),
    INVALID_FOLDER_NAME_EMPTY("Mail folder cannot be created/renamed. Empty folder name.", "Mail folder cannot be created/renamed. Empty folder name.", CATEGORY_USER_INPUT, 60),
    INVALID_FOLDER_NAME("Invalid folder name: \"%1$s\". Please avoid the following characters: %2$s", "Invalid folder name. Please avoid the following characters: %2$s", CATEGORY_USER_INPUT, 61),
    INVALID_CONTENT_DISPOSITION("Invalid Content-Disposition value: %1$s", CATEGORY_ERROR, 62),
    DUPLICATE_FOLDER("A folder named %1$s already exists.", "A folder named \"%1$s\" already exists.", CATEGORY_PERMISSION_DENIED, 63),
    DUPLICATE_FOLDER_EXT("A folder named %1$s already exists on server %2$s with login %3$s (user=%4$s, context=%5$s).", "A folder named \"%1$s\" already exists.", CATEGORY_PERMISSION_DENIED, 63),
    NO_CREATE_ACCESS("No create access on mail folder %1$s.", "No create access on mail folder \"%1$s\".", CATEGORY_PERMISSION_DENIED, 64),
    NO_CREATE_ACCESS_EXT("No create access on mail folder %1$s on server %2$s with login %3$s (user=%4$s, context=%5$s).", "No create access on mail folder \"%1$s\".", CATEGORY_PERMISSION_DENIED, 64),
    NO_TRANSPORT_SUPPORT("Mail account %1$s with ID %2$s does not support mail transport.", "Mail account \"%1$s\" with ID \"%2$s\" does not support mail transport.", CATEGORY_USER_INPUT, 65),
    FOLDER_NOT_FOUND("Mail folder could not be found: %1$s.", "Mail folder could not be found.", CATEGORY_USER_INPUT, 66),
    FOLDER_NOT_FOUND_SIMPLE("Mail folder could not be found.", "Mail folder could not be found.", CATEGORY_USER_INPUT, 66),
    REFERENCED_MAIL_NOT_FOUND("Referenced mail %1$s could not be found in folder %2$s. Therefore reply/forward operation cannot be performed.", "Referenced mail \"%1$s\" could not be found in folder \"%2$s\".", CATEGORY_USER_INPUT, 67),
    PATTERN_TOO_SHORT("In order to accomplish the search, %1$d or more characters are required.", "In order to accomplish the search, %1$d or more characters are required.", CATEGORY_USER_INPUT, 68),
    FOLDER_DELETION_DENIED("Mail folder must not be deleted: %1$s.", "Mail folder must not be deleted.", CATEGORY_USER_INPUT, 69),
    NO_DELETE_ACCESS("No delete access on mail folder: %1$s.", "No delete access on mail folder \"%1$s\".", CATEGORY_PERMISSION_DENIED, 70),
    FOLDER_MOVE_DENIED("Mail folder must not be moved: %1$s.", "Mail folder must not be moved.", CATEGORY_USER_INPUT, 71),
    FOLDER_UPDATE_DENIED("Mail folder must not be updated: %1$s.", "Mail folder must not be updated.", CATEGORY_USER_INPUT, 72),
    NO_WRITE_ACCESS("No write access on mail folder: %1$s.", "No write access on mail folder \"%1$s\".", CATEGORY_PERMISSION_DENIED, 73),
    NOT_CONNECTED("No connection available to access mailbox", "No connection available to access mailbox", CATEGORY_USER_INPUT, 74),
    MAIL_NOT_FOUN_BY_MESSAGE_ID("Mail could not be found in folder %1$s for message identifier: %2$s", "Mail could not be found in folder \"%1$s\" by message identifier.", CATEGORY_USER_INPUT, 32),
    SENT_QUOTA_EXCEEDED("Sent quota exceeded. You are only allowed to send 1 E-Mail in %1$s seconds.", "Sent quota exceeded. You are only allowed to send 1 E-Mail in %1$s seconds.", CATEGORY_USER_INPUT, 75),
    RECIPIENTS_EXCEEDED("Please limit your recipients to %1$s  (including To/Cc/Bcc), and click 'Send' again.", "Please limit your recipients to %1$s  (including To/Cc/Bcc), and click 'Send' again.", CATEGORY_USER_INPUT, 76),
    URI_PARSE_FAILED("Unable to parse mail server URI \"%1$s\".", "Unable to parse mail server URI \"%1$s\".", CATEGORY_USER_INPUT, 77),
    ATTACHMENT_EXPIRED("Mail attachment expired or absent.", "Mail attachment expired or absent.", CATEGORY_USER_INPUT, 78),
    NON_SECURE_WARNING("Account has been checked successfully but with a non-secure connection.", "Account has been checked successfully but with a non-secure connection.", CATEGORY_WARNING, 79),
    TOO_MANY_FORWARD_MAILS("Cannot forward more than %1$s messages at once. Please divide the messages to forward in chunks of appropriate size.", "Cannot forward more than %1$s messages at once. Please divide the messages to forward in chunks of appropriate size.", CATEGORY_USER_INPUT, 80),
    NON_SECURE_CREATION("Your account has been created but will not use a secure connection.", "Your account has been created but will not use a secure connection.", CATEGORY_WARNING, 81),
    FLAG_FAIL("Your E-Mail has been successfully sent, but the original E-Mail could not be flagged as \"replied\" and/or \"forwarded\".", "Your E-Mail has been successfully sent, but the original E-Mail could not be flagged as \"replied\" and/or \"forwarded\".", CATEGORY_WARNING, 82),
    INVALID_FOLDER_NAME2("Invalid folder name: \"%1$s\"", "Invalid folder name. Please avoid the following characters: %2$s", INVALID_FOLDER_NAME.getCategory(), INVALID_FOLDER_NAME.getNumber()),
    INVALID_FOLDER_NAME_TOO_LONG("Mail folder cannot be created/renamed. Folder name exceeds max length of %1$s.", "Mail folder cannot be created/renamed. Folder name exceeds max length of %1$s.", CATEGORY_USER_INPUT, 83),
    USED_PUBLISHING_FEATURE("The attachments to this E-Mail exceeded the size limit for attachments. Instead of sending the attachment with the E-Mail, the attachment was published and the link added to your E-Mail. Whoever receives the E-Mail can then download the attachment.", "The attachments to this E-Mail exceeded the size limit for attachments. Instead of sending the attachment with the E-Mail, the attachment was published and the link added to your E-Mail. Whoever receives the E-Mail can then download the attachment.", CATEGORY_WARNING, 84),
    DRAFT_FAILED_UNKNOWN("Draft message could not be saved", "Draft message could not be saved.", CATEGORY_USER_INPUT, 85),
    PROCESSING_ERROR("There was a problem processing the request. Please (refresh view and) try again.", "A messaging error occurred. Please try again later.", CATEGORY_TRY_AGAIN, 86),
    UNSUPPORTED_OPERATION("Invoked method is not supported.", CATEGORY_ERROR, 87),
    MAX_MESSAGE_SIZE_EXCEEDED("Maximum message size is exceeded. Max. is %1$s.", "Maximum message size is exceeded. Max. is %1$s.", CATEGORY_USER_INPUT, 88),
    RESEND_DENIED("Re-sending message denied because message is not located in %1$s folder.", "Re-sending message denied because message is not located in \"%1$s\" folder.", CATEGORY_USER_INPUT, 89),
    PING_FAILED("Ping to server %1$s failed for login %2$s with reason: %3$s", "Validation of server %1$s failed with reason: %3$s", CATEGORY_WARNING, 90),
    PING_FAILED_AUTH("Ping to server %1$s failed with login %2$s due to invalid credentials.", "Validation of server %1$s failed due to invalid credentials", CATEGORY_WARNING, 91),
    NON_SECURE_DENIED("Server %1$s does not support being accessed using a secure connection.", "Server %1$s does not support being accessed using a secure connection.", CATEGORY_WARNING, 92),
    ILLEGAL_ARGUMENT("Invalid argument(s) supplied.", CATEGORY_ERROR, 93),
    MAX_DRIVE_ATTACHMENTS_EXCEEDED("The maximum number of files that may be attached to an E-Mail is exceeded. Max. is %1$s.", "The maximum number of files that may be attached to an E-Mail is exceeded. Max. is %1$s.", CATEGORY_USER_INPUT, 94),
    REQUEST_NOT_PERMITTED("The client request is not permitted. Details: %1$s", "The client request is not permitted.", CATEGORY_PERMISSION_DENIED, 95),
    SEND_DENIED("Sending the message denied.", "Sending the message denied.", CATEGORY_PERMISSION_DENIED, 96);

    private static String PREFIX;
    private String message;
    private String displayMessage;
    private int number;
    private Category category;

    public static String prefix() {
        return PREFIX;
    }

    public static boolean hasPrefix(OXException e) {
        if (null == e) {
            return false;
        }
        return PREFIX.equals(e.getPrefix());
    }

    private MailExceptionCode(String message, Category category, int detailNumber) {
        this(message, null, category, detailNumber);
    }

    private MailExceptionCode(String message, String displayMessage, Category category, int detailNumber) {
        this.message = message;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
        this.number = detailNumber;
        this.category = category;
    }

    private MailExceptionCode(MailExceptionCode source) {
        this.message = source.message;
        this.number = source.number;
        this.category = source.category;
    }

    public String getPrefix() {
        return PREFIX;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.number;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Category category, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, category, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }

    public OXException create(Category category, Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, category, cause, args);
    }

    public static String getSize(long size, int precision, boolean longName, boolean realSize) {
        return UploadUtility.getSize(size, precision, longName, realSize);
    }

    public static boolean containsSocketError(OXException e) {
        if (null == e) {
            return false;
        }
        return MailExceptionCode.containsSocketError0(e.getCause());
    }

    private static boolean containsSocketError0(Throwable t) {
        if (null == t) {
            return false;
        }
        if (t instanceof MailConnectException || t instanceof SocketException) {
            return true;
        }
        return MailExceptionCode.containsSocketError0(t.getCause());
    }

    static {
        PREFIX = "MSG";
    }
}

