/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.login.internal;

import com.openexchange.authentication.Authenticated;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.authentication.service.Authentication;
import com.openexchange.exception.OXException;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.internal.LoginMethodClosure;
import com.openexchange.login.internal.LoginResultImpl;
import java.util.Map;

final class AutoLoginMethod
implements LoginMethodClosure {
    private final LoginRequest request;
    private final Map<String, Object> properties;

    AutoLoginMethod(LoginRequest request, Map<String, Object> properties) {
        this.request = request;
        this.properties = properties;
    }

    @Override
    public Authenticated doAuthentication(LoginResultImpl retval) throws OXException {
        try {
            return Authentication.autologin(this.request.getLogin(), this.request.getPassword(), this.properties);
        }
        catch (OXException e) {
            if (LoginExceptionCodes.NOT_SUPPORTED.equals(e)) {
                return null;
            }
            throw e;
        }
    }
}

