/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.login;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataBuilder;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.exception.OXException;
import com.openexchange.login.LoginRampUpService;
import com.openexchange.osgi.ExceptionUtils;
import com.openexchange.server.ServiceLookup;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.tools.session.ServerSession;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultAppSuiteLoginRampUp
implements LoginRampUpService {
    protected final ServiceLookup services;
    private static final RampUpKey[] KEYS = RampUpKey.values();

    protected DefaultAppSuiteLoginRampUp(ServiceLookup services) {
        this.services = services;
    }

    @Override
    public JSONObject getContribution(final ServerSession session, final AJAXRequestData loginRequest) throws OXException {
        int numberOfKeys = KEYS.length;
        ConcurrentHashMap<String, Future> rampUps = new ConcurrentHashMap<String, Future>(numberOfKeys);
        ThreadPoolService threads = (ThreadPoolService)this.services.getService(ThreadPoolService.class);
        final Dispatcher ox = (Dispatcher)this.services.getService(Dispatcher.class);
        rampUps.put(RampUpKey.FOLDER_LIST.key, threads.submit((Task)new AbstractTask<Object>(){

            public Object call() throws Exception {
                try {
                    JSONObject folderlist = new JSONObject(2);
                    folderlist.put("1", ox.perform(AJAXRequestDataBuilder.request().module("folders").action("list").params("parent", "1", "tree", "0", "altNames", "true", "timezone", "UTC", "columns", "1,2,3,4,5,6,20,23,300,301,302,304,305,306,307,308,309,310,311,312,313,314,315,316,317,3010,3020,3030").format("json").build(), null, session).getResultObject());
                    return folderlist;
                }
                catch (OXException oXException) {
                    return null;
                }
            }
        }));
        rampUps.put(RampUpKey.FOLDER.key, threads.submit((Task)new AbstractTask<Object>(){

            public Object call() throws Exception {
                JSONObject folder = new JSONObject(3);
                try {
                    folder.put("1", ox.perform(AJAXRequestDataBuilder.request().module("folders").action("get").params("id", "1", "tree", "1", "altNames", "true", "timezone", "UTC").format("json").build(), null, session).getResultObject());
                }
                catch (OXException x) {
                    // empty catch block
                }
                try {
                    folder.put("default0/INBOX", ox.perform(AJAXRequestDataBuilder.request().module("folders").action("get").params("id", "default0/INBOX", "tree", "1", "altNames", "true", "timezone", "UTC").format("json").build(), null, session).getResultObject());
                }
                catch (OXException oXException) {
                    // empty catch block
                }
                return folder;
            }
        }));
        rampUps.put(RampUpKey.JSLOBS.key, threads.submit((Task)new AbstractTask<Object>(){

            public Object call() throws Exception {
                try {
                    JSONObject jslobs = new JSONObject();
                    JSONArray lobs = (JSONArray)ox.perform(AJAXRequestDataBuilder.request().module("jslob").action("list").data(new JSONArray(Arrays.asList("io.ox/core", "io.ox/core/updates", "io.ox/mail", "io.ox/contacts", "io.ox/calendar", "io.ox/caldav", "io.ox/files", "io.ox/tours", "io.ox/mail/emoji", "io.ox/tasks", "io.ox/office")), "json").format("json").build(), null, session).getResultObject();
                    int size = lobs.length();
                    for (int i = 0; i < size; ++i) {
                        JSONObject lob = lobs.getJSONObject(i);
                        jslobs.put(lob.getString("id"), (Object)lob);
                    }
                    return jslobs;
                }
                catch (OXException oXException) {
                    return null;
                }
            }
        }));
        rampUps.put(RampUpKey.SERVER_CONFIG.key, threads.submit((Task)new AbstractTask<Object>(){

            public Object call() throws Exception {
                AJAXRequestData manifestRequest = AJAXRequestDataBuilder.request().module("apps/manifests").action("config").format("json").hostname(loginRequest.getHostname()).build();
                try {
                    return ox.perform(manifestRequest, null, session).getResultObject();
                }
                catch (OXException oXException) {
                    return null;
                }
            }
        }));
        rampUps.put(RampUpKey.OAUTH.key, threads.submit((Task)new AbstractTask<Object>(){

            public Object call() throws Exception {
                JSONObject oauth = new JSONObject(3);
                try {
                    oauth.put("services", ox.perform(AJAXRequestDataBuilder.request().module("oauth/services").action("all").format("json").build(), null, session).getResultObject());
                }
                catch (OXException x) {
                    // empty catch block
                }
                try {
                    oauth.put("accounts", ox.perform(AJAXRequestDataBuilder.request().module("oauth/accounts").action("all").format("json").build(), null, session).getResultObject());
                }
                catch (OXException x) {
                    // empty catch block
                }
                try {
                    oauth.put("secretCheck", ox.perform(AJAXRequestDataBuilder.request().module("recovery/secret").action("check").format("json").build(), null, session).getResultObject());
                }
                catch (OXException oXException) {
                    // empty catch block
                }
                return oauth;
            }
        }));
        rampUps.put(RampUpKey.USER.key, threads.submit((Task)new AbstractTask<Object>(){

            public Object call() throws Exception {
                try {
                    return ox.perform(AJAXRequestDataBuilder.request().module("user").action("get").params("timezone", "utc", "id", "" + session.getUserId()).format("json").build(), null, session).getResultObject();
                }
                catch (OXException oXException) {
                    return null;
                }
            }
        }));
        rampUps.put(RampUpKey.ACCOUNTS.key, threads.submit((Task)new AbstractTask<Object>(){

            public Object call() throws Exception {
                try {
                    return ox.perform(AJAXRequestDataBuilder.request().module("account").action("all").format("json").params("columns", "1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,1012,1013,1014,1015,1016,1017,1018,1019,1020,1021,1022,1023,1024,1025,1026,1027,1028,1029,1030,1031,1032,1033,1034,1035,1036,1037,1038,1039,1040,1041,1042,1043").build(), null, session).getResultObject();
                }
                catch (OXException oXException) {
                    return null;
                }
            }
        }));
        try {
            JSONObject jo = new JSONObject(numberOfKeys);
            for (RampUpKey rampUpKey : KEYS) {
                Object value = ((Future)rampUps.get(rampUpKey.key)).get();
                jo.put(rampUpKey.key, JSONCoercion.coerceToJSON(value));
            }
            return jo;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            Logger logger = LoggerFactory.getLogger(DefaultAppSuiteLoginRampUp.class);
            logger.warn("Failed ramp-up", t);
            return new JSONObject();
        }
    }

    public static enum RampUpKey {
        SERVER_CONFIG("serverConfig"),
        JSLOBS("jslobs"),
        OAUTH("oauth"),
        FOLDER("folder"),
        FOLDER_LIST("folderlist"),
        USER("user"),
        ACCOUNTS("accounts");

        public final String key;

        private RampUpKey(String key) {
            this.key = key;
        }
    }
}

