/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.MailAccountCreateTablesTask;
import com.openexchange.groupware.update.tasks.POP3CreateTableTask;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public final class POP3CheckAndDropObsoleteTablesTask
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[]{MailAccountCreateTablesTask.class.getName(), POP3CreateTableTask.class.getName()};
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        boolean modified = false;
        Connection con = null;
        boolean rollback = false;
        try {
            con = dbService.getForUpdateTask(cid);
            con.setAutoCommit(false);
            rollback = true;
            for (String table : new String[]{"user_pop3_data", "user_pop3_user_flag"}) {
                modified |= this.dropTable(table, con);
            }
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            if (modified) {
                dbService.backForUpdateTask(cid, con);
            } else {
                dbService.backForUpdateTaskAfterReading(cid, con);
            }
        }
    }

    private boolean dropTable(String table, Connection con) throws SQLException {
        if (!Tools.tableExists(con, table)) {
            return false;
        }
        return Tools.dropTable(con, table);
    }
}

