/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MigrateAliasUpdateTask
extends UpdateTaskAdapter {
    private static final String NEW_TABLE_NAME = "user_alias";
    private static final String CREATE_ALIAS_TABLE = "CREATE TABLE `user_alias` ( `cid` INT4 UNSIGNED NOT NULL, `user` INT4 UNSIGNED NOT NULL, `alias` VARCHAR(255) NOT NULL, PRIMARY KEY (`cid`, `user`, `alias`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    private static final String SELECT_OLD_ALIAS_ENTRIES = "SELECT cid, id, value, name FROM user_attribute WHERE name='alias'";
    private static final String INSERT_ALIAS_IN_NEW_TABLE = "INSERT INTO user_alias (cid, user, alias) VALUES(?, ?, ?)";

    @Override
    public void perform(PerformParameters params) throws OXException {
        int ctxId = params.getContextId();
        Connection conn = Database.getNoTimeout(ctxId, true);
        try {
            List<Alias> aliase;
            conn.setAutoCommit(false);
            if (!Tools.tableExists(conn, NEW_TABLE_NAME)) {
                this.createTable(conn);
            }
            if ((aliase = this.getAllAliasesInUserAttributes(conn)) != null && !aliase.isEmpty()) {
                this.insertAliases(conn, aliase);
            }
            conn.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(conn);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(conn);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(conn);
            Database.backNoTimeout(ctxId, true, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(Connection conn) throws SQLException {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.execute(CREATE_ALIAS_TABLE);
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Alias> getAllAliasesInUserAttributes(Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(SELECT_OLD_ALIAS_ENTRIES);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                List<Alias> list = Collections.emptyList();
                return list;
            }
            LinkedList<Alias> aliases = new LinkedList<Alias>();
            do {
                int index = 0;
                int cid = rs.getInt(++index);
                int uid = rs.getInt(++index);
                String alias = rs.getString(++index);
                aliases.add(new Alias(cid, uid, alias));
            } while (rs.next());
            LinkedList<Alias> linkedList = aliases;
            return linkedList;
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertAliases(Connection conn, List<Alias> aliases) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(INSERT_ALIAS_IN_NEW_TABLE);
            for (Alias alias : aliases) {
                int index = 0;
                stmt.setInt(++index, alias.getCid());
                stmt.setInt(++index, alias.getUserId());
                stmt.setString(++index, alias.getAlias());
                stmt.addBatch();
            }
            int[] updateCounts = stmt.executeBatch();
            int updated = 0;
            for (int updateCount : updateCounts) {
                updated += updateCount;
            }
            int n = updated;
            return n;
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BLOCKING);
    }

    private class Alias {
        private final int cid;
        private final int userId;
        private final String alias;

        public Alias(int cid, int userId, String alias) {
            this.cid = cid;
            this.userId = userId;
            this.alias = alias;
        }

        public int getCid() {
            return this.cid;
        }

        public int getUserId() {
            return this.userId;
        }

        public String getAlias() {
            return this.alias;
        }
    }
}

