/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class CreateGenconfTablesTask
implements UpdateTask {
    private static final String STRING_TABLE_CREATE_PRIMARY_KEY = "CREATE TABLE `genconf_attributes_strings` ( `cid` INT4 unsigned NOT NULL,`id` INT4 unsigned NOT NULL,`name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,`value` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL,`uuid` BINARY(16) NOT NULL,PRIMARY KEY (cid, id, uuid),KEY (`cid`,`id`,`name`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    private static final String BOOL_TABLE_CREATE_PRIMARY_KEY = "CREATE TABLE `genconf_attributes_bools` (`cid` INT4 unsigned NOT NULL,`id` INT4 unsigned NOT NULL,`name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,`value` tinyint(1) COLLATE utf8_unicode_ci DEFAULT NULL,`uuid` BINARY(16) NOT NULL,PRIMARY KEY (cid, id, uuid),KEY (`cid`,`id`,`name`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    private static final String SEQUENCE_TABLE_CREATE = "CREATE TABLE `sequence_genconf` (`cid` INT4 unsigned NOT NULL,`id` INT4 unsigned NOT NULL,PRIMARY KEY (`cid`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    private static final String INSERT_IN_SEQUENCE = "INSERT INTO sequence_genconf (cid, id) VALUES (?, 0)";

    @Override
    public int addedWithVersion() {
        return 44;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection con = null;
        try {
            con = Database.getNoTimeout(contextId, true);
            if (!Tools.tableExists(con, "genconf_attributes_strings")) {
                Tools.exec(con, STRING_TABLE_CREATE_PRIMARY_KEY, new Object[0]);
            }
            if (!Tools.tableExists(con, "genconf_attributes_bools")) {
                Tools.exec(con, BOOL_TABLE_CREATE_PRIMARY_KEY, new Object[0]);
            }
            if (!Tools.tableExists(con, "sequence_genconf")) {
                Tools.exec(con, SEQUENCE_TABLE_CREATE, new Object[0]);
            }
            for (int ctxId : Tools.getContextIDs(con)) {
                if (Tools.hasSequenceEntry("sequence_genconf", con, ctxId)) continue;
                Tools.exec(con, INSERT_IN_SEQUENCE, ctxId);
            }
        }
        catch (SQLException e) {
            throw CreateGenconfTablesTask.createSQLError(e);
        }
        finally {
            if (con != null) {
                Database.backNoTimeout(contextId, true, con);
            }
        }
    }

    private static OXException createSQLError(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }
}

