/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.SchemaStore;
import com.openexchange.groupware.update.SchemaUpdateState;
import com.openexchange.groupware.update.SeparatedTasks;
import com.openexchange.groupware.update.UpdateStatus;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.Updater;
import com.openexchange.groupware.update.internal.LocalUpdateTaskMonitor;
import com.openexchange.groupware.update.internal.UpdateProcess;
import com.openexchange.groupware.update.internal.UpdateTaskCollection;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.TimerService;
import java.util.Collection;
import java.util.List;

public class UpdaterImpl
extends Updater {
    @Override
    public UpdateStatus getStatus(int contextId) throws OXException {
        return this.getStatus(this.getSchema(contextId));
    }

    @Override
    public UpdateStatus getStatus(String schema, int writePoolId) throws OXException {
        return this.getStatus(this.getSchema(writePoolId, schema));
    }

    private UpdateStatus getStatus(final SchemaUpdateState schema) {
        final SeparatedTasks tasks2 = UpdateTaskCollection.getInstance().getFilteredAndSeparatedTasks(schema);
        return new UpdateStatus(){

            @Override
            public boolean needsBlockingUpdates() {
                return tasks2.getBlocking().size() > 0;
            }

            @Override
            public boolean needsBackgroundUpdates() {
                return tasks2.getBackground().size() > 0;
            }

            @Override
            public boolean blockingUpdatesRunning() {
                return schema.isLocked();
            }

            @Override
            public boolean backgroundUpdatesRunning() {
                return schema.backgroundUpdatesRunning();
            }
        };
    }

    @Override
    public void startUpdate(int contextId) throws OXException {
        TimerService timerService = ServerServiceRegistry.getInstance().getService(TimerService.class, true);
        timerService.schedule((Runnable)new UpdateProcess(contextId), 0L);
    }

    private SchemaUpdateState getSchema(int contextId) throws OXException {
        return SchemaStore.getInstance().getSchema(contextId);
    }

    private SchemaUpdateState getSchema(int poolId, String schemaName) throws OXException {
        return SchemaStore.getInstance().getSchema(poolId, schemaName);
    }

    @Override
    public UpdateTask[] getAvailableUpdateTasks() {
        List<UpdateTask> retval = UpdateTaskCollection.getInstance().getListWithoutExcludes();
        return retval.toArray(new UpdateTask[retval.size()]);
    }

    @Override
    public Collection<String> getLocallyScheduledTasks() {
        return LocalUpdateTaskMonitor.getInstance().getScheduledStates();
    }
}

