/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.groupware.ldap.RdbUserStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserAttribute;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.user.internal.mapping.UserField;
import com.openexchange.user.internal.mapping.UserMapper;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingUserStorage
extends UserStorage {
    private static final Logger LOG = LoggerFactory.getLogger(CachingUserStorage.class);
    static final String REGION_NAME = "User";
    private final RdbUserStorage delegate;

    public CachingUserStorage(RdbUserStorage delegate) {
        this.delegate = delegate;
    }

    @Override
    public User getUser(int uid, Context context) throws OXException {
        CacheKey key;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getUser(uid, context);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        Object object = cache.get((Serializable)(key = cacheService.newCacheKey(context.getContextId(), uid)));
        if (object instanceof User) {
            return (User)object;
        }
        User user = this.delegate.getUser(uid, context);
        cache.put((Serializable)key, (Serializable)user, false);
        return user;
    }

    @Override
    public User loadIfAbsent(int userId, Context context, Connection con) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getUser(userId, context);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        Object object = cache.get((Serializable)cacheService.newCacheKey(context.getContextId(), userId));
        if (object instanceof User) {
            return (User)object;
        }
        User user = this.delegate.getUser(context, userId, con);
        cache.put((Serializable)cacheService.newCacheKey(context.getContextId(), userId), (Serializable)user, false);
        return user;
    }

    @Override
    public int createUser(Connection con, Context context, User user) throws OXException {
        return this.delegate.createUser(con, context, user);
    }

    @Override
    public int createUser(Context context, User user) throws OXException {
        return this.delegate.createUser(context, user);
    }

    @Override
    public User getUser(Context ctx, int userId, Connection con) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getUser(ctx, userId, con);
        }
        User user = this.delegate.getUser(ctx, userId, con);
        cacheService.getCache(REGION_NAME).put((Serializable)cacheService.newCacheKey(ctx.getContextId(), user.getId()), (Serializable)user, false);
        return user;
    }

    @Override
    public User[] getUser(Context ctx) throws OXException {
        return this.getUser(ctx, this.listAllUser(ctx));
    }

    @Override
    public User[] getUser(Context ctx, int[] userIds) throws OXException {
        User[] loaded;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getUser(ctx, userIds);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        TIntObjectHashMap map = new TIntObjectHashMap(userIds.length, 1.0f);
        ArrayList<Integer> toLoad = new ArrayList<Integer>(userIds.length);
        int contextId = ctx.getContextId();
        for (int userId : userIds) {
            Object object = cache.get((Serializable)cacheService.newCacheKey(contextId, userId));
            if (object instanceof User) {
                map.put(userId, (Object)((User)object));
                continue;
            }
            toLoad.add(Autoboxing.I((int)userId));
        }
        for (User user : loaded = this.delegate.getUser(ctx, Autoboxing.I2i(toLoad))) {
            cache.put((Serializable)cacheService.newCacheKey(contextId, user.getId()), (Serializable)user, false);
            map.put(user.getId(), (Object)user);
        }
        ArrayList<Object> retval = new ArrayList<Object>(userIds.length);
        for (int userId : userIds) {
            retval.add(map.get(userId));
        }
        return retval.toArray(new User[retval.size()]);
    }

    @Override
    public void updateUserInternal(User user, Context context) throws OXException {
        Cache cache;
        Object object;
        boolean doUpdate = false;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService != null && (object = (cache = cacheService.getCache(REGION_NAME)).get((Serializable)cacheService.newCacheKey(context.getContextId(), user.getId()))) instanceof User) {
            User oldUser = (User)object;
            User differences = (User)new UserMapper().getDifferences(oldUser, user);
            boolean bl = doUpdate = ((UserField[])new UserMapper().getAssignedFields(differences)).length != 0;
            if (!doUpdate && null != user.getAttributes()) {
                Map<String, UserAttribute> oldAttributes = UserImpl.toInternal(oldUser.getAttributes());
                Map<String, UserAttribute> attributes = UserImpl.toInternal(user.getAttributes());
                HashMap<String, UserAttribute> added = new HashMap<String, UserAttribute>();
                HashMap<String, UserAttribute> removed = new HashMap<String, UserAttribute>();
                HashMap<String, UserAttribute> changed = new HashMap<String, UserAttribute>();
                RdbUserStorage.calculateDifferences(oldAttributes, attributes, added, removed, changed);
                boolean bl2 = doUpdate = !added.isEmpty() || !removed.isEmpty() || !changed.isEmpty();
            }
        }
        if (doUpdate) {
            this.delegate.updateUser(user, context);
            this.invalidateUser(context, user.getId());
        }
    }

    @Override
    public String getUserAttribute(String name, int userId, Context context) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getUserAttribute(name, userId, context);
        }
        Set<String> set = this.getUser(userId, context).getAttributes().get("attr_" + name);
        return null == set ? null : (set.isEmpty() ? null : set.iterator().next());
    }

    @Override
    public void setUserAttribute(String name, String value, int userId, Context context) throws OXException {
        this.delegate.setUserAttribute(name, value, userId, context);
        this.invalidateUserCache(context, userId);
    }

    @Override
    public void setAttribute(String name, String value, int userId, Context context) throws OXException {
        if (null == name) {
            throw LdapExceptionCode.UNEXPECTED_ERROR.create("Attribute name is null.").setPrefix("USR");
        }
        if (name.startsWith("client:")) {
            CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
            if (cacheService == null) {
                this.delegate.setAttribute(name, value, userId, context);
            } else {
                User updatedUser = this.delegate.setAttributeAndReturnUser(name, value, userId, context, true);
                Cache cache = cacheService.getCache(REGION_NAME);
                CacheKey key = cacheService.newCacheKey(context.getContextId(), userId);
                cache.put((Serializable)key, (Serializable)updatedUser, false);
            }
        } else {
            this.delegate.setAttribute(name, value, userId, context);
            this.invalidateUserCache(context, userId);
        }
    }

    @Override
    public int getUserId(String uid, Context context) throws OXException {
        Integer tmp;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null == cacheService) {
            return this.delegate.getUserId(uid, context);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        CacheKey key = cache.newCacheKey(context.getContextId(), new String[]{uid});
        int identifier = -1;
        try {
            tmp = (Integer)cache.get((Serializable)key);
        }
        catch (ClassCastException e) {
            tmp = null;
        }
        if (null == tmp) {
            LOG.trace("Cache MISS. Context: {} User: {}", (Object)context.getContextId(), (Object)uid);
            identifier = this.delegate.getUserId(uid, context);
            try {
                cache.put((Serializable)key, (Serializable)Integer.valueOf(identifier), false);
            }
            catch (OXException e) {
                throw LdapExceptionCode.CACHE_PROBLEM.create(e, new Object[0]).setPrefix("USR");
            }
        } else {
            LOG.trace("Cache HIT. Context: {} User: {}", (Object)context.getContextId(), (Object)uid);
            identifier = tmp;
        }
        return identifier;
    }

    @Override
    public int[] listModifiedUser(Date modifiedSince, Context context) throws OXException {
        return this.delegate.listModifiedUser(modifiedSince, context);
    }

    @Override
    public User searchUser(String email, Context context) throws OXException {
        return this.delegate.searchUser(email, context);
    }

    @Override
    public User searchUser(String email, Context context, boolean considerAliases) throws OXException {
        return this.delegate.searchUser(email, context, considerAliases);
    }

    @Override
    public User[] searchUserByMailLogin(String login, Context context) throws OXException {
        return this.delegate.searchUserByMailLogin(login, context);
    }

    @Override
    public User[] searchUserByName(String name, Context context, int searchType) throws OXException {
        return this.delegate.searchUserByName(name, context, searchType);
    }

    @Override
    public int[] listAllUser(Context ctx) throws OXException {
        return this.delegate.listAllUser(ctx);
    }

    @Override
    public int[] resolveIMAPLogin(String imapLogin, Context context) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null == cacheService) {
            return this.delegate.resolveIMAPLogin(imapLogin, context);
        }
        try {
            int[] identifiers;
            int[] tmp;
            Cache cache = cacheService.getCache(REGION_NAME);
            CacheKey key = cache.newCacheKey(context.getContextId(), new String[]{new StringBuilder(imapLogin.length() + 1).append('~').append(imapLogin).toString()});
            try {
                tmp = (int[])cache.get((Serializable)key);
            }
            catch (ClassCastException e) {
                tmp = null;
            }
            if (null == tmp) {
                identifiers = this.delegate.resolveIMAPLogin(imapLogin, context);
                try {
                    if (null != cache.get((Serializable)key)) {
                        cache.remove((Serializable)key);
                    }
                    cache.put((Serializable)key, (Serializable)identifiers, false);
                }
                catch (OXException e) {
                    throw UserExceptionCode.CACHE_PROBLEM.create(e, new Object[0]);
                }
            } else {
                identifiers = tmp;
            }
            return identifiers;
        }
        catch (OXException e) {
            throw UserExceptionCode.CACHE_PROBLEM.create(e, new Object[0]);
        }
    }

    @Override
    public void invalidateUser(Context ctx, int userId) throws OXException {
        this.invalidateUserCache(ctx, userId);
        try {
            UserConfigurationStorage.getInstance().invalidateCache(userId, ctx);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void invalidateUserCache(Context ctx, int userId) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null != cacheService) {
            try {
                Cache cache = cacheService.getCache(REGION_NAME);
                cache.remove((Serializable)cache.newCacheKey(ctx.getContextId(), userId));
            }
            catch (OXException e) {
                throw UserExceptionCode.CACHE_PROBLEM.create(e, new Object[0]);
            }
        }
    }

    @Override
    protected void startInternal() {
    }

    @Override
    protected void stopInternal() throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService != null) {
            cacheService.freeCache(REGION_NAME);
        }
    }

    UserStorage getDelegate() {
        return this.delegate;
    }
}

