/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.alias.impl;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.alias.UserAliasStorage;
import com.openexchange.groupware.alias.UserAliasStorageExceptionCodes;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbAliasStorage
implements UserAliasStorage {
    private static final Logger LOG = LoggerFactory.getLogger(RdbAliasStorage.class);
    private static final String CREATE_ALIAS = "INSERT INTO user_alias (cid, user, alias) VALUES(?,?,?)";
    private static final String READ_ALIASES = "SELECT alias FROM user_alias WHERE cid=? AND user=?";
    private static final String UPDATE_ALIAS = "UPDATE user_alias SET alias=? WHERE cid=? AND user=? AND alias=?";
    private static final String DELETE_ALIAS = "DELETE FROM user_alias WHERE cid=? AND user=? AND alias=?";
    private static final String DELETE_ALL_ALIASE = "DELETE FROM user_alias WHERE cid=? AND user=?";
    private static final String GET_USER_ID = "SELECT user FROM user_alias WHERE cid=? AND alias LIKE ?";

    @Override
    public Set<String> getAliases(int contextId, int userId) throws OXException {
        HashSet<String> hashSet;
        Connection con = Database.get(contextId, false);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int index = 0;
            stmt = con.prepareStatement(READ_ALIASES);
            stmt.setInt(++index, contextId);
            stmt.setInt(++index, userId);
            rs = stmt.executeQuery();
            HashSet<String> aliases = new HashSet<String>(rs.getFetchSize());
            while (rs.next()) {
                aliases.add(rs.getString(1));
            }
            hashSet = aliases;
        }
        catch (SQLException e) {
            try {
                throw UserAliasStorageExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(contextId, false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.back(contextId, false, con);
        return hashSet;
    }

    @Override
    public int getUserId(int contextId, String alias) throws OXException {
        int n;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block5: {
            con = Database.get(contextId, false);
            stmt = null;
            rs = null;
            int index = 0;
            stmt = con.prepareStatement(GET_USER_ID);
            stmt.setInt(++index, contextId);
            stmt.setString(++index, alias);
            rs = stmt.executeQuery();
            if (!rs.next()) break block5;
            int n2 = rs.getInt(1);
            DBUtils.closeSQLStuff(rs, stmt);
            Database.back(contextId, false, con);
            return n2;
        }
        try {
            n = -1;
        }
        catch (SQLException e) {
            try {
                throw UserAliasStorageExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(contextId, false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.back(contextId, false, con);
        return n;
    }

    @Override
    public boolean createAlias(Connection con, int contextId, int userId, String alias) throws OXException {
        boolean bl;
        boolean useExistingConnection = true;
        if (con == null) {
            con = Database.get(contextId, true);
            useExistingConnection = false;
        }
        PreparedStatement stmt = null;
        try {
            int index = 0;
            stmt = con.prepareStatement(CREATE_ALIAS);
            stmt.setInt(++index, contextId);
            stmt.setInt(++index, userId);
            stmt.setString(++index, alias);
            bl = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw UserAliasStorageExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                if (!useExistingConnection) {
                    Database.back(contextId, false, con);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        if (!useExistingConnection) {
            Database.back(contextId, false, con);
        }
        return bl;
    }

    @Override
    public boolean updateAlias(Connection con, int contextId, int userId, String oldAlias, String newAlias) throws OXException {
        boolean bl;
        boolean useExistingConnection = true;
        if (con == null) {
            con = Database.get(contextId, true);
            useExistingConnection = false;
        }
        PreparedStatement stmt = null;
        try {
            int index = 0;
            stmt = con.prepareStatement(UPDATE_ALIAS);
            stmt.setString(++index, newAlias);
            stmt.setInt(++index, contextId);
            stmt.setInt(++index, userId);
            stmt.setString(++index, oldAlias);
            bl = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw UserAliasStorageExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                if (!useExistingConnection) {
                    Database.back(contextId, false, con);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        if (!useExistingConnection) {
            Database.back(contextId, false, con);
        }
        return bl;
    }

    @Override
    public boolean deleteAlias(Connection con, int contextId, int userId, String alias) throws OXException {
        boolean bl;
        boolean useExistingConnection = true;
        if (con == null) {
            con = Database.get(contextId, true);
            useExistingConnection = false;
        }
        PreparedStatement stmt = null;
        try {
            int index = 0;
            stmt = con.prepareStatement(DELETE_ALIAS);
            stmt.setInt(++index, contextId);
            stmt.setInt(++index, userId);
            stmt.setString(++index, alias);
            bl = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw UserAliasStorageExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                if (!useExistingConnection) {
                    Database.back(contextId, false, con);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        if (!useExistingConnection) {
            Database.back(contextId, false, con);
        }
        return bl;
    }

    @Override
    public boolean deleteAliase(Connection con, int contextId, int userId) throws OXException {
        boolean bl;
        boolean useExistingConnection = true;
        if (con == null) {
            con = Database.get(contextId, true);
            useExistingConnection = false;
        }
        PreparedStatement stmt = null;
        try {
            int index = 0;
            stmt = con.prepareStatement(DELETE_ALL_ALIASE);
            stmt.setInt(++index, contextId);
            stmt.setInt(++index, userId);
            bl = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw UserAliasStorageExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                if (!useExistingConnection) {
                    Database.back(contextId, false, con);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        if (!useExistingConnection) {
            Database.back(contextId, false, con);
        }
        return bl;
    }
}

