/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.internal;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupExceptionCodes;
import com.openexchange.group.GroupStorage;
import com.openexchange.group.internal.GroupI18nNamesService;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.data.Check;
import com.openexchange.groupware.ldap.UserStorage;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Date;

public final class Logic {
    private static final String ALLOWED_CHARS = "[$@%\\.+a-zA-Z0-9_-]";

    private Logic() {
    }

    static final void checkMandatoryForCreate(Group group) throws OXException {
        if (!group.isSimpleNameSet()) {
            throw GroupExceptionCodes.MANDATORY_MISSING.create("simpleName");
        }
        String tmp = group.getSimpleName();
        if (null == tmp || tmp.length() == 0) {
            throw GroupExceptionCodes.MANDATORY_MISSING.create("simpleName");
        }
        if (!group.isDisplayNameSet()) {
            throw GroupExceptionCodes.MANDATORY_MISSING.create("displayName");
        }
        tmp = group.getDisplayName();
        if (null == tmp || tmp.length() == 0) {
            throw GroupExceptionCodes.MANDATORY_MISSING.create("displayName");
        }
        if (!group.isLastModifiedSet()) {
            group.setLastModified(new Date());
        }
    }

    static final void checkMandatoryForUpdate(Group group) throws OXException {
        String tmp;
        if (!group.isIdentifierSet()) {
            throw GroupExceptionCodes.MANDATORY_MISSING.create("identifier");
        }
        if (group.isSimpleNameSet() && (null == (tmp = group.getSimpleName()) || tmp.length() == 0)) {
            throw GroupExceptionCodes.MANDATORY_MISSING.create("simpleName");
        }
        if (group.isDisplayNameSet() && (null == (tmp = group.getDisplayName()) || tmp.length() == 0)) {
            throw GroupExceptionCodes.MANDATORY_MISSING.create("displayName");
        }
        if (!group.isLastModifiedSet()) {
            group.setLastModified(new Date());
        }
    }

    static final void validateSimpleName(Group group) throws OXException {
        if (!group.isSimpleNameSet()) {
            return;
        }
        String groupName = group.getSimpleName();
        String illegal = groupName.replaceAll(ALLOWED_CHARS, "");
        if (illegal.length() > 0) {
            throw GroupExceptionCodes.NOT_ALLOWED_SIMPLE_NAME.create(illegal);
        }
    }

    static final void checkData(Group group) throws OXException {
        if (!group.isDisplayNameSet()) {
            return;
        }
        String result = Check.containsInvalidChars(group.getDisplayName());
        if (null != result) {
            throw GroupExceptionCodes.INVALID_DATA.create(result);
        }
    }

    static final void checkForDuplicate(GroupStorage storage, Context ctx, Group group, boolean checki18nNames) throws OXException {
        if (group.isSimpleNameSet()) {
            Group[] others;
            for (Group other : others = storage.searchGroups(group.getSimpleName(), true, ctx)) {
                if (!group.getSimpleName().equals(other.getSimpleName()) || group.getIdentifier() == other.getIdentifier()) continue;
                throw GroupExceptionCodes.DUPLICATE.create(other.getIdentifier());
            }
        }
        if (group.isDisplayNameSet()) {
            Group[] others;
            String displayName = group.getDisplayName();
            if (checki18nNames) {
                int id = group.getIdentifier();
                if (id > 0) {
                    if (!storage.getGroup(id, ctx).getDisplayName().equals(displayName)) {
                        for (String i18nName : GroupI18nNamesService.getInstance().getI18nNames()) {
                            if (!displayName.equals(i18nName)) continue;
                            throw GroupExceptionCodes.RESERVED_DISPLAY_NAME.create(displayName);
                        }
                    }
                } else {
                    for (String i18nName : GroupI18nNamesService.getInstance().getI18nNames()) {
                        if (!displayName.equals(i18nName)) continue;
                        throw GroupExceptionCodes.RESERVED_DISPLAY_NAME.create(displayName);
                    }
                }
            }
            for (Group other : others = storage.searchGroups(displayName, true, ctx)) {
                if (!displayName.equals(other.getDisplayName()) || group.getIdentifier() == other.getIdentifier()) continue;
                throw GroupExceptionCodes.DUPLICATE.create(other.getIdentifier());
            }
        }
    }

    static final void doMembersExist(Context ctx, Group group) throws OXException {
        if (!group.isMemberSet()) {
            return;
        }
        UserStorage storage = UserStorage.getInstance();
        TIntHashSet set = new TIntHashSet();
        for (int userId : storage.listAllUser(ctx)) {
            set.add(userId);
        }
        for (int userId : group.getMember()) {
            if (set.contains(userId)) continue;
            throw GroupExceptionCodes.NOT_EXISTING_MEMBER.create(userId);
        }
    }
}

