/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.capabilities.CapabilityService;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.AccountAware;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.ServiceAware;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import com.openexchange.folderstorage.AfterReadAwareFolderStorage;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.StorageParametersUtility;
import com.openexchange.folderstorage.StoragePriority;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.SystemContentType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.folderstorage.database.DatabaseFolderConverter;
import com.openexchange.folderstorage.database.DatabaseFolderStorageUtility;
import com.openexchange.folderstorage.database.DatabaseFolderType;
import com.openexchange.folderstorage.database.DatabaseId;
import com.openexchange.folderstorage.database.FolderIdNamePair;
import com.openexchange.folderstorage.database.contentType.CalendarContentType;
import com.openexchange.folderstorage.database.contentType.ContactContentType;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.database.contentType.TaskContentType;
import com.openexchange.folderstorage.database.contentType.UnboundContentType;
import com.openexchange.folderstorage.database.getfolder.SharedPrefixFolder;
import com.openexchange.folderstorage.database.getfolder.SystemInfostoreFolder;
import com.openexchange.folderstorage.database.getfolder.SystemPrivateFolder;
import com.openexchange.folderstorage.database.getfolder.SystemPublicFolder;
import com.openexchange.folderstorage.database.getfolder.SystemRootFolder;
import com.openexchange.folderstorage.database.getfolder.SystemSharedFolder;
import com.openexchange.folderstorage.database.getfolder.VirtualListFolder;
import com.openexchange.folderstorage.internal.Tools;
import com.openexchange.folderstorage.outlook.osgi.Services;
import com.openexchange.folderstorage.outlook.sql.Delete;
import com.openexchange.folderstorage.type.PrivateType;
import com.openexchange.folderstorage.type.PublicType;
import com.openexchange.folderstorage.type.SharedType;
import com.openexchange.folderstorage.type.SystemType;
import com.openexchange.folderstorage.type.TrashType;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.InfostoreFacades;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.CallerRunsCompletionService;
import com.openexchange.java.Collators;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderBatchLoader;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import com.openexchange.tools.oxfolder.OXFolderLoader;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.ConcurrentTIntObjectHashMap;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseFolderStorage
implements AfterReadAwareFolderStorage {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseFolderStorage.class);
    private static final String PARAM_CONNECTION = "DB.Con";
    static final EnumSet<AfterReadAwareFolderStorage.Mode> WRITEES = EnumSet.of(AfterReadAwareFolderStorage.Mode.WRITE, AfterReadAwareFolderStorage.Mode.WRITE_AFTER_READ);
    private final ServiceLookup services;
    private static final ConcurrentTIntObjectHashMap<Long> STAMPS = new ConcurrentTIntObjectHashMap(128);
    private static final long DELAY = 3600000L;
    private static final int MAX = 3;
    private static final int[] PUBLIC_FOLDER_IDS = new int[]{2, 9, 10, 15};
    private static final int[] VIRTUAL_IDS = new int[]{11, 12, 13, 14};

    public DatabaseFolderStorage(ServiceLookup services) {
        this.services = services;
    }

    @Override
    public void clearCache(int userId, int contextId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkConsistency(String treeId, StorageParameters storageParameters) throws OXException {
        int contextId = storageParameters.getContextId();
        long now = System.currentTimeMillis();
        Long stamp = (Long)STAMPS.get(contextId);
        if (null != stamp && stamp + 3600000L > now) {
            return;
        }
        STAMPS.remove(contextId);
        DatabaseService databaseService = (DatabaseService)this.services.getService(DatabaseService.class);
        Connection con = null;
        boolean close = true;
        AfterReadAwareFolderStorage.Mode mode = AfterReadAwareFolderStorage.Mode.READ;
        boolean modified = false;
        try {
            ConnectionMode conMode = DatabaseFolderStorage.optParameter(ConnectionMode.class, PARAM_CONNECTION, storageParameters);
            if (null != conMode) {
                con = conMode.connection;
                mode = conMode.readWrite;
                close = false;
            } else {
                con = databaseService.getReadOnly(contextId);
            }
            ServerSession session = ServerSessionAdapter.valueOf(storageParameters.getSession());
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            Context context = session.getContext();
            int[] nonExistingParents = OXFolderSQL.getNonExistingParents(context, con);
            if (null == nonExistingParents || 0 == nonExistingParents.length) {
                return;
            }
            if (AfterReadAwareFolderStorage.Mode.READ == mode) {
                if (close) {
                    databaseService.backReadOnly(contextId, con);
                }
                con = databaseService.getWritable(contextId);
                mode = AfterReadAwareFolderStorage.Mode.WRITE_AFTER_READ;
                nonExistingParents = OXFolderSQL.getNonExistingParents(context, con);
                if (null == nonExistingParents || 0 == nonExistingParents.length) {
                    return;
                }
            }
            TIntHashSet shared = new TIntHashSet();
            OXFolderManager manager = OXFolderManager.getInstance(session, con, con);
            OXFolderAccess folderAccess = DatabaseFolderStorage.getFolderAccess(context, con);
            int userId = session.getUserId();
            int runCount = 0;
            TIntHashSet tmp = new TIntHashSet();
            do {
                for (int folderId : nonExistingParents) {
                    if (folderId < 20) continue;
                    if (3 == folderAccess.getFolderType(folderId, userId)) {
                        shared.add(folderId);
                        continue;
                    }
                    manager.deleteValidatedFolder(folderId, now, -1, true);
                    modified = true;
                }
                tmp.clear();
                tmp.addAll(OXFolderSQL.getNonExistingParents(context, con));
                if (tmp.isEmpty()) {
                    nonExistingParents = null;
                    continue;
                }
                tmp.removeAll(shared.toArray());
                for (int i = 0; i < 20; ++i) {
                    tmp.remove(i);
                }
                nonExistingParents = tmp.toArray();
            } while (++runCount <= 3 && null != nonExistingParents && nonExistingParents.length > 0);
        }
        finally {
            if (null != con && close) {
                if (AfterReadAwareFolderStorage.Mode.READ == mode) {
                    databaseService.backReadOnly(contextId, con);
                } else if (modified) {
                    databaseService.backWritable(contextId, con);
                } else {
                    databaseService.backWritableAfterReading(contextId, con);
                }
            }
            STAMPS.put(contextId, (Object)now);
        }
    }

    @Override
    public ContentType[] getSupportedContentTypes() {
        return new ContentType[]{TaskContentType.getInstance(), CalendarContentType.getInstance(), ContactContentType.getInstance(), InfostoreContentType.getInstance(), UnboundContentType.getInstance(), SystemContentType.getInstance()};
    }

    @Override
    public ContentType getDefaultContentType() {
        return ContactContentType.getInstance();
    }

    @Override
    public void commitTransaction(StorageParameters params) throws OXException {
        ConnectionMode con;
        try {
            con = DatabaseFolderStorage.optParameter(ConnectionMode.class, PARAM_CONNECTION, params);
        }
        catch (OXException e) {
            LOG.warn("Storage already committed:\n{}", (Object)params.getCommittedTrace(), (Object)e);
            return;
        }
        if (null == con) {
            return;
        }
        if (WRITEES.contains((Object)con.readWrite)) {
            try {
                con.connection.commit();
            }
            catch (SQLException e) {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            finally {
                DBUtils.autocommit(con.connection);
                DatabaseService databaseService = (DatabaseService)this.services.getService(DatabaseService.class);
                if (null != databaseService) {
                    con.close(databaseService, params.getContext().getContextId());
                }
                FolderType folderType = this.getFolderType();
                params.putParameter(folderType, PARAM_CONNECTION, null);
                params.markCommitted();
            }
        } else {
            DatabaseService databaseService = (DatabaseService)this.services.getService(DatabaseService.class);
            if (null != databaseService) {
                databaseService.backReadOnly(params.getContext(), con.connection);
            }
            FolderType folderType = this.getFolderType();
            params.putParameter(folderType, PARAM_CONNECTION, null);
            params.markCommitted();
        }
    }

    @Override
    public void restore(String treeId, String folderIdentifier, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = this.getConnection(AfterReadAwareFolderStorage.Mode.WRITE, storageParameters);
        try {
            Connection con = provider.getConnection();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            int folderId = Integer.parseInt(folderIdentifier);
            Context context = storageParameters.getContext();
            FolderObject.loadFolderObjectFromDB(folderId, context, con, false, false, "del_oxfolder_tree", "del_oxfolder_permissions");
            OXFolderSQL.restore(folderId, context, null);
        }
        catch (NumberFormatException e) {
            throw FolderExceptionErrorMessage.INVALID_FOLDER_ID.create(folderIdentifier);
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = this.getConnection(AfterReadAwareFolderStorage.Mode.WRITE, storageParameters);
        try {
            Permission[] perms;
            Type t;
            String parentId;
            Connection con = provider.getConnection();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            long millis = System.currentTimeMillis();
            FolderObject createMe = new FolderObject();
            createMe.setCreatedBy(session.getUserId());
            createMe.setCreationDate(new Date(millis));
            createMe.setCreator(session.getUserId());
            createMe.setDefaultFolder(false);
            String name = folder.getName();
            if (null != name) {
                createMe.setFolderName(name);
            }
            createMe.setLastModified(new Date(millis));
            createMe.setModifiedBy(session.getUserId());
            ContentType ct = folder.getContentType();
            if (null != ct) {
                createMe.setModule(DatabaseFolderStorage.getModuleByContentType(ct));
            }
            if (null != (parentId = folder.getParentID())) {
                createMe.setParentFolderID(Integer.parseInt(parentId));
            }
            if (null == (t = folder.getType())) {
                createMe.setType(DatabaseFolderStorage.getFolderType(createMe.getModule(), createMe.getParentFolderID(), storageParameters.getContext(), con));
            } else {
                createMe.setType(DatabaseFolderStorage.getTypeByFolderType(t));
            }
            Map<String, Object> meta = folder.getMeta();
            if (null != meta) {
                createMe.setMeta(meta);
            }
            if (null != (perms = folder.getPermissions())) {
                OCLPermission[] oclPermissions = new OCLPermission[perms.length];
                for (int i = 0; i < perms.length; ++i) {
                    Permission p = perms[i];
                    OCLPermission oclPerm = new OCLPermission();
                    oclPerm.setEntity(p.getEntity());
                    oclPerm.setGroupPermission(p.isGroup());
                    oclPerm.setFolderAdmin(p.isAdmin());
                    oclPerm.setAllPermission(p.getFolderPermission(), p.getReadPermission(), p.getWritePermission(), p.getDeletePermission());
                    oclPerm.setSystem(p.getSystem());
                    oclPermissions[i] = oclPerm;
                }
                createMe.setPermissionsAsArray(oclPermissions);
            } else {
                int parentFolderID = createMe.getParentFolderID();
                FolderObject parent = DatabaseFolderStorage.getFolderObject(parentFolderID, storageParameters.getContext(), con, storageParameters);
                int userId = storageParameters.getUserId();
                boolean isShared = parent.isShared(userId);
                boolean isSystem = 5 == parent.getModule();
                List<OCLPermission> parentPermissions = parent.getPermissions();
                ArrayList<OCLPermission> permissions = new ArrayList<OCLPermission>((isSystem ? 0 : parentPermissions.size()) + 1);
                if (isShared) {
                    permissions.add(DatabaseFolderStorage.newMaxPermissionFor(parent.getCreatedBy()));
                    permissions.add(DatabaseFolderStorage.newStandardPermissionFor(userId));
                } else {
                    permissions.add(DatabaseFolderStorage.newMaxPermissionFor(userId));
                }
                if (!isSystem) {
                    TIntHashSet ignore = new TIntHashSet(2);
                    ignore.add(userId);
                    if (isShared) {
                        ignore.add(parent.getCreatedBy());
                    }
                    for (OCLPermission permission : parentPermissions) {
                        if (permission.getSystem() > 0 || !permission.isGroupPermission() && ignore.contains(permission.getEntity())) continue;
                        permissions.add(permission);
                    }
                }
                createMe.setPermissions(permissions);
            }
            OXFolderManager folderManager = OXFolderManager.getInstance(session, con, con);
            folderManager.createFolder(createMe, true, millis);
            int fuid = createMe.getObjectID();
            if (fuid <= 0) {
                throw OXFolderExceptionCode.CREATE_FAILED.create(new Object[0]);
            }
            folder.setID(String.valueOf(fuid));
            List<OXException> warnings = folderManager.getWarnings();
            if (null != warnings) {
                for (OXException warning : warnings) {
                    storageParameters.addWarning(warning);
                }
            }
        }
        finally {
            provider.close();
        }
    }

    private static OCLPermission newMaxPermissionFor(int entity) {
        OCLPermission oclPerm = new OCLPermission();
        oclPerm.setEntity(entity);
        oclPerm.setGroupPermission(false);
        oclPerm.setFolderAdmin(true);
        oclPerm.setAllPermission(128, 128, 128, 128);
        oclPerm.setSystem(0);
        return oclPerm;
    }

    private static OCLPermission newStandardPermissionFor(int entity) {
        OCLPermission oclPerm = new OCLPermission();
        oclPerm.setEntity(entity);
        oclPerm.setGroupPermission(false);
        oclPerm.setFolderAdmin(false);
        oclPerm.setAllPermission(2, 4, 4, 4);
        oclPerm.setSystem(0);
        return oclPerm;
    }

    private static int getFolderType(int module, int parentId, Context ctx, Connection con) throws OXException, OXException {
        int type = -1;
        int pid = parentId;
        if (pid == 3) {
            pid = 1;
            type = 3;
        } else {
            type = pid == 1 ? 1 : (Arrays.binarySearch(PUBLIC_FOLDER_IDS, pid) >= 0 ? 2 : DatabaseFolderStorage.getFolderAccess(ctx, con).getFolderType(pid));
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = this.getConnection(AfterReadAwareFolderStorage.Mode.WRITE, storageParameters);
        try {
            Connection con = provider.getConnection();
            FolderObject fo = DatabaseFolderStorage.getFolderObject(Integer.parseInt(folderId), storageParameters.getContext(), con, storageParameters);
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            OXFolderManager folderManager = OXFolderManager.getInstance(session, con, con);
            folderManager.clearFolder(fo, true, System.currentTimeMillis());
            List<OXException> warnings = folderManager.getWarnings();
            if (null != warnings) {
                for (OXException warning : warnings) {
                    storageParameters.addWarning(warning);
                }
            }
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFolder(String treeId, String folderIdentifier, StorageParameters storageParameters) throws OXException {
        int folderId = Integer.parseInt(folderIdentifier);
        ConnectionProvider provider = this.getConnection(AfterReadAwareFolderStorage.Mode.WRITE, storageParameters);
        try {
            Connection con = provider.getConnection();
            FolderObject fo = new FolderObject();
            fo.setObjectID(folderId);
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            FolderServiceDecorator decorator = storageParameters.getDecorator();
            boolean hardDelete = null != decorator && (Boolean.TRUE.equals(decorator.getProperty("hardDelete")) || decorator.getBoolProperty("hardDelete"));
            OXFolderManager folderManager = OXFolderManager.getInstance(session, con, con);
            folderManager.deleteFolder(fo, true, System.currentTimeMillis(), hardDelete);
            if (hardDelete) {
                Delete.hardDeleteFolder(session.getContextId(), Tools.getUnsignedInteger("1"), session.getUserId(), folderIdentifier, true, true, con);
            } else {
                Delete.deleteFolder(session.getContextId(), Tools.getUnsignedInteger("1"), session.getUserId(), folderIdentifier, true, true, con);
            }
            List<OXException> warnings = folderManager.getWarnings();
            if (null != warnings) {
                for (OXException warning : warnings) {
                    storageParameters.addWarning(warning);
                }
            }
        }
        finally {
            provider.close();
        }
    }

    @Override
    public String getDefaultFolderID(User user, String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = this.getConnection(AfterReadAwareFolderStorage.Mode.READ, storageParameters);
        try {
            Connection con = provider.getConnection();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            Context context = storageParameters.getContext();
            int folderId = -1;
            if (TaskContentType.getInstance().equals(contentType)) {
                folderId = OXFolderSQL.getUserDefaultFolder(session.getUserId(), 1, con, context);
            } else if (CalendarContentType.getInstance().equals(contentType)) {
                folderId = OXFolderSQL.getUserDefaultFolder(session.getUserId(), 2, con, context);
            } else if (ContactContentType.getInstance().equals(contentType)) {
                folderId = OXFolderSQL.getUserDefaultFolder(session.getUserId(), 3, con, context);
            } else if (InfostoreContentType.getInstance().equals(contentType)) {
                folderId = TrashType.getInstance().equals(type) ? OXFolderSQL.getUserDefaultFolder(session.getUserId(), 8, DatabaseFolderStorage.getTypeByFolderType(type), con, context) : OXFolderSQL.getUserDefaultFolder(session.getUserId(), 8, con, context);
            }
            if (-1 == folderId) {
                throw FolderExceptionErrorMessage.NO_DEFAULT_FOLDER.create(contentType, treeId);
            }
            String string = String.valueOf(folderId);
            return string;
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type getTypeByParent(User user, String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        int pid = Integer.parseInt(parentId);
        if (pid == 3) {
            return SharedType.getInstance();
        }
        if (pid == 1) {
            return PrivateType.getInstance();
        }
        if (Arrays.binarySearch(PUBLIC_FOLDER_IDS, pid) >= 0) {
            return PublicType.getInstance();
        }
        ConnectionProvider provider = this.getConnection(AfterReadAwareFolderStorage.Mode.READ, storageParameters);
        try {
            FolderObject p = DatabaseFolderStorage.getFolderAccess(storageParameters.getContext(), provider.getConnection()).getFolderObject(pid);
            int parentType = p.getType();
            if (1 == parentType) {
                Type type = p.getCreatedBy() == user.getId() ? PrivateType.getInstance() : SharedType.getInstance();
                return type;
            }
            if (2 == parentType) {
                PublicType publicType = PublicType.getInstance();
                return publicType;
            }
            if (16 == parentType) {
                TrashType trashType = TrashType.getInstance();
                return trashType;
            }
        }
        finally {
            provider.close();
        }
        return SystemType.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsForeignObjects(User user, String treeId, String folderIdentifier, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = this.getConnection(AfterReadAwareFolderStorage.Mode.READ, storageParameters);
        try {
            Connection con = provider.getConnection();
            Context ctx = storageParameters.getContext();
            int folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier);
            if (folderId < 0) {
                throw OXFolderExceptionCode.NOT_EXISTS.create(folderIdentifier, ctx.getContextId());
            }
            if (0 == folderId) {
                boolean bl = false;
                return bl;
            }
            if (3 == folderId) {
                boolean bl = false;
                return bl;
            }
            if (2 == folderId) {
                boolean bl = false;
                return bl;
            }
            if (9 == folderId) {
                boolean bl = false;
                return bl;
            }
            if (1 == folderId) {
                boolean bl = false;
                return bl;
            }
            if (Arrays.binarySearch(VIRTUAL_IDS, folderId) >= 0) {
                boolean bl = true;
                return bl;
            }
            OXFolderAccess folderAccess = DatabaseFolderStorage.getFolderAccess(ctx, con);
            boolean bl = folderAccess.containsForeignObjects(DatabaseFolderStorage.getFolderObject(folderId, ctx, con, storageParameters), storageParameters.getSession(), ctx);
            return bl;
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(String treeId, String folderIdentifier, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = this.getConnection(AfterReadAwareFolderStorage.Mode.READ, storageParameters);
        try {
            Connection con = provider.getConnection();
            Context ctx = storageParameters.getContext();
            int folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier);
            if (folderId < 0) {
                throw OXFolderExceptionCode.NOT_EXISTS.create(folderIdentifier, ctx.getContextId());
            }
            if (0 == folderId) {
                boolean bl = true;
                return bl;
            }
            if (3 == folderId) {
                boolean bl = true;
                return bl;
            }
            if (2 == folderId) {
                boolean bl = true;
                return bl;
            }
            if (9 == folderId) {
                boolean bl = true;
                return bl;
            }
            if (1 == folderId) {
                boolean bl = true;
                return bl;
            }
            if (Arrays.binarySearch(VIRTUAL_IDS, folderId) >= 0) {
                boolean bl = false;
                return bl;
            }
            OXFolderAccess folderAccess = DatabaseFolderStorage.getFolderAccess(ctx, con);
            boolean bl = folderAccess.isEmpty(DatabaseFolderStorage.getFolderObject(folderId, ctx, con, storageParameters), storageParameters.getSession(), ctx);
            return bl;
        }
        finally {
            provider.close();
        }
    }

    @Override
    public void updateLastModified(long lastModified, String treeId, String folderIdentifier, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = this.getConnection(AfterReadAwareFolderStorage.Mode.WRITE, storageParameters);
        try {
            Connection con = provider.getConnection();
            Context ctx = storageParameters.getContext();
            int folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier);
            if (DatabaseFolderStorage.getFolderAccess(ctx, con).getFolderLastModified(folderId).after(new Date(lastModified))) {
                throw FolderExceptionErrorMessage.CONCURRENT_MODIFICATION.create();
            }
            OXFolderSQL.updateLastModified(folderId, lastModified, storageParameters.getUserId(), con, ctx);
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            provider.close();
        }
    }

    @Override
    public Folder getFolder(String treeId, String folderIdentifier, StorageParameters storageParameters) throws OXException {
        return this.getFolder(treeId, folderIdentifier, StorageType.WORKING, storageParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Folder getFolder(String treeId, String folderIdentifier, StorageType storageType, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = this.getConnection(AfterReadAwareFolderStorage.Mode.READ, storageParameters);
        try {
            int folderId;
            DatabaseFolder retval;
            Connection con = provider.getConnection();
            User user = storageParameters.getUser();
            Context ctx = storageParameters.getContext();
            Session s = storageParameters.getSession();
            UserPermissionBits userPermissionBits = s instanceof ServerSession ? ((ServerSession)s).getUserPermissionBits() : UserPermissionBitsStorage.getInstance().getUserPermissionBits(user.getId(), ctx);
            if (StorageType.WORKING.equals(storageType)) {
                if (DatabaseFolderStorageUtility.hasSharedPrefix(folderIdentifier)) {
                    retval = SharedPrefixFolder.getSharedPrefixFolder(folderIdentifier, user, ctx);
                } else {
                    folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier);
                    if (folderId < 0) {
                        throw OXFolderExceptionCode.NOT_EXISTS.create(folderIdentifier, ctx.getContextId());
                    }
                    if (0 == folderId) {
                        retval = SystemRootFolder.getSystemRootFolder();
                    } else if (Arrays.binarySearch(VIRTUAL_IDS, folderId) >= 0) {
                        boolean altNames = StorageParametersUtility.getBoolParameter("altNames", storageParameters);
                        retval = VirtualListFolder.getVirtualListFolder(folderId, altNames);
                    } else {
                        FolderObject fo = DatabaseFolderStorage.getFolderObject(folderId, ctx, con, storageParameters);
                        boolean altNames = StorageParametersUtility.getBoolParameter("altNames", storageParameters);
                        retval = DatabaseFolderConverter.convert(fo, user, userPermissionBits, ctx, storageParameters.getSession(), altNames, con);
                    }
                }
            } else {
                folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier);
                if (folderId < 0) {
                    throw OXFolderExceptionCode.NOT_EXISTS.create(folderIdentifier, ctx.getContextId());
                }
                FolderObject fo = FolderObject.loadFolderObjectFromDB(folderId, ctx, con, true, false, "del_oxfolder_tree", "del_oxfolder_permissions");
                retval = new DatabaseFolder(fo);
            }
            retval.setTreeID(treeId);
            DatabaseFolder databaseFolder = retval;
            return databaseFolder;
        }
        finally {
            provider.close();
        }
    }

    @Override
    public Folder prepareFolder(String treeId, Folder folder, StorageParameters storageParameters) throws OXException {
        int owner = folder.getCreatedBy();
        if (owner < 0) {
            return folder;
        }
        if (owner != storageParameters.getUserId() && PrivateType.getInstance().equals(folder.getType())) {
            try {
                return this.getFolder(treeId, folder.getID(), StorageType.WORKING, storageParameters);
            }
            catch (OXException e) {
                if (OXFolderExceptionCode.NOT_EXISTS.equals(e) || FolderExceptionErrorMessage.NOT_FOUND.equals(e)) {
                    return this.getFolder(treeId, folder.getID(), StorageType.BACKUP, storageParameters);
                }
                throw e;
            }
        }
        return folder;
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIdentifiers, StorageParameters storageParameters) throws OXException {
        return this.getFolders(treeId, folderIdentifiers, StorageType.WORKING, storageParameters);
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIdentifiers, StorageType storageType, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = null;
        try {
            User user = storageParameters.getUser();
            Context ctx = storageParameters.getContext();
            Session s = storageParameters.getSession();
            UserPermissionBits userPermissionBits = s instanceof ServerSession ? ((ServerSession)s).getUserPermissionBits() : UserPermissionBitsStorage.getInstance().getUserPermissionBits(user.getId(), ctx);
            boolean altNames = StorageParametersUtility.getBoolParameter("altNames", storageParameters);
            if (StorageType.WORKING.equals(storageType)) {
                int size = folderIdentifiers.size();
                Folder[] ret = new Folder[size];
                TIntIntHashMap map = new TIntIntHashMap(size);
                for (int index = 0; index < size; ++index) {
                    String folderIdentifier = folderIdentifiers.get(index);
                    if (DatabaseFolderStorageUtility.hasSharedPrefix(folderIdentifier)) {
                        ret[index] = SharedPrefixFolder.getSharedPrefixFolder(folderIdentifier, user, ctx);
                        continue;
                    }
                    int folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier);
                    if (0 == folderId) {
                        ret[index] = SystemRootFolder.getSystemRootFolder();
                        continue;
                    }
                    if (Arrays.binarySearch(VIRTUAL_IDS, folderId) >= 0) {
                        ret[index] = VirtualListFolder.getVirtualListFolder(folderId, altNames);
                        continue;
                    }
                    map.put(folderId, index);
                }
                provider = this.getConnection(AfterReadAwareFolderStorage.Mode.READ, storageParameters);
                Connection con = provider.getConnection();
                if (!map.isEmpty()) {
                    Session session = storageParameters.getSession();
                    for (FolderObject folderObject : DatabaseFolderStorage.getFolderObjects(map.keys(), ctx, con, storageParameters)) {
                        if (null == folderObject) continue;
                        int index = map.get(folderObject.getObjectID());
                        ret[index] = DatabaseFolderConverter.convert(folderObject, user, userPermissionBits, ctx, session, altNames, con);
                    }
                }
                provider.close();
                provider = null;
                for (Folder folder : ret) {
                    if (null == folder) continue;
                    folder.setTreeID(treeId);
                }
                int length = ret.length;
                ArrayList<Folder> l = new ArrayList<Folder>(length);
                for (int i = 0; i < length; ++i) {
                    Folder folder = ret[i];
                    if (null != folder) {
                        l.add(folder);
                        continue;
                    }
                    storageParameters.addWarning(FolderExceptionErrorMessage.NOT_FOUND.create(Integer.valueOf(folderIdentifiers.get(i)), treeId));
                }
                ArrayList<Folder> i = l;
                return i;
            }
            TIntArrayList list = new TIntArrayList(folderIdentifiers.size());
            for (String folderIdentifier : folderIdentifiers) {
                list.add(DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier));
            }
            provider = this.getConnection(AfterReadAwareFolderStorage.Mode.READ, storageParameters);
            Connection con = provider.getConnection();
            List<FolderObject> folders2 = OXFolderBatchLoader.loadFolderObjectsFromDB(list.toArray(), ctx, con, true, false, "del_oxfolder_tree", "del_oxfolder_permissions");
            provider.close();
            provider = null;
            int size = folders2.size();
            ArrayList<Folder> ret = new ArrayList<Folder>(size);
            for (int i = 0; i < size; ++i) {
                FolderObject fo = folders2.get(i);
                if (null == fo) {
                    storageParameters.addWarning(FolderExceptionErrorMessage.NOT_FOUND.create(list.get(i), treeId));
                    continue;
                }
                DatabaseFolder df = new DatabaseFolder(fo);
                df.setTreeID(treeId);
                ret.add(df);
            }
            ArrayList<Folder> arrayList = ret;
            return arrayList;
        }
        catch (OXException e) {
            throw e;
        }
        finally {
            if (null != provider) {
                provider.close();
            }
        }
    }

    @Override
    public FolderType getFolderType() {
        return DatabaseFolderType.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public SortableId[] getVisibleFolders(String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        provider = this.getConnection(AfterReadAwareFolderStorage.Mode.READ, storageParameters);
        try {
            con = provider.getConnection();
            user = storageParameters.getUser();
            userId = user.getId();
            ctx = storageParameters.getContext();
            s = storageParameters.getSession();
            userPermissionBits = s instanceof ServerSession != false ? ((ServerSession)s).getUserPermissionBits() : UserPermissionBitsStorage.getInstance().getUserPermissionBits(user.getId(), ctx);
            iType = DatabaseFolderStorage.getTypeByFolderTypeWithShared(type);
            iModule = DatabaseFolderStorage.getModuleByContentType(contentType);
            list = ((FolderObjectIterator)OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfType(userId, user.getGroups(), userPermissionBits.getAccessibleModules(), iType, new int[]{iModule}, ctx, con)).asList();
            if (1 == iType) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getCreatedBy() == userId) continue;
                    iterator.remove();
                }
            } else if (2 == iType && 3 == iModule) {
                try {
                    capsService = ServerServiceRegistry.getInstance().getService(CapabilityService.class);
                    if (null != capsService && !capsService.getCapabilities(user.getId(), ctx.getContextId()).contains("gab") || !(gab = DatabaseFolderStorage.getFolderObject(6, ctx, con, storageParameters)).isVisible(userId, userPermissionBits)) ** GOTO lbl29
                    gab.setFolderName(StringHelper.valueOf(user.getLocale()).getString("Global address book"));
                    list.add(gab);
                }
                catch (RuntimeException e) {
                    throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, new Object[]{ctx.getContextId()});
                }
            }
lbl29:
            // 5 sources

            stringHelper = null;
            for (FolderObject folderObject : list) {
                if (!folderObject.isDefaultFolder()) continue;
                module = folderObject.getModule();
                if (2 == module) {
                    if (null == stringHelper) {
                        stringHelper = StringHelper.valueOf(user.getLocale());
                    }
                    folderObject.setFolderName(stringHelper.getString("Calendar"));
                    continue;
                }
                if (3 == module) {
                    if (null == stringHelper) {
                        stringHelper = StringHelper.valueOf(user.getLocale());
                    }
                    folderObject.setFolderName(stringHelper.getString("Contacts"));
                    continue;
                }
                if (1 != module) continue;
                if (null == stringHelper) {
                    stringHelper = StringHelper.valueOf(user.getLocale());
                }
                folderObject.setFolderName(stringHelper.getString("Tasks"));
            }
            if (1 == iType) {
                Collections.sort(list, new FolderObjectComparator(user.getLocale(), ctx));
            } else {
                if (3 == iType) {
                    tracker = new HashMap<String, Integer>(list.size());
                    for (FolderObject folder : list) {
                        pre = (Integer)tracker.get(folder.getFolderName());
                        if (null == pre) {
                            owner = folder.getCreatedBy();
                            if (owner <= 0) continue;
                            tracker.put(folder.getFolderName(), owner);
                            continue;
                        }
                        owner = folder.getCreatedBy();
                        if (owner <= 0 || (otherOwner = pre.intValue()) == owner) continue;
                        UserStorage.getInstance().loadIfAbsent(otherOwner, ctx, con);
                        UserStorage.getInstance().loadIfAbsent(owner, ctx, con);
                    }
                }
                Collections.sort(list, new FolderNameComparator(user.getLocale(), storageParameters.getContext()));
            }
            ret = new SortableId[list.size()];
            for (i = 0; i < ret.length; ++i) {
                folderObject = list.get(i);
                id = String.valueOf(folderObject.getObjectID());
                ret[i] = new DatabaseId(id, i, folderObject.getFolderName());
            }
            var15_19 = ret;
            return var15_19;
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SortableId[] getSubfolders(String treeId, String parentIdentifier, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = this.getConnection(AfterReadAwareFolderStorage.Mode.READ, storageParameters);
        try {
            LinkedList<String[]> l;
            UserPermissionBits userPermissionBits;
            Context ctx;
            User user;
            Connection con;
            block63: {
                int sz;
                ArrayList accountList;
                block64: {
                    FileStorageAccountAccess defaultFileStorageAccess;
                    Session session;
                    FileStorageAccount defaultAccount;
                    int parentId;
                    block62: {
                        con = provider.getConnection();
                        if (DatabaseFolderStorageUtility.hasSharedPrefix(parentIdentifier)) {
                            UserPermissionBits userPermissionBits2;
                            User user2 = storageParameters.getUser();
                            Context ctx2 = storageParameters.getContext();
                            Session s = storageParameters.getSession();
                            if (s instanceof ServerSession) {
                                UserPermissionBits userPermissionBits22 = ((ServerSession)s).getUserPermissionBits();
                            } else {
                                userPermissionBits2 = UserPermissionBitsStorage.getInstance().getUserPermissionBits(user2.getId(), ctx2);
                            }
                            List<FolderIdNamePair> subfolderIds = SharedPrefixFolder.getSharedPrefixFolderSubfolders(parentIdentifier, user2, userPermissionBits2, ctx2, con);
                            ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(subfolderIds.size());
                            int i = 0;
                            SortableId[] i$ = subfolderIds.iterator();
                            while (true) {
                                if (!i$.hasNext()) {
                                    i$ = list.toArray(new SortableId[list.size()]);
                                    return i$;
                                }
                                FolderIdNamePair props = i$.next();
                                list.add(new DatabaseId(props.fuid, i++, props.name));
                            }
                        }
                        parentId = Integer.parseInt(parentIdentifier);
                        if (0 == parentId) {
                            List<String[]> subfolderIds = SystemRootFolder.getSystemRootFolderSubfolder(storageParameters.getUser().getLocale());
                            ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(subfolderIds.size());
                            int i = 0;
                            SortableId[] i$ = subfolderIds.iterator();
                            while (true) {
                                if (!i$.hasNext()) {
                                    i$ = list.toArray(new SortableId[list.size()]);
                                    return i$;
                                }
                                String[] sa = i$.next();
                                list.add(new DatabaseId(sa[0], i++, sa[1]));
                            }
                        }
                        if (Arrays.binarySearch(VIRTUAL_IDS, parentId) >= 0) {
                            UserPermissionBits userPermissionBits3;
                            User user3 = storageParameters.getUser();
                            Context ctx3 = storageParameters.getContext();
                            Session s = storageParameters.getSession();
                            if (s instanceof ServerSession) {
                                UserPermissionBits userPermissionBits32 = ((ServerSession)s).getUserPermissionBits();
                            } else {
                                userPermissionBits3 = UserPermissionBitsStorage.getInstance().getUserPermissionBits(user3.getId(), ctx3);
                            }
                            List<String[]> subfolderIds = VirtualListFolder.getVirtualListFolderSubfolders(parentId, user3, userPermissionBits3, ctx3, con);
                            int size = subfolderIds.size();
                            ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(size);
                            int i222 = 0;
                            while (true) {
                                if (i222 >= size) {
                                    SortableId[] i222 = list.toArray(new SortableId[list.size()]);
                                    return i222;
                                }
                                String[] sa = subfolderIds.get(i222);
                                list.add(new DatabaseId(sa[0], i222, sa[1]));
                                ++i222;
                            }
                        }
                        if (1 == parentId) {
                            UserPermissionBits userPermissionBits4;
                            User user4 = storageParameters.getUser();
                            Context ctx4 = storageParameters.getContext();
                            Session s = storageParameters.getSession();
                            if (s instanceof ServerSession) {
                                UserPermissionBits userPermissionBits42 = ((ServerSession)s).getUserPermissionBits();
                            } else {
                                userPermissionBits4 = UserPermissionBitsStorage.getInstance().getUserPermissionBits(user4.getId(), ctx4);
                            }
                            List<String[]> subfolderIds = SystemPrivateFolder.getSystemPrivateFolderSubfolders(user4, userPermissionBits4, ctx4, con);
                            int size = subfolderIds.size();
                            ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(size);
                            int i322 = 0;
                            while (true) {
                                if (i322 >= size) {
                                    SortableId[] i322 = list.toArray(new SortableId[list.size()]);
                                    return i322;
                                }
                                String[] sa = subfolderIds.get(i322);
                                list.add(new DatabaseId(sa[0], i322, sa[1]));
                                ++i322;
                            }
                        }
                        if (3 == parentId) {
                            UserPermissionBits userPermissionBits5;
                            User user5 = storageParameters.getUser();
                            Context ctx5 = storageParameters.getContext();
                            Session s = storageParameters.getSession();
                            if (s instanceof ServerSession) {
                                UserPermissionBits userPermissionBits52 = ((ServerSession)s).getUserPermissionBits();
                            } else {
                                userPermissionBits5 = UserPermissionBitsStorage.getInstance().getUserPermissionBits(user5.getId(), ctx5);
                            }
                            List<String[]> subfolderIds = SystemSharedFolder.getSystemSharedFolderSubfolder(user5, userPermissionBits5, ctx5, con);
                            int size = subfolderIds.size();
                            ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(size);
                            int i422 = 0;
                            while (true) {
                                if (i422 >= size) {
                                    SortableId[] i422 = list.toArray(new SortableId[list.size()]);
                                    return i422;
                                }
                                String[] sa = subfolderIds.get(i422);
                                list.add(new DatabaseId(sa[0], i422, sa[1]));
                                ++i422;
                            }
                        }
                        if (2 == parentId) {
                            UserPermissionBits userPermissionBits6;
                            User user6 = storageParameters.getUser();
                            Context ctx6 = storageParameters.getContext();
                            Session s = storageParameters.getSession();
                            if (s instanceof ServerSession) {
                                UserPermissionBits userPermissionBits62 = ((ServerSession)s).getUserPermissionBits();
                            } else {
                                userPermissionBits6 = UserPermissionBitsStorage.getInstance().getUserPermissionBits(user6.getId(), ctx6);
                            }
                            List<String[]> subfolderIds = SystemPublicFolder.getSystemPublicFolderSubfolders(user6, userPermissionBits6, ctx6, con);
                            int size = subfolderIds.size();
                            ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(size);
                            int i522 = 0;
                            while (true) {
                                if (i522 >= size) {
                                    SortableId[] i522 = list.toArray(new SortableId[list.size()]);
                                    return i522;
                                }
                                String[] sa = subfolderIds.get(i522);
                                list.add(new DatabaseId(sa[0], i522, sa[1]));
                                ++i522;
                            }
                        }
                        if (9 != parentId) break block62;
                        user = storageParameters.getUser();
                        ctx = storageParameters.getContext();
                        final Session s = storageParameters.getSession();
                        userPermissionBits = s instanceof ServerSession ? ((ServerSession)s).getUserPermissionBits() : UserPermissionBitsStorage.getInstance().getUserPermissionBits(user.getId(), ctx);
                        l = null;
                        if (!REAL_TREE_ID.equals(treeId)) break block63;
                        final ConcurrentLinkedQueue fsAccounts = new ConcurrentLinkedQueue();
                        FileStorageServiceRegistry fsr = Services.getService(FileStorageServiceRegistry.class);
                        if (null == fsr) break block63;
                        CallerRunsCompletionService completionService = new CallerRunsCompletionService();
                        int taskCount = 0;
                        try {
                            List allServices = fsr.getAllServices();
                            for (final FileStorageService fsService : allServices) {
                                Callable<Void> task = new Callable<Void>(){

                                    @Override
                                    public Void call() throws Exception {
                                        List userAccounts = null;
                                        if (fsService instanceof AccountAware) {
                                            userAccounts = ((AccountAware)fsService).getAccounts(s);
                                        }
                                        if (null == userAccounts) {
                                            userAccounts = fsService.getAccountManager().getAccounts(s);
                                        }
                                        for (FileStorageAccount userAccount : userAccounts) {
                                            if ("infostore".equals(userAccount.getId()) || "0".equals(userAccount.getId())) continue;
                                            fsAccounts.add(userAccount);
                                        }
                                        return null;
                                    }
                                };
                                completionService.submit(task);
                                ++taskCount;
                            }
                        }
                        catch (OXException e2) {
                            LOG.error("", (Throwable)e2);
                        }
                        int i = taskCount;
                        while (i-- > 0) {
                            completionService.take();
                        }
                        if (fsAccounts.isEmpty()) break block63;
                        l = new LinkedList<String[]>();
                        accountList = new ArrayList(fsAccounts);
                        Collections.sort(accountList, new FileStorageAccountComparator(user.getLocale()));
                        sz = accountList.size();
                        String fid = "";
                        break block64;
                    }
                    if (10 == parentId && !InfostoreFacades.isInfoStoreAvailable() && null != (defaultAccount = DatabaseFolderConverter.getDefaultFileStorageAccess(session = storageParameters.getSession()))) {
                        FileStorageService fileStorageService = defaultAccount.getFileStorageService();
                        String defaultId = "0";
                        defaultFileStorageAccess = fileStorageService.getAccountAccess("0", session);
                        defaultFileStorageAccess.connect();
                        FileStorageFolder personalFolder = defaultFileStorageAccess.getFolderAccess().getPersonalFolder();
                        FolderID folderID = new FolderID(fileStorageService.getId(), defaultAccount.getId(), personalFolder.getId());
                        SortableId[] list = new SortableId[]{new DatabaseId(folderID.toUniqueID(), 0, personalFolder.getName())};
                        return list;
                    }
                    if (15 == parentId && !InfostoreFacades.isInfoStoreAvailable() && null != (defaultAccount = DatabaseFolderConverter.getDefaultFileStorageAccess(session = storageParameters.getSession()))) {
                        FileStorageService fileStorageService = defaultAccount.getFileStorageService();
                        String defaultId = "0";
                        FileStorageAccountAccess defaultFileStorageAccess2 = fileStorageService.getAccountAccess("0", session);
                        defaultFileStorageAccess2.connect();
                        try {
                            FileStorageFolder[] publicFolders = defaultFileStorageAccess2.getFolderAccess().getPublicFolders();
                            SortableId[] ret = new SortableId[publicFolders.length];
                            String serviceId = fileStorageService.getId();
                            String accountId = defaultAccount.getId();
                            for (int i = 0; i < publicFolders.length; ++i) {
                                FileStorageFolder folder = publicFolders[i];
                                FolderID folderID = new FolderID(serviceId, accountId, folder.getId());
                                ret[i] = new DatabaseId(folderID.toUniqueID(), i, folder.getName());
                            }
                            SortableId[] sortableIdArray = ret;
                            return sortableIdArray;
                        }
                        finally {
                            defaultFileStorageAccess2.close();
                        }
                    }
                    boolean doDBSorting = true;
                    List<OXFolderLoader.IdAndName> idAndNames = OXFolderLoader.getSubfolderIdAndNames(parentId, storageParameters.getContext(), con);
                    int size = idAndNames.size();
                    ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(size);
                    int i = 0;
                    while (true) {
                        if (i >= size) {
                            SortableId[] sortableIdArray = list.toArray(new SortableId[size]);
                            return sortableIdArray;
                        }
                        OXFolderLoader.IdAndName idAndName = idAndNames.get(i);
                        list.add(new DatabaseId(idAndName.getFolderId(), i, idAndName.getName()));
                        ++i;
                    }
                    finally {
                        defaultFileStorageAccess.close();
                    }
                }
                for (int i2 = 0; i2 < sz; ++i2) {
                    FileStorageService tmp;
                    FileStorageAccount fsa = (FileStorageAccount)accountList.get(i2);
                    String serviceId = fsa instanceof ServiceAware ? ((ServiceAware)fsa).getServiceId() : (null == (tmp = fsa.getFileStorageService()) ? null : tmp.getId());
                    FolderID folderID = new FolderID(serviceId, fsa.getId(), "");
                    l.add(new String[]{folderID.toUniqueID(), fsa.getDisplayName()});
                }
            }
            boolean altNames = StorageParametersUtility.getBoolParameter("altNames", storageParameters);
            List<String[]> subfolderIds = SystemInfostoreFolder.getSystemInfostoreFolderSubfolders(user, userPermissionBits, ctx, altNames, storageParameters.getSession(), con);
            ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(subfolderIds.size() + (null == l ? 0 : l.size()));
            int in = 0;
            for (String[] sa : subfolderIds) {
                list.add(new DatabaseId(sa[0], in++, sa[1]));
            }
            if (null != l) {
                for (String[] sa : l) {
                    list.add(new DatabaseId(sa[0], in++, sa[1]));
                }
            }
            Iterator<Object> i$ = list.toArray(new SortableId[list.size()]);
            return i$;
        }
        catch (SQLException e3222) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e3222, e3222.getMessage());
        }
        catch (InterruptedException e4) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e4, e4.getMessage());
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(StorageParameters params) {
        ConnectionMode con;
        try {
            con = DatabaseFolderStorage.optParameter(ConnectionMode.class, PARAM_CONNECTION, params);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            return;
        }
        if (null == con) {
            return;
        }
        params.putParameter(this.getFolderType(), PARAM_CONNECTION, null);
        if (con.isWritable()) {
            try {
                DBUtils.rollback(con.connection);
            }
            finally {
                DBUtils.autocommit(con.connection);
                DatabaseService databaseService = (DatabaseService)this.services.getService(DatabaseService.class);
                if (null != databaseService) {
                    con.close(databaseService, params.getContext().getContextId());
                }
            }
        } else {
            DatabaseService databaseService = (DatabaseService)this.services.getService(DatabaseService.class);
            if (null != databaseService) {
                databaseService.backReadOnly(params.getContext(), con.connection);
            }
        }
    }

    @Override
    public boolean startTransaction(StorageParameters parameters, boolean modify) throws OXException {
        return this.startTransaction(parameters, modify ? AfterReadAwareFolderStorage.Mode.WRITE : AfterReadAwareFolderStorage.Mode.READ);
    }

    @Override
    public boolean startTransaction(StorageParameters parameters, AfterReadAwareFolderStorage.Mode mode) throws OXException {
        FolderType folderType = this.getFolderType();
        try {
            DatabaseService databaseService = (DatabaseService)this.services.getService(DatabaseService.class);
            Context context = parameters.getContext();
            ConnectionMode con = (ConnectionMode)parameters.getParameter(folderType, PARAM_CONNECTION);
            if (null != con) {
                if (con.supports(mode)) {
                    return false;
                }
                parameters.putParameter(folderType, PARAM_CONNECTION, null);
                if (con.isWritable()) {
                    try {
                        con.connection.commit();
                    }
                    catch (Exception e) {
                        DBUtils.rollback(con.connection);
                    }
                    DBUtils.autocommit(con.connection);
                }
                con.close(databaseService, context.getContextId());
            }
            if (WRITEES.contains((Object)mode)) {
                con = new ConnectionMode(databaseService.getWritable(context), mode);
                con.connection.setAutoCommit(false);
            } else {
                con = new ConnectionMode(databaseService.getReadOnly(context), mode);
            }
            if (!parameters.putParameterIfAbsent(folderType, PARAM_CONNECTION, con)) {
                if (con.isWritable()) {
                    con.connection.setAutoCommit(true);
                }
                con.close(databaseService, context.getContextId());
            }
            return true;
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = this.getConnection(AfterReadAwareFolderStorage.Mode.WRITE, storageParameters);
        try {
            Permission[] perms;
            Map<String, Object> meta;
            String parentId;
            Connection con = provider.getConnection();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            String id = folder.getID();
            Context context = storageParameters.getContext();
            if (DatabaseFolderStorageUtility.hasSharedPrefix(id)) {
                int owner = Integer.parseInt(id.substring("u:".length()));
                throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(OXFolderUtility.getUserName(session.getUserId(), context), UserStorage.getInstance().getUser(owner, context).getDisplayName(), context.getContextId());
            }
            int folderId = Integer.parseInt(id);
            Date clientLastModified = storageParameters.getTimeStamp();
            if (null != clientLastModified && DatabaseFolderStorage.getFolderAccess(context, con).getFolderLastModified(folderId).after(clientLastModified)) {
                throw FolderExceptionErrorMessage.CONCURRENT_MODIFICATION.create();
            }
            Date millis = new Date();
            FolderObject updateMe = new FolderObject();
            updateMe.setObjectID(folderId);
            updateMe.setDefaultFolder(false);
            String name = folder.getName();
            if (null != name) {
                updateMe.setFolderName(name);
            }
            updateMe.setLastModified(millis);
            folder.setLastModified(millis);
            updateMe.setModifiedBy(session.getUserId());
            ContentType ct = folder.getContentType();
            if (null != ct) {
                updateMe.setModule(DatabaseFolderStorage.getModuleByContentType(ct));
            }
            if (null == (parentId = folder.getParentID())) {
                updateMe.setParentFolderID(DatabaseFolderStorage.getFolderObject(folderId, context, con, storageParameters).getParentFolderID());
            } else if (DatabaseFolderStorageUtility.hasSharedPrefix(parentId)) {
                updateMe.setParentFolderID(DatabaseFolderStorage.getFolderObject(folderId, context, con, storageParameters).getParentFolderID());
            } else {
                updateMe.setParentFolderID(Integer.parseInt(parentId));
            }
            Type t = folder.getType();
            if (null != t) {
                updateMe.setType(DatabaseFolderStorage.getTypeByFolderType(t));
            }
            if (null != (meta = folder.getMeta())) {
                updateMe.setMeta(meta);
            }
            if (null != (perms = folder.getPermissions())) {
                OCLPermission[] oclPermissions = new OCLPermission[perms.length];
                for (int i = 0; i < perms.length; ++i) {
                    Permission p = perms[i];
                    OCLPermission oclPerm = new OCLPermission();
                    oclPerm.setEntity(p.getEntity());
                    oclPerm.setGroupPermission(p.isGroup());
                    oclPerm.setFolderAdmin(p.isAdmin());
                    oclPerm.setAllPermission(p.getFolderPermission(), p.getReadPermission(), p.getWritePermission(), p.getDeletePermission());
                    oclPerm.setSystem(p.getSystem());
                    oclPermissions[i] = oclPerm;
                }
                updateMe.setPermissionsAsArray(oclPermissions);
            }
            OXFolderManager folderManager = OXFolderManager.getInstance(session, con, con);
            folderManager.updateFolder(updateMe, true, StorageParametersUtility.isHandDownPermissions(storageParameters), millis.getTime());
            List<OXException> warnings = folderManager.getWarnings();
            if (null != warnings) {
                for (OXException warning : warnings) {
                    storageParameters.addWarning(warning);
                }
            }
        }
        finally {
            provider.close();
        }
    }

    @Override
    public StoragePriority getStoragePriority() {
        return StoragePriority.NORMAL;
    }

    @Override
    public boolean containsFolder(String treeId, String folderIdentifier, StorageParameters storageParameters) throws OXException {
        return this.containsFolder(treeId, folderIdentifier, StorageType.WORKING, storageParameters);
    }

    @Override
    public boolean containsFolder(String treeId, String folderIdentifier, StorageType storageType, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = this.getConnection(AfterReadAwareFolderStorage.Mode.READ, storageParameters);
        try {
            int folderId;
            Connection con = provider.getConnection();
            User user = storageParameters.getUser();
            Context ctx = storageParameters.getContext();
            Session s = storageParameters.getSession();
            UserPermissionBits userPermissionBits = s instanceof ServerSession ? ((ServerSession)s).getUserPermissionBits() : UserPermissionBitsStorage.getInstance().getUserPermissionBits(user.getId(), ctx);
            boolean retval = StorageType.WORKING.equals(storageType) ? (DatabaseFolderStorageUtility.hasSharedPrefix(folderIdentifier) ? SharedPrefixFolder.existsSharedPrefixFolder(folderIdentifier, user, userPermissionBits, ctx, con) : ((folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier)) < 0 ? false : (0 == folderId ? true : (Arrays.binarySearch(VIRTUAL_IDS, folderId) >= 0 ? VirtualListFolder.existsVirtualListFolder(folderId, user, userPermissionBits, ctx, con) : (3 == folderId ? true : (2 == folderId ? true : (9 == folderId ? true : (1 == folderId ? true : OXFolderSQL.exists(folderId, con, ctx))))))))) : ((folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier)) < 0 ? false : OXFolderSQL.exists(folderId, con, ctx, "del_oxfolder_tree"));
            boolean bl = retval;
            return bl;
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getModifiedFolderIDs(String treeId, Date timeStamp, ContentType[] includeContentTypes, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = this.getConnection(AfterReadAwareFolderStorage.Mode.READ, storageParameters);
        try {
            Connection con = provider.getConnection();
            Context ctx = storageParameters.getContext();
            Queue<FolderObject> q = ((FolderObjectIterator)OXFolderIteratorSQL.getAllModifiedFoldersSince(timeStamp == null ? new Date(0L) : timeStamp, ctx, con)).asQueue();
            int size = q.size();
            Iterator iterator = q.iterator();
            String[] ret = new String[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = String.valueOf(((FolderObject)iterator.next()).getObjectID());
            }
            String[] stringArray = ret;
            return stringArray;
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getDeletedFolderIDs(String treeId, Date timeStamp, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = this.getConnection(AfterReadAwareFolderStorage.Mode.READ, storageParameters);
        try {
            Connection con = provider.getConnection();
            User user = storageParameters.getUser();
            Context ctx = storageParameters.getContext();
            Session s = storageParameters.getSession();
            UserPermissionBits userPermissionBits = s instanceof ServerSession ? ((ServerSession)s).getUserPermissionBits() : UserPermissionBitsStorage.getInstance().getUserPermissionBits(user.getId(), ctx);
            Queue<FolderObject> q = ((FolderObjectIterator)OXFolderIteratorSQL.getDeletedFoldersSince(timeStamp, user.getId(), user.getGroups(), userPermissionBits.getAccessibleModules(), ctx, con)).asQueue();
            int size = q.size();
            Iterator iterator = q.iterator();
            String[] ret = new String[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = String.valueOf(((FolderObject)iterator.next()).getObjectID());
            }
            String[] stringArray = ret;
            return stringArray;
        }
        finally {
            provider.close();
        }
    }

    private static FolderObject getFolderObject(int folderId, Context ctx, Connection con, StorageParameters storageParameters) throws OXException {
        Boolean ignoreCache = storageParameters.getIgnoreCache();
        if (!FolderCacheManager.isEnabled()) {
            return FolderObject.loadFolderObjectFromDB(folderId, ctx, con, true, true);
        }
        FolderCacheManager cacheManager = FolderCacheManager.getInstance();
        if (Boolean.TRUE.equals(ignoreCache)) {
            FolderObject fo = FolderObject.loadFolderObjectFromDB(folderId, ctx, con, true, true);
            cacheManager.putFolderObject(fo, ctx, true, null);
            return fo;
        }
        FolderObject fo = cacheManager.getFolderObject(folderId, ctx);
        if (null == fo) {
            fo = FolderObject.loadFolderObjectFromDB(folderId, ctx, con, true, true);
            cacheManager.putFolderObject(fo, ctx, false, null);
        }
        return fo;
    }

    private static List<FolderObject> getFolderObjects(int[] folderIds, Context ctx, Connection con, StorageParameters storageParameters) throws OXException {
        Boolean ignoreCache = storageParameters.getIgnoreCache();
        if (!FolderCacheManager.isEnabled()) {
            return OXFolderBatchLoader.loadFolderObjectsFromDB(folderIds, ctx, con, true, true);
        }
        FolderCacheManager cacheManager = FolderCacheManager.getInstance();
        if (Boolean.TRUE.equals(ignoreCache)) {
            List<FolderObject> folders2 = OXFolderBatchLoader.loadFolderObjectsFromDB(folderIds, ctx, con, true, true);
            for (FolderObject fo : folders2) {
                cacheManager.putFolderObject(fo, ctx, true, null);
            }
            return folders2;
        }
        int length = folderIds.length;
        FolderObject[] ret = new FolderObject[length];
        TIntIntHashMap toLoad = new TIntIntHashMap(length);
        for (int index = 0; index < length; ++index) {
            int folderId = folderIds[index];
            FolderObject fo = cacheManager.getFolderObject(folderId, ctx);
            if (null == fo) {
                toLoad.put(folderId, index);
                continue;
            }
            ret[index] = fo;
        }
        if (!toLoad.isEmpty()) {
            List<FolderObject> list = OXFolderBatchLoader.loadFolderObjectsFromDB(toLoad.keys(), ctx, con, true, true);
            for (FolderObject folderObject : list) {
                if (null == folderObject) continue;
                int index = toLoad.get(folderObject.getObjectID());
                ret[index] = folderObject;
                cacheManager.putFolderObject(folderObject, ctx, false, null);
            }
        }
        return Arrays.asList(ret);
    }

    private static OXFolderAccess getFolderAccess(Context ctx, Connection con) {
        return new OXFolderAccess(con, ctx);
    }

    private ConnectionProvider getConnection(AfterReadAwareFolderStorage.Mode mode, StorageParameters storageParameters) throws OXException {
        ConnectionMode connection = DatabaseFolderStorage.optParameter(ConnectionMode.class, PARAM_CONNECTION, storageParameters);
        if (null != connection) {
            return new NonClosingConnectionProvider(connection);
        }
        Context context = storageParameters.getContext();
        DatabaseService databaseService = (DatabaseService)this.services.getService(DatabaseService.class);
        connection = WRITEES.contains((Object)mode) ? new ConnectionMode(databaseService.getWritable(context), mode) : new ConnectionMode(databaseService.getReadOnly(context), mode);
        return new ClosingConnectionProvider(connection, databaseService, context.getContextId());
    }

    private static <T> T getParameter(Class<T> clazz, String name, StorageParameters parameters) throws OXException {
        T parameter = DatabaseFolderStorage.optParameter(clazz, name, parameters);
        if (null == parameter) {
            throw OXFolderExceptionCode.MISSING_PARAMETER.create(name);
        }
        return parameter;
    }

    private static <T> T optParameter(Class<T> clazz, String name, StorageParameters parameters) throws OXException {
        Object obj = parameters.getParameter(DatabaseFolderType.getInstance(), name);
        if (null == obj) {
            return null;
        }
        try {
            return clazz.cast(obj);
        }
        catch (ClassCastException e) {
            throw OXFolderExceptionCode.MISSING_PARAMETER.create(e, name);
        }
    }

    private static int getModuleByContentType(ContentType contentType) {
        String cts = ((Object)contentType).toString();
        if (TaskContentType.getInstance().toString().equals(cts)) {
            return 1;
        }
        if (CalendarContentType.getInstance().toString().equals(cts)) {
            return 2;
        }
        if (ContactContentType.getInstance().toString().equals(cts)) {
            return 3;
        }
        if (InfostoreContentType.getInstance().toString().equals(cts)) {
            return 8;
        }
        return 4;
    }

    private static int getTypeByFolderType(Type type) {
        if (PrivateType.getInstance().equals(type)) {
            return 1;
        }
        if (PublicType.getInstance().equals(type)) {
            return 2;
        }
        if (TrashType.getInstance().equals(type)) {
            return 16;
        }
        return 5;
    }

    private static int getTypeByFolderTypeWithShared(Type type) {
        if (PrivateType.getInstance().equals(type)) {
            return 1;
        }
        if (PublicType.getInstance().equals(type)) {
            return 2;
        }
        if (SharedType.getInstance().equals(type)) {
            return 3;
        }
        if (TrashType.getInstance().equals(type)) {
            return 16;
        }
        return 5;
    }

    public static final class ConnectionMode {
        public final Connection connection;
        public AfterReadAwareFolderStorage.Mode readWrite;

        public ConnectionMode(Connection connection, AfterReadAwareFolderStorage.Mode readWrite) {
            this.connection = connection;
            this.readWrite = readWrite;
        }

        public boolean isWritable() {
            return WRITEES.contains((Object)this.readWrite);
        }

        public boolean supports(AfterReadAwareFolderStorage.Mode mode) {
            if (this.isWritable()) {
                if (WRITEES.contains((Object)mode)) {
                    this.readWrite = mode;
                }
                return true;
            }
            return this.readWrite == mode;
        }

        public void close(DatabaseService databaseService, int contextId) {
            if (AfterReadAwareFolderStorage.Mode.WRITE == this.readWrite) {
                databaseService.backWritable(contextId, this.connection);
            } else if (AfterReadAwareFolderStorage.Mode.WRITE_AFTER_READ == this.readWrite) {
                databaseService.backWritableAfterReading(contextId, this.connection);
            } else {
                databaseService.backReadOnly(contextId, this.connection);
            }
        }
    }

    private static final class FileStorageAccountComparator
    implements Comparator<FileStorageAccount> {
        private final Collator collator;

        public FileStorageAccountComparator(Locale locale) {
            this.collator = Collators.getSecondaryInstance((Locale)locale);
        }

        @Override
        public int compare(FileStorageAccount o1, FileStorageAccount o2) {
            return this.collator.compare(o1.getDisplayName(), o2.getDisplayName());
        }
    }

    private static final class FolderNameComparator
    implements Comparator<FolderObject> {
        private final Collator collator;
        private final Context context;

        FolderNameComparator(Locale locale, Context context) {
            this.collator = Collators.getSecondaryInstance((Locale)locale);
            this.context = context;
        }

        @Override
        public int compare(FolderObject o1, FolderObject o2) {
            String folderName2;
            String folderName1 = o1.getFolderName();
            if (folderName1.equals(folderName2 = o2.getFolderName())) {
                int owner1 = o1.getCreatedBy();
                int owner2 = o2.getCreatedBy();
                if (owner1 > 0 && owner2 > 0 && owner1 != owner2) {
                    String d2;
                    String d1;
                    try {
                        d1 = UserStorage.getInstance().getUser(owner1, this.context).getDisplayName();
                    }
                    catch (OXException e) {
                        d1 = null;
                    }
                    try {
                        d2 = UserStorage.getInstance().getUser(owner2, this.context).getDisplayName();
                    }
                    catch (OXException e) {
                        d2 = null;
                    }
                    return this.collator.compare(d1, d2);
                }
            }
            return this.collator.compare(folderName1, folderName2);
        }
    }

    private static final class FolderObjectComparator
    implements Comparator<FolderObject> {
        private final Collator collator;
        private final Context context;

        FolderObjectComparator(Locale locale, Context context) {
            this.collator = Collators.getSecondaryInstance((Locale)locale);
            this.context = context;
        }

        @Override
        public int compare(FolderObject o1, FolderObject o2) {
            if (o1.isDefaultFolder()) {
                if (o2.isDefaultFolder()) {
                    if (o1.getFolderName().equals(o2.getFolderName())) {
                        int owner1 = o1.getCreatedBy();
                        int owner2 = o2.getCreatedBy();
                        if (owner1 > 0 && owner2 > 0 && owner1 != owner2) {
                            String d2;
                            String d1;
                            try {
                                d1 = UserStorage.getInstance().getUser(owner1, this.context).getDisplayName();
                            }
                            catch (OXException e) {
                                d1 = null;
                            }
                            try {
                                d2 = UserStorage.getInstance().getUser(owner2, this.context).getDisplayName();
                            }
                            catch (OXException e) {
                                d2 = null;
                            }
                            return this.collator.compare(d1, d2);
                        }
                    }
                    return FolderObjectComparator.compareById(o1.getObjectID(), o2.getObjectID());
                }
                return -1;
            }
            if (o2.isDefaultFolder()) {
                return 1;
            }
            return this.collator.compare(o1.getFolderName(), o2.getFolderName());
        }

        private static int compareById(int id1, int id2) {
            return id1 < id2 ? -1 : (id1 == id2 ? 0 : 1);
        }
    }

    private static final class ClosingConnectionProvider
    implements ConnectionProvider {
        private final DatabaseService databaseService;
        private final ConnectionMode connection;
        private final int contextId;

        protected ClosingConnectionProvider(ConnectionMode connection, DatabaseService databaseService, int contextId) {
            this.connection = connection;
            this.databaseService = databaseService;
            this.contextId = contextId;
        }

        @Override
        public Connection getConnection() {
            return this.connection.connection;
        }

        @Override
        public void close() {
            this.connection.close(this.databaseService, this.contextId);
        }
    }

    private static final class NonClosingConnectionProvider
    implements ConnectionProvider {
        private final ConnectionMode connection;

        protected NonClosingConnectionProvider(ConnectionMode connection) {
            this.connection = connection;
        }

        @Override
        public Connection getConnection() {
            return this.connection.connection;
        }

        @Override
        public void close() {
        }
    }

    private static interface ConnectionProvider {
        public Connection getConnection();

        public void close();
    }
}

