/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.internal;

import com.openexchange.contact.ContactServiceInterceptor;
import com.openexchange.contact.internal.ContactServiceInterceptorRegistry;
import com.openexchange.contact.internal.Tools;
import com.openexchange.contact.storage.ContactStorage;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.Attachments;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultIterator
implements SearchIterator<Contact> {
    private static final Logger LOG = LoggerFactory.getLogger(ResultIterator.class);
    private static final ContactField[] DLISTMEMBER_FIELDS = new ContactField[]{ContactField.FOLDER_ID, ContactField.OBJECT_ID, ContactField.CREATED_BY, ContactField.PRIVATE_FLAG, ContactField.LAST_MODIFIED, ContactField.DISPLAY_NAME, ContactField.SUR_NAME, ContactField.GIVEN_NAME, ContactField.EMAIL1, ContactField.EMAIL2, ContactField.EMAIL3};
    private final SearchIterator<Contact> delegate;
    private final boolean needsAttachmentInfo;
    private Contact next;
    private final Map<String, Boolean> canReadAllMap;
    private final Boolean canReadAll;
    private final Session session;
    private final ContactServiceInterceptorRegistry contactInterceptorRegistry;

    public ResultIterator(SearchIterator<Contact> delegate, boolean needsAttachmentInfo, Session session, ContactServiceInterceptorRegistry contactInterceptorRegistry) throws OXException {
        this(delegate, needsAttachmentInfo, session, contactInterceptorRegistry, null);
    }

    public ResultIterator(SearchIterator<Contact> delegate, boolean needsAttachmentInfo, Session session, ContactServiceInterceptorRegistry contactInterceptorRegistry, boolean canReadAll) throws OXException {
        this(delegate, needsAttachmentInfo, session, contactInterceptorRegistry, (Boolean)canReadAll);
    }

    private ResultIterator(SearchIterator<Contact> delegate, boolean needsAttachmentInfo, Session session, ContactServiceInterceptorRegistry contactInterceptorRegistry, Boolean canReadAll) throws OXException {
        this.delegate = delegate;
        this.needsAttachmentInfo = needsAttachmentInfo;
        this.session = session;
        this.canReadAll = canReadAll;
        this.contactInterceptorRegistry = contactInterceptorRegistry;
        this.canReadAllMap = new HashMap<String, Boolean>();
        this.initNext();
    }

    private void initNext() throws OXException {
        while (this.delegate.hasNext()) {
            this.next = (Contact)this.delegate.next();
            if (!this.accept(this.next)) continue;
            this.addAttachmentInfo(this.next);
            this.addDistributionListInfo(this.next);
            this.onAfterRead(this.next);
            return;
        }
        this.next = null;
    }

    private void addAttachmentInfo(Contact contact) throws OXException {
        if (this.needsAttachmentInfo && !contact.containsLastModifiedOfNewestAttachment() && 0 < contact.getNumberOfAttachments()) {
            contact.setLastModifiedOfNewestAttachment(Attachments.getInstance().getNewestCreationDate(Tools.getContext(this.session.getContextId()), 7, contact.getObjectID()));
        }
    }

    private void addDistributionListInfo(Contact contact) {
        DistributionListEntryObject[] members;
        if (null != contact && 0 < contact.getNumberOfDistributionLists() && null != (members = contact.getDistributionList()) && 0 < members.length) {
            Contact[] referencedContacts = this.getReferencedContacts(members);
            for (int i = 0; i < referencedContacts.length; ++i) {
                if (null != referencedContacts[i]) {
                    this.updateMemberInfo(members[i], referencedContacts[i]);
                    continue;
                }
                this.convertToOneOff(members[i]);
            }
        }
    }

    private void onAfterRead(Contact contact) throws OXException {
        List<ContactServiceInterceptor> interceptors;
        List<ContactServiceInterceptor> list = interceptors = null != this.contactInterceptorRegistry ? this.contactInterceptorRegistry.getInterceptors() : null;
        if (null != interceptors && 0 < interceptors.size()) {
            for (ContactServiceInterceptor interceptor : interceptors) {
                interceptor.afterRead(contact, this.session);
            }
        }
    }

    private void convertToOneOff(DistributionListEntryObject member) {
        member.removeFolderld();
        member.removeEntryID();
        member.setEmailfield(0);
    }

    private void updateMemberInfo(DistributionListEntryObject member, Contact referencedContact) {
        if (null != referencedContact.getDisplayName()) {
            member.setDisplayname(referencedContact.getDisplayName());
        }
        member.setFolderID(referencedContact.getParentFolderID());
        member.setEntryID(referencedContact.getObjectID());
        member.setFirstname(referencedContact.getGivenName());
        member.setLastname(referencedContact.getSurName());
        String email = null;
        if (1 == member.getEmailfield()) {
            email = referencedContact.getEmail1();
        } else if (2 == member.getEmailfield()) {
            email = referencedContact.getEmail2();
        } else if (3 == member.getEmailfield()) {
            email = referencedContact.getEmail3();
        }
        try {
            member.setEmailaddress(email);
        }
        catch (OXException e) {
            LOG.warn("Error setting e-mail address for updated distribution list member", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Contact[] getReferencedContacts(DistributionListEntryObject[] members) {
        Contact[] contacts2 = new Contact[members.length];
        HashMap folderAndObjectIDs = new HashMap();
        for (DistributionListEntryObject member : members) {
            if (0 == member.getEmailfield()) continue;
            String folderID = Integer.toString(member.getFolderID());
            if (null == folderAndObjectIDs.get(folderID)) {
                folderAndObjectIDs.put(folderID, new ArrayList());
            }
            ((List)folderAndObjectIDs.get(folderID)).add(Integer.toString(member.getEntryID()));
        }
        for (Map.Entry entry : folderAndObjectIDs.entrySet()) {
            SearchIterator<Contact> searchIterator = null;
            try {
                ContactStorage storage = Tools.getStorage(this.session, (String)entry.getKey());
                searchIterator = storage.list(this.session, "0".equals(entry.getKey()) ? null : (String)entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]), DLISTMEMBER_FIELDS);
                while (searchIterator.hasNext()) {
                    Contact contact = (Contact)searchIterator.next();
                    try {
                        if (null == contact || !this.accept(contact, null)) continue;
                        for (int i = 0; i < members.length; ++i) {
                            if (members[i].getEntryID() != contact.getObjectID() || 0 != members[i].getFolderID() && members[i].getFolderID() != contact.getParentFolderID()) continue;
                            contacts2[i] = contact;
                        }
                    }
                    catch (OXException e) {
                        LOG.warn("Error resolving referenced member for distribution list", (Throwable)e);
                    }
                }
            }
            catch (OXException e) {
                LOG.warn("Error resolving referenced members for distribution list", (Throwable)e);
            }
            finally {
                if (null == searchIterator) continue;
                try {
                    searchIterator.close();
                }
                catch (OXException e) {
                    LOG.warn(e.toString());
                }
            }
        }
        return contacts2;
    }

    private boolean accept(Contact contact) throws OXException {
        return this.accept(contact, this.canReadAll);
    }

    private boolean accept(Contact contact, Boolean canReadAll) throws OXException {
        if (contact.getCreatedBy() == this.session.getUserId()) {
            return true;
        }
        if (contact.containsPrivateFlag()) {
            return false;
        }
        if (null != canReadAll) {
            return canReadAll;
        }
        String folderID = Integer.toString(contact.getParentFolderID());
        if (!this.canReadAllMap.containsKey(folderID)) {
            boolean canReadAllObjects = false;
            try {
                EffectivePermission permission = Tools.getPermission(this.session.getContextId(), folderID, this.session.getUserId());
                canReadAllObjects = permission.canReadAllObjects();
            }
            catch (OXException e) {
                LOG.debug("Unable to determine effective permissions for folder '{}'", (Object)folderID, (Object)e);
            }
            this.canReadAllMap.put(folderID, canReadAllObjects);
        }
        return this.canReadAllMap.get(folderID);
    }

    public boolean hasNext() throws OXException {
        return null != this.next;
    }

    public Contact next() throws OXException {
        Contact current = this.next;
        this.initNext();
        return current;
    }

    public void close() throws OXException {
        this.delegate.close();
    }

    public int size() {
        return -1;
    }

    public boolean hasWarnings() {
        return this.delegate.hasWarnings();
    }

    public void addWarning(OXException warning) {
        this.delegate.addWarning(warning);
    }

    public OXException[] getWarnings() {
        return this.delegate.getWarnings();
    }
}

