/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.concurrent;

import com.openexchange.concurrent.Blocker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class NonBlockingBlocker
implements Blocker,
Runnable {
    private static final Object PRESENT = new Object();
    private volatile Runnable runnable;
    private final Map<Thread, Object> running;
    private final AtomicInteger sync = new AtomicInteger();
    private final AtomicInteger mutex = new AtomicInteger();
    private volatile Thread owner;

    public NonBlockingBlocker() {
        this(null);
    }

    public NonBlockingBlocker(Runnable runnable) {
        this.running = new ConcurrentHashMap<Thread, Object>(4);
        this.runnable = runnable;
    }

    private int lock() {
        int value;
        while (((value = this.mutex.get()) & 1) == 1) {
        }
        while (!this.mutex.compareAndSet(value, value | 1)) {
            while (((value = this.mutex.get()) & 1) == 1) {
            }
        }
        return value | 1;
    }

    private void unlock(int value) {
        this.mutex.set(value + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void block() {
        Thread cur = Thread.currentThread();
        if (cur == this.owner) {
            return;
        }
        int lock = this.lock();
        try {
            int value;
            while (((value = this.sync.get()) & 1) == 1) {
            }
            while (!this.sync.compareAndSet(value, value + 1)) {
                while (((value = this.sync.get()) & 1) == 1) {
                }
            }
            this.owner = cur;
            while (!this.running.isEmpty()) {
            }
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquire() {
        Thread currentThread = Thread.currentThread();
        if (currentThread == this.owner) {
            return;
        }
        if (this.running.containsKey(currentThread)) {
            return;
        }
        int lock = this.lock();
        try {
            int save;
            while (((save = this.sync.get()) & 1) == 1 || save != this.sync.get()) {
            }
            this.running.put(currentThread, PRESENT);
        }
        finally {
            this.unlock(lock);
        }
    }

    @Override
    public void unblock() {
        if (null == this.owner || Thread.currentThread() != this.owner) {
            throw new IllegalMonitorStateException(new StringBuilder(32).append("Thread ").append(Thread.currentThread().getName()).append(" does not own this blocker").toString());
        }
        this.sync.getAndIncrement();
        this.owner = null;
    }

    @Override
    public void release() {
        Thread currentThread = Thread.currentThread();
        if (currentThread == this.owner) {
            return;
        }
        this.running.remove(currentThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.acquire();
        try {
            if (this.runnable != null) {
                this.runnable.run();
            }
        }
        finally {
            this.release();
        }
    }

    public boolean holdsBlock() {
        return this.owner == Thread.currentThread();
    }
}

