/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.fields.ResponseFields;
import com.openexchange.ajax.requesthandler.Utils;
import com.openexchange.ajax.response.IncludeStackTraceService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.PropertyEvent;
import com.openexchange.config.PropertyListener;
import com.openexchange.exception.Categories;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.i18n.Localizable;
import com.openexchange.java.util.UUIDs;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.json.io.Jsonable;
import com.openexchange.log.LogProperties;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseWriter {
    private static final Set<String> RESERVED_IDENTIFIERS = ResponseFields.RESERVED_IDENTIFIERS;
    private static volatile Locale defaultLocale;
    private static final AtomicReference<IncludeStackTraceService> INCL_STACKTRACE_REF;
    static volatile Boolean includeStackTraceOnError;
    static volatile Boolean includeArguments;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Locale defaultLocale() {
        Locale tmp = defaultLocale;
        if (null != tmp) return tmp;
        Class<ResponseWriter> clazz = ResponseWriter.class;
        synchronized (ResponseWriter.class) {
            tmp = defaultLocale;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                tmp = Locale.US;
            } else {
                String property = service.getProperty("com.openexchange.i18n.defaultLocale");
                Locale locale = tmp = null == property ? Locale.US : LocaleTools.getLocale((String)property);
                if (null == tmp) {
                    tmp = Locale.US;
                }
            }
            defaultLocale = tmp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private ResponseWriter() {
    }

    public static void setIncludeStackTraceService(IncludeStackTraceService includeStackTraceService) {
        INCL_STACKTRACE_REF.set(includeStackTraceService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean includeStackTraceOnError() {
        Boolean b;
        IncludeStackTraceService traceService = INCL_STACKTRACE_REF.get();
        if (null != traceService && traceService.isEnabled()) {
            try {
                int userId;
                int contextId = Utils.getUnsignedInteger(LogProperties.get((LogProperties.Name)LogProperties.Name.SESSION_CONTEXT_ID));
                if (contextId > 0 && (userId = Utils.getUnsignedInteger(LogProperties.get((LogProperties.Name)LogProperties.Name.SESSION_USER_ID))) > 0) {
                    return traceService.includeStackTraceOnError(userId, contextId);
                }
            }
            catch (Exception e) {
                Logger logger = LoggerFactory.getLogger(ResponseWriter.class);
                logger.error("Could not check includeStackTraceOnError()", (Throwable)e);
            }
        }
        if (null != (b = includeStackTraceOnError)) return b;
        Class<ResponseWriter> clazz = ResponseWriter.class;
        synchronized (ResponseWriter.class) {
            b = includeStackTraceOnError;
            if (null != b) return b;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_3] (shouldn't be in output)
                return false;
            }
            includeStackTraceOnError = b = Boolean.valueOf(service.getBoolProperty("com.openexchange.ajax.response.includeStackTraceOnError", false, new PropertyListener(){

                public void onPropertyChange(PropertyEvent event) {
                    PropertyEvent.Type type = event.getType();
                    if (PropertyEvent.Type.DELETED == type) {
                        includeStackTraceOnError = Boolean.FALSE;
                    } else if (PropertyEvent.Type.CHANGED == type) {
                        includeStackTraceOnError = Boolean.valueOf(event.getValue().trim());
                    }
                }
            }));
            // ** MonitorExit[var1_3] (shouldn't be in output)
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean includeArguments() {
        Boolean b = includeArguments;
        if (null != b) return b;
        Class<ResponseWriter> clazz = ResponseWriter.class;
        synchronized (ResponseWriter.class) {
            b = includeArguments;
            if (null != b) return b;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            includeArguments = b = Boolean.valueOf(service.getBoolProperty("com.openexchange.ajax.response.includeArguments", false, new PropertyListener(){

                public void onPropertyChange(PropertyEvent event) {
                    PropertyEvent.Type type = event.getType();
                    if (PropertyEvent.Type.DELETED == type) {
                        includeArguments = Boolean.FALSE;
                    } else if (PropertyEvent.Type.CHANGED == type) {
                        includeArguments = Boolean.valueOf(event.getValue().trim());
                    }
                }
            }));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return b;
        }
    }

    public static JSONObject getJSON(Response response) throws JSONException {
        JSONObject json = new JSONObject(8);
        ResponseWriter.write(response, json, ResponseWriter.defaultLocale());
        return json;
    }

    public static JSONObject getJSON(Response response, Locale locale) throws JSONException {
        JSONObject json = new JSONObject(8);
        ResponseWriter.write(response, json, locale);
        return json;
    }

    public static void write(Response response, JSONObject json) throws JSONException {
        ResponseWriter.write(response, json, ResponseWriter.defaultLocale());
    }

    public static void write(Response response, JSONObject json, Locale locale) throws JSONException {
        UUID continuationUUID;
        Date timestamp;
        Object data = response.getData();
        if (null != data) {
            json.put("data", data);
        }
        if (null != (timestamp = response.getTimestamp())) {
            json.put("timestamp", timestamp.getTime());
        }
        if (null != (continuationUUID = response.getContinuationUUID())) {
            json.put("continuation", (Object)UUIDs.getUnformattedString((UUID)continuationUUID));
        }
        List<OXException> warnings = response.getWarnings();
        OXException exception = response.getException();
        if (null == exception) {
            if (null != warnings && !warnings.isEmpty()) {
                ResponseWriter.addException(json, warnings.get(0), locale, response.includeStackTraceOnError());
            }
        } else {
            ResponseWriter.addException(json, exception, locale, response.includeStackTraceOnError());
        }
        ResponseWriter.addWarnings(json, warnings, locale, response.includeStackTraceOnError());
        ResponseWriter.addProperties(json, response.getProperties());
    }

    public static void addProperties(JSONObject json, Map<String, Object> properties) throws JSONException {
        if (null == properties || properties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String name = entry.getKey();
            if (null != name && !RESERVED_IDENTIFIERS.contains(name)) {
                Object value = entry.getValue();
                if (null == value) continue;
                json.put(name, value);
                continue;
            }
            LoggerFactory.getLogger(ResponseWriter.class).warn("Response property discarded. Illegal property name: {}", (Object)(name == null ? "null" : name));
        }
    }

    public static void addWarning(JSONObject json, OXException warning, Locale locale) throws JSONException {
        if (null == warning) {
            return;
        }
        JSONObject jsonWarning = new JSONObject(8);
        ResponseWriter.addException(jsonWarning, warning.setCategory(Category.CATEGORY_WARNING), locale);
        json.put("warnings", (Object)jsonWarning);
    }

    public static void addWarnings(JSONObject json, List<OXException> warnings) throws JSONException {
        ResponseWriter.addWarnings(json, warnings, ResponseWriter.defaultLocale(), false);
    }

    public static void addWarnings(JSONObject json, List<OXException> warnings, Locale locale) throws JSONException {
        ResponseWriter.addWarnings(json, warnings, locale, false);
    }

    public static void addWarnings(JSONObject json, List<OXException> warnings, Locale locale, boolean includeStackTraceOnError) throws JSONException {
        if (null == warnings || warnings.isEmpty()) {
            return;
        }
        if (1 == warnings.size()) {
            JSONObject jsonWarning = new JSONObject(8);
            OXException warning = warnings.get(0).setCategory(Category.CATEGORY_WARNING);
            ResponseWriter.addException(jsonWarning, warning, locale);
            json.put("warnings", (Object)jsonWarning);
            if (!json.hasAndNotNull("error")) {
                ResponseWriter.addException(json, warning, locale, includeStackTraceOnError);
            }
        } else {
            JSONArray jsonArray = new JSONArray(warnings.size());
            for (OXException warning : warnings) {
                JSONObject jsonWarning = new JSONObject();
                ResponseWriter.addException(jsonWarning, warning.setCategory(Category.CATEGORY_WARNING), locale);
                jsonArray.put((Object)jsonWarning);
            }
            json.put("warnings", (Object)jsonArray);
            if (!warnings.isEmpty() && !json.hasAndNotNull("error")) {
                ResponseWriter.addException(json, warnings.get(0).setCategory(Category.CATEGORY_WARNING), locale, includeStackTraceOnError);
            }
        }
    }

    public static void addException(JSONObject json, OXException exception) throws JSONException {
        ResponseWriter.addException(json, exception, ResponseWriter.defaultLocale());
    }

    public static void addException(JSONObject json, OXException exception, Locale locale) throws JSONException {
        ResponseWriter.addException(json, "error", exception, locale, false);
    }

    public static void addException(JSONObject json, OXException exception, Locale locale, boolean includeStackTraceOnError) throws JSONException {
        ResponseWriter.addException(json, "error", exception, locale, includeStackTraceOnError);
    }

    public static void addException(JSONObject json, String errorKey, OXException exception, Locale locale, boolean includeStackTraceOnError) throws JSONException {
        Locale parsedLocale;
        String property = exception.getProperty("com.openexchange.exception.locale");
        Locale l = null == property ? LocaleTools.getSaneLocale((Locale)locale) : (null == (parsedLocale = LocaleTools.getLocale((String)property)) ? LocaleTools.getSaneLocale((Locale)locale) : parsedLocale);
        json.put(errorKey, (Object)exception.getDisplayMessage(l));
        Object[] args = exception.getLogArgs();
        if (null == args || 0 == args.length) {
            args = exception.getDisplayArgs();
        }
        if (null == args || 0 == args.length) {
            json.put("error_params", (Object)new JSONArray(0));
        } else {
            JSONArray jArgs = new JSONArray(args.length);
            for (int i = 0; i < args.length; ++i) {
                Object obj = args[i];
                jArgs.put(obj instanceof Localizable ? obj.toString() : obj);
            }
            json.put("error_params", (Object)jArgs);
        }
        List categories = exception.getCategories();
        int size = categories.size();
        if (1 == size) {
            Category category = (Category)categories.get(0);
            json.put("categories", (Object)category.toString());
            int number = Categories.getFormerCategoryNumber((Category)category);
            if (number > 0) {
                json.put("category", number);
            }
        } else if (size <= 0) {
            json.put("categories", (Object)new JSONArray(0));
        } else {
            JSONArray jArray = new JSONArray(size);
            for (Category category : categories) {
                jArray.put((Object)category.toString());
            }
            json.put("categories", (Object)jArray);
            int number = Categories.getFormerCategoryNumber((Category)((Category)categories.get(0)));
            if (number > 0) {
                json.put("category", number);
            }
        }
        json.put("code", (Object)exception.getErrorCode());
        json.put("error_id", (Object)exception.getExceptionId());
        json.put("error_desc", (Object)exception.getSoleMessage());
        ResponseWriter.toJSON(json, exception.getProblematics());
        if (Category.CATEGORY_TRUNCATED.equals(exception.getCategory())) {
            ResponseWriter.addTruncated(json, exception.getProblematics());
        }
        if (includeStackTraceOnError || ResponseWriter.includeStackTraceOnError()) {
            StackTraceElement[] traceElements = exception.getStackTrace();
            JSONArray jsonStack = new JSONArray(traceElements.length << 1);
            jsonStack.put((Object)exception.getSoleMessage());
            Throwable cause = exception;
            StringBuilder tmp = new StringBuilder(64);
            while (null != traceElements && traceElements.length > 0) {
                for (StackTraceElement stackTraceElement : traceElements) {
                    tmp.setLength(0);
                    ResponseWriter.writeElementTo(stackTraceElement, tmp);
                    jsonStack.put((Object)tmp.toString());
                }
                if (null == (cause = cause.getCause())) {
                    traceElements = null;
                    continue;
                }
                tmp.setLength(0);
                jsonStack.put((Object)tmp.append("Caused by: ").append(cause.getClass().getName()).append(": ").append(cause.getMessage()).toString());
                traceElements = cause.getStackTrace();
            }
            json.put("error_stack", (Object)jsonStack);
        }
    }

    private static void writeElementTo(StackTraceElement element, StringBuilder sb) {
        sb.append(element.getClassName()).append('.').append(element.getMethodName());
        if (element.isNativeMethod()) {
            sb.append("(Native Method)");
        } else {
            String fileName = element.getFileName();
            if (null == fileName) {
                sb.append("(Unknown Source)");
            } else {
                sb.append('(').append(fileName);
                int lineNumber = element.getLineNumber();
                if (lineNumber >= 0) {
                    sb.append(':').append(lineNumber);
                }
                sb.append(')');
            }
        }
    }

    private static void toJSON(JSONObject json, OXException.ProblematicAttribute[] problematics) throws JSONException {
        JSONArray array = new JSONArray(problematics.length);
        for (OXException.ProblematicAttribute problematic : problematics) {
            array.put((Object)ResponseWriter.toJSON(problematic));
        }
        if (array.length() > 0) {
            json.put("problematic", (Object)array);
        }
    }

    public static JSONObject toJSON(OXException.ProblematicAttribute problematic) throws JSONException {
        if (problematic instanceof OXException.Truncated) {
            return ResponseWriter.toJSON((OXException.Truncated)problematic);
        }
        if (problematic instanceof OXException.Parsing) {
            return ResponseWriter.toJSON((OXException.Parsing)problematic);
        }
        return new JSONObject();
    }

    public static JSONObject toJSON(OXException.Truncated truncated) throws JSONException {
        JSONObject json = new JSONObject(3);
        json.put("id", truncated.getId());
        json.put("length", truncated.getLength());
        json.put("max_size", truncated.getMaxSize());
        return json;
    }

    public static JSONObject toJSON(OXException.Parsing parsing) throws JSONException {
        JSONObject json = new JSONObject(1);
        json.put("name", (Object)parsing.getAttribute());
        return json;
    }

    private static void addTruncated(JSONObject json, OXException.ProblematicAttribute[] problematics) throws JSONException {
        JSONArray array = new JSONArray(problematics.length);
        for (OXException.ProblematicAttribute problematic : problematics) {
            if (!OXException.Truncated.class.isAssignableFrom(problematic.getClass())) continue;
            array.put(((OXException.Truncated)problematic).getId());
        }
        json.put("truncated", (Object)array);
    }

    public static void write(Response response, JSONWriter writer, Locale locale) throws JSONException {
        writer.object();
        JSONObject json = new JSONObject(8);
        ResponseWriter.write(response, json, locale);
        Set entrySet = json.entrySet();
        int len = entrySet.size();
        Iterator iter = entrySet.iterator();
        for (int i = 0; i < len; ++i) {
            Map.Entry e = (Map.Entry)iter.next();
            writer.key((String)e.getKey()).value(e.getValue());
        }
        writer.endObject();
    }

    public static void write(Response response, Writer writer) throws JSONException, IOException {
        Locale locale = response.getLocale();
        ResponseWriter.write(response, writer, locale == null ? ResponseWriter.defaultLocale() : locale);
    }

    public static void write(Response response, Writer writer, Locale locale) throws JSONException, IOException {
        ResponseWriter.write(response, writer, locale, false);
    }

    public static void write(Response response, Writer writer, Locale locale, boolean asciiOnly) throws JSONException, IOException {
        JSONObject json = new JSONObject();
        ResponseWriter.write(response, json, locale);
        try {
            json.write(writer, asciiOnly);
        }
        catch (JSONException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public static void writeWarnings(List<OXException> warnings, JSONWriter writer) throws JSONException {
        ResponseWriter.writeWarnings(warnings, writer, ResponseWriter.defaultLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWarnings(List<OXException> warnings, JSONWriter writer, Locale locale) throws JSONException {
        if (null == warnings || warnings.isEmpty()) {
            return;
        }
        writer.key("warnings");
        if (1 == warnings.size()) {
            JSONObject json;
            JSONValue jv;
            OXException warning = warnings.get(0);
            writer.object();
            try {
                ResponseWriter.writeException(warning, writer, locale);
            }
            finally {
                writer.endObject();
            }
            if (writer instanceof OXJSONWriter && (jv = ((OXJSONWriter)writer).getObject()).isObject() && !(json = jv.toObject()).hasAndNotNull("error")) {
                ResponseWriter.addException(json, warning, locale);
            }
        } else {
            JSONObject json;
            JSONValue jv;
            writer.array();
            try {
                for (OXException warning : warnings) {
                    writer.object();
                    try {
                        ResponseWriter.writeException(warning, writer, locale);
                    }
                    finally {
                        writer.endObject();
                    }
                }
            }
            finally {
                writer.endArray();
            }
            if (!warnings.isEmpty() && writer instanceof OXJSONWriter && (jv = ((OXJSONWriter)writer).getObject()).isObject() && !(json = jv.toObject()).hasAndNotNull("error")) {
                ResponseWriter.addException(json, warnings.get(0), locale);
            }
        }
    }

    public static void writeException(OXException exc, JSONWriter writer) throws JSONException {
        ResponseWriter.writeException(exc, writer, ResponseWriter.defaultLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeException(OXException exc, JSONWriter writer, Locale locale) throws JSONException {
        writer.key("error").value((Object)exc.getDisplayMessage(locale));
        Object[] args = exc.getLogArgs();
        if (null == args || 0 == args.length) {
            args = exc.getDisplayArgs();
        }
        if (null == args || 0 == args.length) {
            writer.key("error_params").value((Object)new JSONArray(0));
        } else {
            JSONArray jArgs = new JSONArray(args.length);
            for (int i = 0; i < args.length; ++i) {
                Object obj = args[i];
                jArgs.put(obj instanceof Localizable ? obj.toString() : obj);
            }
            writer.key("error_params").value((Object)jArgs);
        }
        List categories = exc.getCategories();
        int size = categories.size();
        if (1 == size) {
            Category category = (Category)categories.get(0);
            writer.key("categories").value((Object)category.toString());
            int number = Categories.getFormerCategoryNumber((Category)category);
            if (number > 0) {
                writer.key("category").value((long)number);
            }
        } else {
            writer.key("categories");
            if (size <= 0) {
                writer.array().endArray();
            } else {
                writer.array();
                try {
                    for (Category category : categories) {
                        writer.value((Object)category.toString());
                    }
                }
                finally {
                    writer.endArray();
                }
                int number = Categories.getFormerCategoryNumber((Category)((Category)categories.get(0)));
                if (number > 0) {
                    writer.key("category").value((long)number);
                }
            }
        }
        writer.key("code").value((Object)exc.getErrorCode());
        writer.key("error_id").value((Object)exc.getExceptionId());
        writer.key("error_desc").value((Object)exc.getSoleMessage());
        ResponseWriter.writeProblematic(exc, writer);
        ResponseWriter.writeTruncated(exc, writer);
        if (ResponseWriter.includeArguments()) {
            ResponseWriter.writeArguments(exc, writer);
        }
        if (exc.getLogArgs() != null) {
            JSONArray array = new JSONArray();
            for (Object tmp : exc.getLogArgs()) {
                array.put(tmp);
            }
            writer.key("error_params").value((Object)array);
        }
        if (ResponseWriter.includeStackTraceOnError()) {
            writer.key("error_stack");
            writer.array();
            try {
                writer.value((Object)exc.getSoleMessage());
                StackTraceElement[] traceElements = exc.getStackTrace();
                if (null != traceElements && traceElements.length > 0) {
                    StringBuilder tmp = new StringBuilder(64);
                    for (StackTraceElement stackTraceElement : traceElements) {
                        tmp.setLength(0);
                        ResponseWriter.writeElementTo(stackTraceElement, tmp);
                        writer.value((Object)tmp.toString());
                    }
                }
            }
            finally {
                writer.endArray();
            }
        }
    }

    private static void writeProblematic(OXException exc, JSONWriter writer) throws JSONException {
        OXException.ProblematicAttribute[] problematics = exc.getProblematics();
        if (problematics.length > 0) {
            writer.key("problematic");
            writer.array();
            for (OXException.ProblematicAttribute problematic : problematics) {
                writer.value((Object)ResponseWriter.toJSON(problematic));
            }
            writer.endArray();
        }
    }

    private static void writeTruncated(OXException exc, JSONWriter writer) throws JSONException {
        OXException.ProblematicAttribute[] problematics = exc.getProblematics();
        if (problematics.length > 0) {
            JSONArray array = new JSONArray();
            for (OXException.ProblematicAttribute problematic : problematics) {
                if (!(problematic instanceof OXException.Truncated)) continue;
                array.put(((OXException.Truncated)problematic).getId());
            }
            writer.key("truncated").value((Object)array);
        }
    }

    private static void writeArguments(OXException exc, JSONWriter writer) throws JSONException {
        Map arguments = exc.getArguments();
        if (!arguments.isEmpty()) {
            try {
                JSONObject jArguments = null;
                for (Map.Entry argument : arguments.entrySet()) {
                    Object jValue;
                    Object value = argument.getValue();
                    if (!(value instanceof Jsonable) || null == (jValue = ((Jsonable)value).toJson())) continue;
                    if (null == jArguments) {
                        jArguments = new JSONObject(4);
                    }
                    jArguments.put((String)argument.getKey(), jValue);
                }
                if (null != jArguments) {
                    writer.key("arguments").value(jArguments);
                }
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause instanceof JSONException) {
                    throw (JSONException)cause;
                }
                throw new JSONException("Error while composing JSON", (Throwable)e);
            }
        }
    }

    static {
        INCL_STACKTRACE_REF = new AtomicReference();
    }
}

