/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.cache;

import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.ajax.requesthandler.cache.ResourceCacheMetadata;
import com.openexchange.ajax.requesthandler.cache.ResourceCacheMetadataStore;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.config.cascade.ComposedConfigProperty;
import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.timer.TimerService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceCache
implements ResourceCache,
EventHandler,
Reloadable {
    protected static final int MAX_FILE_TYPE_LENGTH = 255;
    protected static final int MAX_FILE_NAME_LENGTH = 767;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractResourceCache.class);
    private final AtomicLong globalQuota = new AtomicLong(-1L);
    private final AtomicLong documentQuota = new AtomicLong(-1L);
    private final ServiceLookup serviceLookup;

    protected AbstractResourceCache(ServiceLookup serviceLookup) {
        this.serviceLookup = serviceLookup;
        this.initQuotas((ConfigurationService)serviceLookup.getService(ConfigurationService.class));
    }

    @Override
    public boolean isEnabledFor(int contextId, int userId) throws OXException {
        ConfigViewFactory factory = ServerServiceRegistry.getInstance().getService(ConfigViewFactory.class);
        boolean defaultValue = true;
        if (null == factory) {
            return true;
        }
        ConfigView configView = factory.getView(userId, contextId);
        ComposedConfigProperty enabledProp = configView.property("com.openexchange.preview.cache.enabled", Boolean.TYPE);
        return enabledProp.isDefined() ? (Boolean)enabledProp.get() : true;
    }

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        if ("com/openexchange/groupware/infostore/update".equals(topic)) {
            try {
                Session session = (Session)event.getProperty("session");
                int contextId = session.getContextId();
                this.removeAlikes(event.getProperty("eTag").toString(), 0, contextId);
            }
            catch (OXException e) {
                LOG.warn("Couldn't remove cache entry.", (Throwable)e);
            }
        } else if ("com/openexchange/groupware/infostore/delete".equals(topic)) {
            try {
                Session session = (Session)event.getProperty("session");
                int contextId = session.getContextId();
                this.removeAlikes(event.getProperty("eTag").toString(), 0, contextId);
            }
            catch (OXException e) {
                LOG.warn("Couldn't remove cache entry.", (Throwable)e);
            }
        }
    }

    public void reloadConfiguration(ConfigurationService configService) {
        this.initQuotas(configService);
    }

    public Map<String, String[]> getConfigFileNames() {
        return Collections.singletonMap("preview.properties", new String[]{"com.openexchange.preview.cache.quota", "com.openexchange.preview.cache.quotaPerDocument"});
    }

    private void initQuotas(ConfigurationService configService) {
        String property = configService.getProperty("com.openexchange.preview.cache.quota", "10485760").trim();
        try {
            this.globalQuota.set(Long.parseLong(property));
        }
        catch (NumberFormatException e) {
            this.globalQuota.set(-1L);
        }
        property = configService.getProperty("com.openexchange.preview.cache.quotaPerDocument", "524288").trim();
        try {
            this.documentQuota.set(Long.parseLong(property));
        }
        catch (NumberFormatException e) {
            this.documentQuota.set(-1L);
        }
    }

    protected ResourceCacheMetadataStore getMetadataStore() {
        return ResourceCacheMetadataStore.getInstance();
    }

    protected DatabaseService getDBService() throws OXException {
        DatabaseService dbService = (DatabaseService)this.serviceLookup.getService(DatabaseService.class);
        if (dbService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
        }
        return dbService;
    }

    protected ConfigurationService getConfigurationService() throws OXException {
        ConfigurationService configService = (ConfigurationService)this.serviceLookup.getService(ConfigurationService.class);
        if (configService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{ConfigurationService.class.getName()});
        }
        return configService;
    }

    protected TimerService optTimerService() {
        return (TimerService)this.serviceLookup.getService(TimerService.class);
    }

    protected long getGlobalQuota() {
        return this.globalQuota.get();
    }

    protected long getDocumentQuota() {
        return this.documentQuota.get();
    }

    protected String prepareFileType(String fileType) {
        if (Strings.isEmpty((String)fileType)) {
            return null;
        }
        try {
            String baseType = new ContentType(fileType.trim()).getBaseType();
            return baseType.length() > 255 ? baseType.substring(0, 255) : baseType;
        }
        catch (OXException e) {
            LOG.warn("Could not parse file type: {}", (Object)fileType, (Object)e);
            return null;
        }
    }

    protected String prepareFileName(String fileName) {
        if (Strings.isEmpty((String)fileName)) {
            return null;
        }
        if (fileName.length() <= 767) {
            return fileName;
        }
        return fileName.substring(0, 767);
    }

    protected static ResourceCacheMetadata loadExistingEntry(ResourceCacheMetadataStore metadataStore, Connection con, int contextId, int userId, String id) throws OXException {
        ResourceCacheMetadata existingMetadata = null;
        try {
            existingMetadata = metadataStore.load(con, contextId, userId, id);
        }
        catch (SQLException e) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        return existingMetadata;
    }

    protected static boolean entryExists(ResourceCacheMetadataStore metadataStore, Connection con, int contextId, int userId, String id) throws OXException {
        try {
            return metadataStore.exists(con, contextId, userId, id);
        }
        catch (SQLException e) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    protected static ResourceCacheMetadata loadExistingEntryForUpdate(ResourceCacheMetadataStore metadataStore, Connection con, int contextId, int userId, String id) throws OXException {
        ResourceCacheMetadata existingMetadata = null;
        try {
            existingMetadata = metadataStore.loadForUpdate(con, contextId, userId, id);
        }
        catch (SQLException e) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        return existingMetadata;
    }
}

