/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.AJAXUtility;
import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXState;
import com.openexchange.ajax.requesthandler.ExtendedResponse;
import com.openexchange.annotation.NonNull;
import com.openexchange.annotation.Nullable;
import com.openexchange.dispatcher.Parameterizable;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.java.Strings;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.strings.StringParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class AJAXRequestData {
    @NonNull
    private final Map<String, String> params = new LinkedHashMap<String, String>();
    private Parameterizable parameterizable;
    @NonNull
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    @NonNull
    private final Map<String, Object> properties = new HashMap<String, Object>(4);
    @Nullable
    private ServerSession session;
    private boolean secure;
    @Nullable
    private Object data;
    @Nullable
    private String module;
    @Nullable
    private String action;
    private InputStreamProvider uploadStreamProvider;
    @NonNull
    private final List<UploadFile> files = new LinkedList<UploadFile>();
    @Nullable
    private String hostname;
    @Nullable
    private String remoteAddress;
    @Nullable
    private String servletRequestUri;
    @Nullable
    private String route;
    @Nullable
    private volatile UploadEvent uploadEvent;
    @Nullable
    private String format;
    @Nullable
    private AJAXState state;
    @Nullable
    private String eTag;
    @Nullable
    private String userAgent;
    private long expires = -1L;
    @Nullable
    private String pathInfo;
    @Nullable
    private HttpServletRequest httpServletRequest;
    @NonNull
    private final List<String> decoratorIds = new LinkedList<String>();
    private boolean multipart;
    @Nullable
    private String prefix;
    @Nullable
    private HttpServletResponse httpServletResponse;
    @Nullable
    private Long lastModified;
    private long maxUploadFileSize = -1L;
    private long maxUploadSize = -1L;
    private static final Pattern SPLIT = Pattern.compile(" *, *");

    public AJAXRequestData(@Nullable JSONObject json) throws OXException {
        this();
        this.data = DataParser.checkJSONObject(json, "data");
    }

    public AJAXRequestData(@Nullable Object data) {
        this();
        this.data = data;
    }

    public AJAXRequestData() {
    }

    public AJAXRequestData copyOf() {
        AJAXRequestData copy = new AJAXRequestData();
        copy.params.putAll(this.params);
        copy.headers.putAll(this.headers);
        copy.properties.putAll(this.properties);
        copy.decoratorIds.addAll(this.decoratorIds);
        copy.files.addAll(this.files);
        copy.parameterizable = this.parameterizable;
        copy.session = this.session;
        copy.secure = this.secure;
        copy.action = this.action;
        copy.data = this.data;
        copy.eTag = this.eTag;
        copy.expires = this.expires;
        copy.format = this.format;
        copy.hostname = this.hostname;
        copy.module = this.module;
        copy.pathInfo = this.pathInfo;
        copy.remoteAddress = this.remoteAddress;
        copy.route = this.route;
        copy.servletRequestUri = this.servletRequestUri;
        copy.userAgent = this.userAgent;
        copy.state = null;
        copy.uploadEvent = null;
        copy.uploadStreamProvider = null;
        return copy;
    }

    public void setMaxUploadFileSize(long maxUploadFileSize) {
        this.maxUploadFileSize = maxUploadFileSize;
    }

    public void setMaxUploadSize(long maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
    }

    public void setUserAgent(@Nullable String userAgent) {
        this.userAgent = userAgent;
    }

    @Nullable
    public String getUserAgent() {
        return this.userAgent;
    }

    @NonNull
    public AJAXRequestData setHttpServletResponse(@Nullable HttpServletResponse resp) {
        this.httpServletResponse = resp;
        return this;
    }

    public void examineServletRequest(@Nullable HttpServletRequest servletRequest) {
        if (null == servletRequest) {
            return;
        }
        this.parameterizable = servletRequest instanceof Parameterizable ? (Parameterizable)servletRequest : null;
    }

    @NonNull
    public AJAXRequestData addDecoratorId(@NonNull String decoratorId) {
        this.decoratorIds.add(decoratorId);
        return this;
    }

    @NonNull
    public AJAXRequestData addDecoratorIds(@NonNull Collection<String> decoratorIds) {
        List<String> thisDecoratorIds = this.decoratorIds;
        for (String decoratorId : decoratorIds) {
            thisDecoratorIds.add(decoratorId);
        }
        return this;
    }

    public boolean isHttpServletResponseAvailable() {
        return null != this.httpServletResponse;
    }

    public HttpServletResponse optHttpServletResponse() {
        return this.httpServletResponse;
    }

    @Nullable
    public OutputStream optOutputStream() throws IOException {
        HttpServletResponse httpResponse = this.httpServletResponse;
        return null == httpResponse ? null : httpResponse.getOutputStream();
    }

    @Nullable
    public PrintWriter optWriter() throws IOException {
        HttpServletResponse httpResponse = this.httpServletResponse;
        return null == httpResponse ? null : httpResponse.getWriter();
    }

    public boolean setResponseCharacterEncoding(@NonNull String charset) {
        HttpServletResponse resp = this.httpServletResponse;
        if (null != resp) {
            resp.setCharacterEncoding(charset);
            return true;
        }
        return false;
    }

    public boolean setResponseHeader(@NonNull String name, @Nullable String value) {
        HttpServletResponse resp = this.httpServletResponse;
        if (null != resp) {
            resp.setHeader(name, value);
            return true;
        }
        return false;
    }

    public boolean removeCachingHeader() {
        HttpServletResponse resp = this.httpServletResponse;
        if (null != resp) {
            Tools.removeCachingHeader(resp);
            return true;
        }
        return false;
    }

    public boolean setResponseETag(@NonNull String eTag, long expiry) {
        HttpServletResponse resp = this.httpServletResponse;
        if (null != resp) {
            Tools.setETag(eTag, expiry > 0L ? expiry : -1L, resp);
            return true;
        }
        return false;
    }

    @NonNull
    public List<String> getDecoratorIds() {
        return this.decoratorIds;
    }

    @Nullable
    public ServerSession getSession() {
        return this.session;
    }

    public void setSession(@Nullable ServerSession session) {
        this.session = session;
    }

    @Nullable
    public HttpServletRequest optHttpServletRequest() {
        return this.httpServletRequest;
    }

    public void setHttpServletRequest(@Nullable HttpServletRequest httpServletRequest) {
        this.examineServletRequest(httpServletRequest);
        this.httpServletRequest = httpServletRequest;
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long expires) {
        this.expires = expires;
    }

    public long getLastModified() {
        String ifModifiedSince;
        Long lastModified = this.lastModified;
        if (null == lastModified && null != (ifModifiedSince = this.getHeader("If-Modified-Since"))) {
            try {
                long time = Tools.parseHeaderDate(ifModifiedSince).getTime();
                this.lastModified = lastModified = Long.valueOf(time);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null == lastModified ? -1L : lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified < 0L ? null : Long.valueOf(lastModified);
    }

    @Nullable
    public String getETag() {
        String eTag = this.eTag;
        if (null == eTag && null != (eTag = this.getHeader("If-None-Match"))) {
            this.eTag = eTag;
        }
        return eTag;
    }

    public void setETag(@Nullable String eTag) {
        this.eTag = eTag;
    }

    @Nullable
    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(@Nullable String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setServletRequestURI(@Nullable String servletRequestUri) {
        this.servletRequestUri = servletRequestUri;
    }

    @Nullable
    public String getSerlvetRequestURI() {
        return this.servletRequestUri;
    }

    public void putParameter(@Nullable String name, @Nullable String value) {
        if (null == name) {
            throw new NullPointerException("name is null");
        }
        if (null == value) {
            this.params.remove(name);
        } else {
            this.params.put(name, value);
        }
        Parameterizable parameterizable = this.parameterizable;
        if (null != parameterizable) {
            parameterizable.putParameter(name, value);
        }
    }

    public boolean containsParameter(@Nullable String name) {
        if (null == name) {
            throw new NullPointerException("name is null");
        }
        return this.params.containsKey(name);
    }

    public int getIntParameter(@Nullable String name) throws OXException {
        if (null == name) {
            throw new NullPointerException("name is null");
        }
        String value = this.params.get(name);
        if (null == value) {
            return -1;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(name, value);
        }
    }

    @NonNull
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(this.params);
    }

    public String[] getParameterValues(@Nullable String name) {
        if (null == name) {
            throw new NullPointerException("name is null");
        }
        String value = this.params.get(name);
        if (null == value) {
            return null;
        }
        return SPLIT.split(value, 0);
    }

    @Nullable
    public String getParameter(@Nullable String name) {
        if (null == name) {
            throw new NullPointerException("name is null");
        }
        return this.params.get(name);
    }

    @NonNull
    public String checkParameter(@Nullable String name) throws OXException {
        if (null == name) {
            throw new NullPointerException("name is null");
        }
        String value = this.params.get(name);
        if (null == value) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return value;
    }

    @NonNull
    public String requireParameter(@Nullable String name) throws OXException {
        return this.checkParameter(name);
    }

    @NonNull
    public String nonEmptyParameter(@Nullable String name) throws OXException {
        if (null == name) {
            throw new NullPointerException("name is null");
        }
        String value = this.params.get(name);
        if (Strings.isEmpty((String)value)) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return value;
    }

    @NonNull
    public int[] checkIntArray(@NonNull String name) throws OXException {
        String parameter = this.getParameter(name);
        if (null == parameter) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        if (name.equals("columns")) {
            if (parameter.equals("all")) {
                return AbstractMailAction.FIELDS_ALL_ALIAS;
            }
            if (parameter.equals("list")) {
                return AbstractMailAction.FIELDS_LIST_ALIAS;
            }
        }
        String[] sa = SPLIT.split(parameter, 0);
        int[] ret = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            try {
                ret[i] = Integer.parseInt(sa[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(name, parameter);
            }
        }
        return ret;
    }

    @NonNull
    public String[] checkParameterArray(@Nullable String name) throws OXException {
        String parameter = this.getParameter(name);
        if (null == parameter) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return SPLIT.split(parameter, 0);
    }

    @Nullable
    public <T> T getParameter(@Nullable String name, @NonNull Class<T> coerceTo) throws OXException {
        return this.getParameter(name, coerceTo, false);
    }

    @Nullable
    public <T> T getParameter(@Nullable String name, @NonNull Class<T> coerceTo, boolean optional) throws OXException {
        String value = this.getParameter(name);
        if (null == value && !optional) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(name, "null");
        }
        try {
            StringParser parser = ServerServiceRegistry.getInstance().getService(StringParser.class);
            if (null == parser) {
                if (Integer.TYPE.equals(coerceTo) || Integer.class.equals(coerceTo)) {
                    return (T)Integer.valueOf(value);
                }
                if (Long.TYPE.equals(coerceTo) || Long.class.equals(coerceTo)) {
                    return (T)Long.valueOf(value);
                }
                if (Boolean.TYPE.equals(coerceTo) || Boolean.class.equals(coerceTo)) {
                    return (T)Boolean.valueOf(value);
                }
                throw ServiceExceptionCode.absentService(StringParser.class);
            }
            return (T)parser.parse(value, coerceTo);
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(e, name, value);
        }
    }

    @NonNull
    public Iterator<String> getParameterNames() {
        return this.params.keySet().iterator();
    }

    @NonNull
    public Iterator<Map.Entry<String, String>> getNonMatchingParameters(Collection<String> nonMatchingParameterNames) {
        HashMap<String, String> clone = new HashMap<String, String>(this.params);
        clone.keySet().removeAll(nonMatchingParameterNames);
        return clone.entrySet().iterator();
    }

    @NonNull
    public Iterator<Map.Entry<String, String>> getMatchingParameters(Collection<String> matchingParameterNames) {
        HashMap<String, String> clone = new HashMap<String, String>(this.params);
        clone.keySet().retainAll(matchingParameterNames);
        return clone.entrySet().iterator();
    }

    @NonNull
    public Object requireData() throws OXException {
        Object data = this.data;
        if (null == data) {
            throw AjaxExceptionCodes.MISSING_REQUEST_BODY.create();
        }
        return data;
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public void setData(@Nullable Object data) {
        this.data = data;
    }

    @Nullable
    public String getFormat() {
        return this.format;
    }

    public void setFormat(@Nullable String format) {
        this.format = format;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isExtendedResponse(@NonNull AJAXRequestData request) {
        return AJAXRequestDataTools.parseBoolParameter(ExtendedResponse.PARAM_EXTENDED_RESPONSE, request);
    }

    public boolean isMultipartContent() {
        return this.multipart;
    }

    public void setMultipart(boolean multipart) {
        this.multipart = multipart;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Nullable
    public InputStream getUploadStream() throws IOException {
        InputStreamProvider usp = this.uploadStreamProvider;
        return null == usp ? null : usp.getInputStream();
    }

    public void setUploadStreamProvider(@Nullable InputStreamProvider uploadStreamProvider) {
        this.uploadStreamProvider = uploadStreamProvider;
    }

    @NonNull
    public List<String> getMissingParameters(String ... mandatoryParameters) {
        ArrayList<String> missing = new ArrayList<String>(mandatoryParameters.length);
        for (String paramName : mandatoryParameters) {
            if (this.params.containsKey(paramName)) continue;
            missing.add(paramName);
        }
        return missing;
    }

    public void require(String ... mandatoryParameters) throws OXException {
        List<String> missingParameters = this.getMissingParameters(mandatoryParameters);
        if (!missingParameters.isEmpty()) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(missingParameters.toString());
        }
    }

    public boolean isSet(String paramName) {
        return this.params.containsKey(paramName);
    }

    public void setHeader(@Nullable String header, @Nullable String value) {
        if (!Strings.isEmpty((String)header)) {
            if (null == value) {
                this.headers.remove(header);
            } else {
                this.headers.put(header, value);
            }
        }
    }

    public String getHeader(@Nullable String header) {
        return this.headers.get(header);
    }

    public <T> T getHeader(String header, Class<T> coerceTo) {
        return (T)ServerServiceRegistry.getInstance().getService(StringParser.class).parse(this.getHeader(header), coerceTo);
    }

    @NonNull
    public Map<String, String> getHeaders() {
        return new HashMap<String, String>(this.headers);
    }

    public boolean hasUploads() throws OXException {
        this.processUpload(this.maxUploadFileSize, this.maxUploadSize);
        return !this.files.isEmpty();
    }

    public boolean hasUploads(long maxUploadFileSize, long maxUploadSize) throws OXException {
        this.maxUploadFileSize = maxUploadFileSize > 0L ? maxUploadFileSize : -1L;
        this.maxUploadSize = maxUploadSize > 0L ? maxUploadSize : -1L;
        this.processUpload(maxUploadFileSize, maxUploadSize);
        return !this.files.isEmpty();
    }

    public List<UploadFile> getFiles() throws OXException {
        this.processUpload(this.maxUploadFileSize, this.maxUploadSize);
        return Collections.unmodifiableList(this.files);
    }

    public List<UploadFile> getFiles(long maxUploadFileSize, long maxUploadSize) throws OXException {
        this.maxUploadFileSize = maxUploadFileSize > 0L ? maxUploadFileSize : -1L;
        this.maxUploadSize = maxUploadSize > 0L ? maxUploadSize : -1L;
        this.processUpload(maxUploadFileSize, maxUploadSize);
        return Collections.unmodifiableList(this.files);
    }

    @Nullable
    public UploadFile getFile(String name) throws OXException {
        this.processUpload(this.maxUploadFileSize, this.maxUploadSize);
        for (UploadFile file : this.files) {
            if (!file.getFieldName().equals(name)) continue;
            return file;
        }
        return null;
    }

    @Nullable
    public UploadFile getFile(String name, long maxUploadFileSize, long maxUploadSize) throws OXException {
        this.maxUploadFileSize = maxUploadFileSize > 0L ? maxUploadFileSize : -1L;
        this.maxUploadSize = maxUploadSize > 0L ? maxUploadSize : -1L;
        this.processUpload(maxUploadFileSize, maxUploadSize);
        for (UploadFile file : this.files) {
            if (!file.getFieldName().equals(name)) continue;
            return file;
        }
        return null;
    }

    public UploadEvent getUploadEvent() throws OXException {
        this.processUpload(this.maxUploadFileSize, this.maxUploadSize);
        return this.uploadEvent;
    }

    public UploadEvent getUploadEvent(long maxUploadFileSize, long maxUploadSize) throws OXException {
        this.maxUploadFileSize = maxUploadFileSize > 0L ? maxUploadFileSize : -1L;
        this.maxUploadSize = maxUploadSize > 0L ? maxUploadSize : -1L;
        this.processUpload(maxUploadFileSize, maxUploadSize);
        return this.uploadEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpload(long maxFileSize, long maxOverallSize) throws OXException {
        List<UploadFile> thisFiles;
        if (!this.multipart || null == this.httpServletRequest) {
            return;
        }
        List<UploadFile> list = thisFiles = this.files;
        synchronized (list) {
            UploadEvent uploadEvent = this.uploadEvent;
            if (null == uploadEvent) {
                this.uploadEvent = uploadEvent = AJAXServlet.processUploadStatic(this.httpServletRequest, maxFileSize, maxOverallSize);
                Iterator<UploadFile> iterator = uploadEvent.getUploadFilesIterator();
                while (iterator.hasNext()) {
                    thisFiles.add(iterator.next());
                }
                Iterator<String> names = uploadEvent.getFormFieldNames();
                while (names.hasNext()) {
                    String name = names.next();
                    this.putParameter(name, uploadEvent.getFormField(name));
                }
            }
        }
    }

    public StringBuilder constructURL(String path, boolean withRoute) {
        return this.constructURL(null, path, withRoute, null);
    }

    public StringBuilder constructURL(String protocol, String path, boolean withRoute, String query) {
        StringBuilder url = new StringBuilder(64 + (null == query ? 0 : query.length()));
        String prot = protocol;
        if (prot == null) {
            prot = this.isSecure() ? "https://" : "http://";
        }
        url.append(prot);
        if (!prot.endsWith("://")) {
            url.append("://");
        }
        url.append(this.hostname);
        if (path != null) {
            if (!path.startsWith("/")) {
                url.append('/');
            }
            url.append(path);
        }
        if (withRoute) {
            url.append(";jsessionid=").append(this.route);
        }
        if (query != null) {
            if (!query.startsWith("?")) {
                url.append('?');
            }
            url.append(query);
        }
        return url;
    }

    public StringBuilder constructURLWithParameters(String protocol, String path, boolean withRoute, Map<String, String> params) {
        StringBuilder url = new StringBuilder(128);
        String prot = protocol;
        if (prot == null) {
            prot = this.isSecure() ? "https://" : "http://";
        }
        url.append(prot);
        if (!prot.endsWith("://")) {
            url.append("://");
        }
        url.append(this.hostname);
        if (path != null) {
            if (!path.startsWith("/")) {
                url.append('/');
            }
            url.append(path);
        }
        if (withRoute) {
            url.append(";jsessionid=").append(this.route);
        }
        if (params != null) {
            boolean first = true;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                if (Strings.isEmpty((String)key)) continue;
                if (first) {
                    url.append('?');
                    first = false;
                } else {
                    url.append('&');
                }
                url.append(AJAXUtility.encodeUrl(key, true));
                String value = entry.getValue();
                if (Strings.isEmpty((String)value)) continue;
                url.append('=').append(AJAXUtility.encodeUrl(value, true));
            }
        }
        return url;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getRoute() {
        return this.route;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUploads() {
        List<UploadFile> list = this.files;
        synchronized (list) {
            UploadEvent ue = this.uploadEvent;
            if (null != ue) {
                ue.cleanUp();
            }
        }
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setData(Object object, String format) {
        this.setData(object);
        this.setFormat(format);
    }

    public void setState(AJAXState state) {
        this.state = state;
    }

    public AJAXState getState() {
        AJAXState state = this.state;
        if (state == null) {
            state = this.state = new AJAXState();
        }
        return state;
    }

    public boolean containsProperty(String name) {
        if (null == name) {
            return false;
        }
        return this.properties.containsKey(name);
    }

    public <V> V getProperty(String name) {
        if (null == name) {
            return null;
        }
        try {
            return (V)this.properties.get(name);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public void setProperty(String name, Object value) {
        if (null == value) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static interface InputStreamProvider {
        public InputStream getInputStream() throws IOException;
    }
}

