/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.SessionUtility;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestHandler;
import com.openexchange.ajax.login.LoginRequestImpl;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.authentication.Authenticated;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Strings;
import com.openexchange.log.LogProperties;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.LoginMethodClosure;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.login.internal.LoginResultImpl;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.session.reservation.Enhancer;
import com.openexchange.session.reservation.Reservation;
import com.openexchange.session.reservation.SessionReservationService;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RedeemReservationLogin
implements LoginRequestHandler {
    private final List<Enhancer> enhancers = Collections.synchronizedList(new LinkedList());

    @Override
    public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.doSsoLogin(req, resp);
        }
        catch (OXException e) {
            String errorPage = this.getConf().getErrorPageTemplate().replace("ERROR_MESSAGE", e.getMessage());
            resp.setContentType("text/html; charset=UTF-8");
            resp.getWriter().write(errorPage);
        }
    }

    public void addEnhancer(Enhancer enhancer) {
        this.enhancers.add(enhancer);
    }

    public void removeEnhancer(Enhancer enhancer) {
        this.enhancers.remove(enhancer);
    }

    private void doSsoLogin(HttpServletRequest req, HttpServletResponse resp) throws OXException, IOException {
        Reservation reservation;
        LoginConfiguration conf = this.getConf();
        String token = LoginTools.parseToken(req);
        if (null == token) {
            resp.sendError(400);
            return;
        }
        SessionReservationService service = ServerServiceRegistry.getInstance().getService(SessionReservationService.class);
        Reservation reservation2 = reservation = null == service ? null : service.removeReservation(token);
        if (null == reservation) {
            resp.sendError(400);
            return;
        }
        Context context = ContextStorage.getInstance().getContext(reservation.getContextId());
        if (!context.isEnabled()) {
            resp.sendError(403);
            return;
        }
        User user = UserStorage.getInstance().getUser(reservation.getUserId(), context);
        if (!user.isMailEnabled()) {
            resp.sendError(403);
            return;
        }
        LoginResult result = this.login(req, context, user, reservation.getState(), conf);
        Session session = result.getSession();
        LogProperties.putSessionProperties((Session)session);
        LoginServlet.addHeadersAndCookies(result, resp);
        SessionUtility.rememberSession(req, new ServerSessionAdapter(session));
        LoginServlet.writeSecretCookie(req, resp, session, session.getHash(), req.isSecure(), req.getServerName(), conf);
        String uiWebPath = req.getParameter("uiWebPath");
        if (Strings.isEmpty((String)uiWebPath)) {
            uiWebPath = conf.getUiWebPath();
        }
        resp.sendRedirect(RedeemReservationLogin.generateRedirectURL(session, user.getPreferredLanguage(), uiWebPath, conf.getHttpAuthAutoLogin()));
    }

    private LoginResult login(HttpServletRequest httpRequest, final Context context, final User user, final Map<String, String> optState, LoginConfiguration loginConfiguration) throws OXException {
        HashMap<String, Object> props = optState == null ? new HashMap<String, Object>(4) : new HashMap<String, String>(optState);
        String login = user.getLoginInfo() + '@' + context.getLoginInfo()[0];
        String defaultClient = loginConfiguration.getDefaultClient();
        LoginRequestImpl loginRequest = LoginTools.parseLogin(httpRequest, login, null, false, defaultClient, loginConfiguration.isCookieForceHTTPS(), false);
        return LoginPerformer.getInstance().doLogin(loginRequest, props, new LoginMethodClosure(){

            @Override
            public Authenticated doAuthentication(LoginResultImpl retval) throws OXException {
                AuthenticatedImpl authenticated = new AuthenticatedImpl(context.getLoginInfo()[0], user.getLoginInfo());
                for (Enhancer enhancer : RedeemReservationLogin.this.enhancers) {
                    authenticated = enhancer.enhance((Authenticated)authenticated, optState);
                }
                return authenticated;
            }
        });
    }

    private static String generateRedirectURL(Session session, String language, String uiWebPath, String shouldStore) {
        String retval = uiWebPath;
        retval = retval.replaceAll("[\n\r]", "");
        retval = LoginTools.addFragmentParameter(retval, "session", session.getSessionID());
        retval = LoginTools.addFragmentParameter(retval, "user", session.getLogin());
        retval = LoginTools.addFragmentParameter(retval, "user_id", Integer.toString(session.getUserId()));
        retval = LoginTools.addFragmentParameter(retval, "language", language);
        if (shouldStore != null) {
            retval = LoginTools.addFragmentParameter(retval, "store", shouldStore);
        }
        return retval;
    }

    private LoginConfiguration getConf() {
        LoginConfiguration conf = LoginServlet.getLoginConfiguration();
        if (conf == null) {
            throw new IllegalStateException("Login action 'redeemReservation' was called but LoginServlet was not fully initialized!");
        }
        return conf;
    }

    private static final class AuthenticatedImpl
    implements Authenticated {
        private final String contextInfo;
        private final String userInfo;

        AuthenticatedImpl(String contextInfo, String userInfo) {
            this.contextInfo = contextInfo;
            this.userInfo = userInfo;
        }

        public String getContextInfo() {
            return this.contextInfo;
        }

        public String getUserInfo() {
            return this.userInfo;
        }
    }
}

