/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.container;

import com.openexchange.ajax.container.ByteArrayRandomAccess;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.util.LinkedList;
import java.util.List;

public final class StringFileHolder
implements IFileHolder {
    private final byte[] bytes;
    private String name;
    private String contentType;
    private String disposition;
    private String delivery;
    private final List<Runnable> tasks;

    public StringFileHolder(String string) {
        this(string, "UTF-8");
    }

    public StringFileHolder(String string, String encoding) {
        try {
            this.bytes = string.getBytes(Charsets.forName((String)encoding));
            this.contentType = "application/octet-stream";
            this.tasks = new LinkedList<Runnable>();
        }
        catch (UnsupportedCharsetException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Runnable> getPostProcessingTasks() {
        return this.tasks;
    }

    @Override
    public void addPostProcessingTask(Runnable task) {
        if (null != task) {
            this.tasks.add(task);
        }
    }

    @Override
    public boolean repetitive() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public InputStream getStream() {
        return new UnsynchronizedByteArrayInputStream(this.bytes);
    }

    @Override
    public IFileHolder.RandomAccess getRandomAccess() throws OXException {
        return new ByteArrayRandomAccess(this.bytes);
    }

    @Override
    public long getLength() {
        return this.bytes.length;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDisposition() {
        return this.disposition;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

    @Override
    public String getDelivery() {
        return this.delivery;
    }
}

