/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.responseRenderers.FileResponseRenderer;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.attachment.AttachmentToken;
import com.openexchange.mail.attachment.AttachmentTokenService;
import com.openexchange.mail.json.MailActionFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MailAttachment
extends AJAXServlet {
    private static final long serialVersionUID = -3109402774466180271L;
    private static final String PARAMETER_MAILATTCHMENT = "attachment";
    private final FileResponseRenderer renderer = new FileResponseRenderer();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Tools.disableCaching(resp);
        try {
            String id = req.getParameter("id");
            if (null == id) {
                Tools.sendErrorPage(resp, 400, "Missing mandatory parameter");
                return;
            }
            boolean hasRangeHeader = Tools.hasRangeHeader(req);
            AttachmentTokenService service = ServerServiceRegistry.getInstance().getService(AttachmentTokenService.class, true);
            AttachmentToken token = service.getToken(id, hasRangeHeader);
            if (null == token) {
                Tools.sendErrorPage(resp, 404, MailExceptionCode.ATTACHMENT_EXPIRED.create().getDisplayMessage(Locale.US));
                return;
            }
            if (token.isCheckIp() && null != token.getClientIp() && !req.getRemoteAddr().equals(token.getClientIp())) {
                service.removeToken(id);
                Tools.sendErrorPage(resp, 404, MailExceptionCode.ATTACHMENT_EXPIRED.create().getDisplayMessage(Locale.US));
                return;
            }
            MailActionFactory actionFactory = MailActionFactory.getActionFactory();
            if (null == actionFactory) {
                Tools.sendErrorPage(resp, 500, "Not orderly initialized");
                return;
            }
            AJAXActionService getAttachmentAction = actionFactory.createActionService(PARAMETER_MAILATTCHMENT);
            if (null == getAttachmentAction) {
                Tools.sendErrorPage(resp, 500, "Not orderly initialized");
                return;
            }
            try {
                SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
                Session session = sessiondService.getSession(token.getSessionId());
                ServerSession serverSession = ServerSessionAdapter.valueOf(session);
                AJAXRequestData request = AJAXRequestDataTools.getInstance().parseRequest(req, false, false, serverSession, Dispatcher.PREFIX.get(), resp);
                request.setSession(serverSession);
                request.putParameter("folder", token.getFolderPath());
                request.putParameter("id", token.getMailId());
                request.putParameter(PARAMETER_MAILATTCHMENT, token.getAttachmentId());
                AJAXRequestResult result = getAttachmentAction.perform(request, serverSession);
                this.renderer.write(request, result, req, resp);
            }
            catch (OXException e) {
                Tools.sendErrorPage(resp, 404, e.getDisplayMessage(Locale.US));
                return;
            }
        }
        catch (OXException e) {
            Tools.sendErrorPage(resp, 500, e.getDisplayMessage(Locale.US));
            return;
        }
    }
}

