/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import com.openexchange.exception.OXException;
import com.openexchange.tools.file.internal.AbstractHashingFileStorageTest;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

public class HashingFileStorageMultithreadingTest
extends AbstractHashingFileStorageTest {
    private final int NUM_FILES = 10000;
    private final int NUM_THREADS = 10;

    public void testManyThreads() throws InterruptedException, OXException, IOException {
        ArrayList<FileSaverThread> fsThreads = new ArrayList<FileSaverThread>(10);
        for (int i = 0; i < 10; ++i) {
            FileSaverThread thread = new FileSaverThread("Thread " + i);
            thread.start();
            fsThreads.add(thread);
        }
        for (FileSaverThread fileSaverThread : fsThreads) {
            fileSaverThread.join();
            fileSaverThread.checkConsistency();
        }
    }

    private class FileSaverThread
    extends Thread {
        private final String prefix;
        private final Map<String, String> dataMap = new HashMap<String, String>();

        public FileSaverThread(String prefix) {
            this.prefix = prefix;
        }

        public void checkConsistency() throws OXException, IOException {
            for (Map.Entry<String, String> entry : this.dataMap.entrySet()) {
                String fileId = entry.getKey();
                String data = entry.getValue();
                InputStream file = HashingFileStorageMultithreadingTest.this.fs.getFile(fileId);
                InputStream expected = HashingFileStorageMultithreadingTest.this.IS(data);
                int d = 0;
                while ((d = file.read()) != -1) {
                    TestCase.assertEquals((int)d, (int)expected.read());
                }
                TestCase.assertEquals((int)-1, (int)expected.read());
            }
        }

        @Override
        public void run() {
            for (int i = 0; i < 10000; ++i) {
                String data = this.prefix + " " + i;
                try {
                    String file = HashingFileStorageMultithreadingTest.this.fs.saveNewFile(HashingFileStorageMultithreadingTest.this.IS(data));
                    this.dataMap.put(file, data);
                    continue;
                }
                catch (OXException e) {
                    TestCase.fail((String)e.getMessage());
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    TestCase.fail((String)e.getMessage());
                }
            }
        }

        public Map<String, String> getDataMap() {
            return this.dataMap;
        }
    }
}

