/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import com.openexchange.exception.OXException;
import com.openexchange.sim.SimBuilder;
import com.openexchange.tools.file.external.FileStorage;
import com.openexchange.tools.file.internal.CompositingFileStorage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import junit.framework.TestCase;

public class CompositingFileStorageTest
extends TestCase {
    public void testLookupWithoutPrefix() throws Exception {
        CompositingFileStorage cStore = new CompositingFileStorage();
        SimBuilder builder = new SimBuilder();
        builder.expectCall("getFile", new Object[]{"ab/cd/ef/12345"});
        cStore.addStore("hash", (FileStorage)new SimBuilder().getSim(FileStorage.class, new Class[0]));
        cStore.addStore((FileStorage)builder.getSim(FileStorage.class, new Class[0]));
        cStore.getFile("ab/cd/ef/12345");
        builder.assertAllWereCalled();
    }

    public void testLookupWithPrefix() throws Exception {
        CompositingFileStorage cStore = new CompositingFileStorage();
        SimBuilder builder = new SimBuilder();
        builder.expectCall("getFile", new Object[]{"ab/cd/ef/12345"});
        cStore.addStore((FileStorage)new SimBuilder().getSim(FileStorage.class, new Class[0]));
        cStore.addStore("hash", (FileStorage)builder.getSim(FileStorage.class, new Class[0]));
        cStore.getFile("hash/ab/cd/ef/12345");
        builder.assertAllWereCalled();
    }

    public void testSaveWithDefaultPrefix() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{1});
        CompositingFileStorage cStore = new CompositingFileStorage();
        SimBuilder builder = new SimBuilder();
        builder.expectCall("saveNewFile", new Object[]{is}).andReturn((Object)"ab/cd/ef/12345");
        cStore.addStore((FileStorage)new SimBuilder().getSim(FileStorage.class, new Class[0]));
        cStore.addStore("hash", (FileStorage)builder.getSim(FileStorage.class, new Class[0]));
        cStore.setSavePrefix("hash");
        String fileId = cStore.saveNewFile((InputStream)is);
        CompositingFileStorageTest.assertEquals((String)"hash/ab/cd/ef/12345", (String)fileId);
        builder.assertAllWereCalled();
    }

    public void testDeleteWithoutPrefix() throws Exception {
        CompositingFileStorage cStore = new CompositingFileStorage();
        SimBuilder builder = new SimBuilder();
        builder.expectCall("deleteFile", new Object[]{"ab/cd/ef/12345"}).andReturn((Object)true);
        cStore.addStore("hash", (FileStorage)new SimBuilder().getSim(FileStorage.class, new Class[0]));
        cStore.addStore((FileStorage)builder.getSim(FileStorage.class, new Class[0]));
        cStore.deleteFile("ab/cd/ef/12345");
        builder.assertAllWereCalled();
    }

    public void testDeleteWithPrefix() throws OXException {
        CompositingFileStorage cStore = new CompositingFileStorage();
        SimBuilder builder = new SimBuilder();
        builder.expectCall("deleteFile", new Object[]{"ab/cd/ef/12345"}).andReturn((Object)true);
        cStore.addStore((FileStorage)new SimBuilder().getSim(FileStorage.class, new Class[0]));
        cStore.addStore("hash", (FileStorage)builder.getSim(FileStorage.class, new Class[0]));
        cStore.deleteFile("hash/ab/cd/ef/12345");
        builder.assertAllWereCalled();
    }

    public void testBulkDeleteWithAndWithoutPrefix() throws OXException {
        CompositingFileStorage cStore = new CompositingFileStorage();
        SimFileStorage prefixedStorage = new SimFileStorage(){

            @Override
            public Set<String> deleteFiles(String[] arg0) throws OXException {
                TestCase.assertEquals((String)"ab/cd/ef/12345", (String)arg0[0]);
                TestCase.assertEquals((String)"ab/cd/ef/54321", (String)arg0[1]);
                this.remember(true);
                return new HashSet<String>(Arrays.asList("ab/cd/ef/12345"));
            }
        };
        SimFileStorage standardStorage = new SimFileStorage(){

            @Override
            public Set<String> deleteFiles(String[] arg0) throws OXException {
                TestCase.assertEquals((String)"ab/cd/ef/12345", (String)arg0[0]);
                TestCase.assertEquals((String)"ab/cd/ef/54321", (String)arg0[1]);
                this.remember(true);
                return new HashSet<String>(Arrays.asList("ab/cd/ef/54321"));
            }
        };
        cStore.addStore("hash", (FileStorage)prefixedStorage);
        cStore.addStore((FileStorage)standardStorage);
        Set notDeleted = cStore.deleteFiles(new String[]{"ab/cd/ef/12345", "hash/ab/cd/ef/12345", "ab/cd/ef/54321", "hash/ab/cd/ef/54321"});
        CompositingFileStorageTest.assertEquals((int)notDeleted.size(), (int)2);
        CompositingFileStorageTest.assertTrue((boolean)notDeleted.contains("hash/ab/cd/ef/12345"));
        CompositingFileStorageTest.assertTrue((boolean)notDeleted.contains("ab/cd/ef/54321"));
        CompositingFileStorageTest.assertEquals((Object)Boolean.TRUE, (Object)prefixedStorage.getMemory().get(0));
        CompositingFileStorageTest.assertEquals((Object)Boolean.TRUE, (Object)standardStorage.getMemory().get(0));
    }

    public void testGetFileSizeWithoutPrefix() throws OXException {
        CompositingFileStorage cStore = new CompositingFileStorage();
        SimBuilder builder = new SimBuilder();
        builder.expectCall("getFileSize", new Object[]{"ab/cd/ef/12345"}).andReturn((Object)12L);
        cStore.addStore("hash", (FileStorage)new SimBuilder().getSim(FileStorage.class, new Class[0]));
        cStore.addStore((FileStorage)builder.getSim(FileStorage.class, new Class[0]));
        long fileSize = cStore.getFileSize("ab/cd/ef/12345");
        CompositingFileStorageTest.assertEquals((long)12L, (long)fileSize);
        builder.assertAllWereCalled();
    }

    public void testGetFileSizeWithPrefix() throws OXException {
        CompositingFileStorage cStore = new CompositingFileStorage();
        SimBuilder builder = new SimBuilder();
        builder.expectCall("getFileSize", new Object[]{"ab/cd/ef/12345"}).andReturn((Object)12L);
        cStore.addStore((FileStorage)new SimBuilder().getSim(FileStorage.class, new Class[0]));
        cStore.addStore("hash", (FileStorage)builder.getSim(FileStorage.class, new Class[0]));
        long fileSize = cStore.getFileSize("hash/ab/cd/ef/12345");
        CompositingFileStorageTest.assertEquals((long)12L, (long)fileSize);
        builder.assertAllWereCalled();
    }

    public void testGetMimeTypeOnStandardFS() throws OXException {
        CompositingFileStorage cStore = new CompositingFileStorage();
        SimBuilder builder = new SimBuilder();
        builder.expectCall("getMimeType", new Object[]{"TestFile.odt"}).andReturn((Object)"text/odt");
        cStore.addStore((FileStorage)builder.getSim(FileStorage.class, new Class[0]));
        String mimeType = cStore.getMimeType("TestFile.odt");
        CompositingFileStorageTest.assertEquals((String)"text/odt", (String)mimeType);
        builder.assertAllWereCalled();
    }

    public void testCompositeFileList() throws OXException {
        CompositingFileStorage cStore = new CompositingFileStorage();
        SimBuilder prefixedBuilder = new SimBuilder();
        prefixedBuilder.expectCall("getFileList", new Object[0]).andReturn(new TreeSet<String>(Arrays.asList("ab/cd/ef/12345")));
        SimBuilder standardBuilder = new SimBuilder();
        standardBuilder.expectCall("getFileList", new Object[0]).andReturn(new TreeSet<String>(Arrays.asList("ab/cd/ef/54321")));
        cStore.addStore("hash", (FileStorage)prefixedBuilder.getSim(FileStorage.class, new Class[0]));
        cStore.addStore((FileStorage)standardBuilder.getSim(FileStorage.class, new Class[0]));
        SortedSet fileList = cStore.getFileList();
        CompositingFileStorageTest.assertEquals((int)2, (int)fileList.size());
        CompositingFileStorageTest.assertTrue((boolean)fileList.contains("hash/ab/cd/ef/12345"));
        CompositingFileStorageTest.assertTrue((boolean)fileList.contains("ab/cd/ef/54321"));
        prefixedBuilder.assertAllWereCalled();
        standardBuilder.assertAllWereCalled();
    }

    public void testRemoveIsMultiplexed() throws OXException {
        CompositingFileStorage cStore = new CompositingFileStorage();
        SimBuilder prefixedBuilder = new SimBuilder();
        prefixedBuilder.expectCall("remove", new Object[0]);
        SimBuilder standardBuilder = new SimBuilder();
        standardBuilder.expectCall("remove", new Object[0]);
        cStore.addStore("hash", (FileStorage)prefixedBuilder.getSim(FileStorage.class, new Class[0]));
        cStore.addStore((FileStorage)standardBuilder.getSim(FileStorage.class, new Class[0]));
        cStore.remove();
        prefixedBuilder.assertAllWereCalled();
        standardBuilder.assertAllWereCalled();
    }

    public void testIsStateFileCorrect() throws OXException {
        CompositingFileStorage cStore = new CompositingFileStorage();
        SimBuilder prefixedBuilder = new SimBuilder();
        prefixedBuilder.expectCall("stateFileIsCorrect", new Object[0]).andReturn((Object)false);
        SimBuilder standardBuilder = new SimBuilder();
        standardBuilder.expectCall("stateFileIsCorrect", new Object[0]).andReturn((Object)true);
        cStore.addStore("hash", (FileStorage)prefixedBuilder.getSim(FileStorage.class, new Class[0]));
        cStore.addStore((FileStorage)standardBuilder.getSim(FileStorage.class, new Class[0]));
        boolean stateFileIsCorrect = cStore.stateFileIsCorrect();
        CompositingFileStorageTest.assertFalse((boolean)stateFileIsCorrect);
        prefixedBuilder.assertAllWereCalled();
        standardBuilder.assertAllWereCalled();
    }

    public void testIsStateFileCorrect2() throws OXException {
        CompositingFileStorage cStore = new CompositingFileStorage();
        SimBuilder prefixedBuilder = new SimBuilder();
        prefixedBuilder.expectCall("stateFileIsCorrect", new Object[0]).andReturn((Object)true);
        SimBuilder standardBuilder = new SimBuilder();
        standardBuilder.expectCall("stateFileIsCorrect", new Object[0]).andReturn((Object)true);
        cStore.addStore("hash", (FileStorage)prefixedBuilder.getSim(FileStorage.class, new Class[0]));
        cStore.addStore((FileStorage)standardBuilder.getSim(FileStorage.class, new Class[0]));
        boolean stateFileIsCorrect = cStore.stateFileIsCorrect();
        CompositingFileStorageTest.assertTrue((boolean)stateFileIsCorrect);
        prefixedBuilder.assertAllWereCalled();
        standardBuilder.assertAllWereCalled();
    }

    public void testRecreateStateFile() throws OXException {
        CompositingFileStorage cStore = new CompositingFileStorage();
        SimBuilder prefixedBuilder = new SimBuilder();
        prefixedBuilder.expectCall("recreateStateFile", new Object[0]);
        SimBuilder standardBuilder = new SimBuilder();
        standardBuilder.expectCall("recreateStateFile", new Object[0]);
        cStore.addStore("hash", (FileStorage)prefixedBuilder.getSim(FileStorage.class, new Class[0]));
        cStore.addStore((FileStorage)standardBuilder.getSim(FileStorage.class, new Class[0]));
        cStore.recreateStateFile();
        prefixedBuilder.assertAllWereCalled();
        standardBuilder.assertAllWereCalled();
    }

    private class SimFileStorage
    implements FileStorage {
        protected List<Object> remember = new ArrayList<Object>();

        private SimFileStorage() {
        }

        public boolean deleteFile(String identifier) throws OXException {
            return false;
        }

        public Set<String> deleteFiles(String[] identifiers) throws OXException {
            return null;
        }

        public InputStream getFile(String name) throws OXException {
            return null;
        }

        public SortedSet<String> getFileList() throws OXException {
            return null;
        }

        public long getFileSize(String name) throws OXException {
            return 0L;
        }

        public String getMimeType(String name) throws OXException {
            return null;
        }

        public void recreateStateFile() throws OXException {
        }

        public void remove() throws OXException {
        }

        public String saveNewFile(InputStream file) throws OXException {
            return null;
        }

        public boolean stateFileIsCorrect() throws OXException {
            return false;
        }

        protected void remember(Object o) {
            this.remember.add(o);
        }

        public List<Object> getMemory() {
            return this.remember;
        }

        public long appendToFile(InputStream file, String name, long offset) throws OXException {
            return 0L;
        }

        public void setFileLength(long length, String name) throws OXException {
        }

        public InputStream getFile(String name, long offset, long length) throws OXException {
            return null;
        }
    }
}

