/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.actions.GetAttachmentAction;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.strings.BasicTypesStringParser;
import com.openexchange.tools.strings.StringParser;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={GetAttachmentAction.class, AbstractMailAction.class, MailRequest.class})
public class GetAttachmentActionTest {
    @Test
    public void testReturnedContentTypeAndModifiedParameters() throws Exception {
        String folder = "default0/INBOX";
        String uid = "1";
        String attachmentId = "2";
        ServiceLookup serviceLookup = (ServiceLookup)PowerMockito.mock(ServiceLookup.class);
        ServerServiceRegistry.getInstance().addService(StringParser.class, (Object)new BasicTypesStringParser());
        AJAXRequestData ajaxRequestData = new AJAXRequestData();
        MailRequest mailRequest = (MailRequest)PowerMockito.mock(MailRequest.class);
        ((MailRequest)PowerMockito.doReturn((Object)folder).when((Object)mailRequest)).checkParameter("folder");
        ((MailRequest)PowerMockito.doReturn((Object)uid).when((Object)mailRequest)).checkParameter("id");
        ((MailRequest)PowerMockito.doReturn((Object)attachmentId).when((Object)mailRequest)).getParameter("attachment");
        ((MailRequest)PowerMockito.doReturn(null).when((Object)mailRequest)).getParameter("cid");
        ((MailRequest)PowerMockito.doReturn((Object)"0").when((Object)mailRequest)).getParameter("save");
        ((MailRequest)PowerMockito.doReturn((Object)"1").when((Object)mailRequest)).getParameter("filter");
        ((MailRequest)PowerMockito.doReturn((Object)ajaxRequestData).when((Object)mailRequest)).getRequest();
        MimeType2ExtMap.addMimeType((String)"image/jpg", (String)"jpg");
        String filename = "I_am_a_filename_for_an_image.jpg";
        MailPart mailPart = (MailPart)PowerMockito.mock(MailPart.class);
        PowerMockito.when((Object)mailPart.getFileName()).thenReturn((Object)filename);
        ContentType ct = new ContentType("image/jpeg");
        ct.addParameter("name", filename);
        PowerMockito.when((Object)mailPart.getContentType()).thenReturn((Object)ct);
        MailServletInterface mailServletInterface = (MailServletInterface)PowerMockito.mock(MailServletInterface.class);
        ((MailServletInterface)PowerMockito.doReturn((Object)mailPart).when((Object)mailServletInterface)).getMessageAttachment(folder, uid, attachmentId, true);
        GetAttachmentAction action = (GetAttachmentAction)PowerMockito.spy((Object)new GetAttachmentAction(serviceLookup));
        ((GetAttachmentAction)PowerMockito.doReturn((Object)mailServletInterface).when((Object)action)).getMailInterface(mailRequest);
        AJAXRequestResult result = action.perform(mailRequest);
        Object object = result.getResultObject();
        Assert.assertEquals((String)"Wrong format", (Object)"file", (Object)ajaxRequestData.getFormat());
        Assert.assertEquals((String)"Wrong caching value", (Object)false, (Object)ajaxRequestData.getParameter("cache", Boolean.TYPE));
        Assert.assertTrue((String)"Wrong class", (boolean)IFileHolder.class.isInstance(object));
        Assert.assertEquals((String)"Wrong content type", (Object)"image/jpeg", (Object)((IFileHolder)object).getContentType());
    }

    @Test
    public void testProperlyDetectedInvalidHtmlContent() throws Exception {
        String folder = "default0/INBOX";
        String uid = "1";
        String attachmentId = "2";
        ServiceLookup serviceLookup = (ServiceLookup)PowerMockito.mock(ServiceLookup.class);
        ServerServiceRegistry.getInstance().addService(StringParser.class, (Object)new BasicTypesStringParser());
        AJAXRequestData ajaxRequestData = new AJAXRequestData();
        MailRequest mailRequest = (MailRequest)PowerMockito.mock(MailRequest.class);
        ((MailRequest)PowerMockito.doReturn((Object)folder).when((Object)mailRequest)).checkParameter("folder");
        ((MailRequest)PowerMockito.doReturn((Object)uid).when((Object)mailRequest)).checkParameter("id");
        ((MailRequest)PowerMockito.doReturn((Object)attachmentId).when((Object)mailRequest)).getParameter("attachment");
        ((MailRequest)PowerMockito.doReturn(null).when((Object)mailRequest)).getParameter("cid");
        ((MailRequest)PowerMockito.doReturn((Object)"0").when((Object)mailRequest)).getParameter("save");
        ((MailRequest)PowerMockito.doReturn((Object)"1").when((Object)mailRequest)).getParameter("filter");
        ((MailRequest)PowerMockito.doReturn((Object)ajaxRequestData).when((Object)mailRequest)).getRequest();
        MimeType2ExtMap.addMimeType((String)"application/pdf", (String)"pdf");
        String filename = "I_am_a_filename_for_a_pdf.pdf";
        MailPart mailPart = (MailPart)PowerMockito.mock(MailPart.class);
        PowerMockito.when((Object)mailPart.getFileName()).thenReturn((Object)filename);
        ContentType ct = new ContentType("text/html; charset=ISO-8859-1; name=" + filename);
        PowerMockito.when((Object)mailPart.getContentType()).thenReturn((Object)ct);
        MailServletInterface mailServletInterface = (MailServletInterface)PowerMockito.mock(MailServletInterface.class);
        ((MailServletInterface)PowerMockito.doReturn((Object)mailPart).when((Object)mailServletInterface)).getMessageAttachment(folder, uid, attachmentId, true);
        GetAttachmentAction action = (GetAttachmentAction)PowerMockito.spy((Object)new GetAttachmentAction(serviceLookup));
        ((GetAttachmentAction)PowerMockito.doReturn((Object)mailServletInterface).when((Object)action)).getMailInterface(mailRequest);
        AJAXRequestResult result = action.perform(mailRequest);
        Object object = result.getResultObject();
        Assert.assertEquals((String)"Wrong format", (Object)"file", (Object)ajaxRequestData.getFormat());
        Assert.assertEquals((String)"Wrong caching value", (Object)false, (Object)ajaxRequestData.getParameter("cache", Boolean.TYPE));
        Assert.assertTrue((String)"Wrong class", (boolean)IFileHolder.class.isInstance(object));
        Assert.assertEquals((String)"Wrong content type", (Object)"text/html", (Object)((IFileHolder)object).getContentType());
    }

    @Test
    public void testProperlyDetectedNonHtmlBinary() throws Exception {
        String folder = "default0/INBOX";
        String uid = "1";
        String attachmentId = "2";
        ServiceLookup serviceLookup = (ServiceLookup)PowerMockito.mock(ServiceLookup.class);
        ServerServiceRegistry.getInstance().addService(StringParser.class, (Object)new BasicTypesStringParser());
        AJAXRequestData ajaxRequestData = new AJAXRequestData();
        MailRequest mailRequest = (MailRequest)PowerMockito.mock(MailRequest.class);
        ((MailRequest)PowerMockito.doReturn((Object)folder).when((Object)mailRequest)).checkParameter("folder");
        ((MailRequest)PowerMockito.doReturn((Object)uid).when((Object)mailRequest)).checkParameter("id");
        ((MailRequest)PowerMockito.doReturn((Object)attachmentId).when((Object)mailRequest)).getParameter("attachment");
        ((MailRequest)PowerMockito.doReturn(null).when((Object)mailRequest)).getParameter("cid");
        ((MailRequest)PowerMockito.doReturn((Object)"0").when((Object)mailRequest)).getParameter("save");
        ((MailRequest)PowerMockito.doReturn((Object)"1").when((Object)mailRequest)).getParameter("filter");
        ((MailRequest)PowerMockito.doReturn((Object)ajaxRequestData).when((Object)mailRequest)).getRequest();
        MimeType2ExtMap.addMimeType((String)"application/pdf", (String)"pdf");
        Object filename = null;
        MailPart mailPart = (MailPart)PowerMockito.mock(MailPart.class);
        PowerMockito.when((Object)mailPart.getFileName()).thenReturn(filename);
        ContentType ct = new ContentType("application/pdf");
        PowerMockito.when((Object)mailPart.getContentType()).thenReturn((Object)ct);
        MailServletInterface mailServletInterface = (MailServletInterface)PowerMockito.mock(MailServletInterface.class);
        ((MailServletInterface)PowerMockito.doReturn((Object)mailPart).when((Object)mailServletInterface)).getMessageAttachment(folder, uid, attachmentId, true);
        GetAttachmentAction action = (GetAttachmentAction)PowerMockito.spy((Object)new GetAttachmentAction(serviceLookup));
        ((GetAttachmentAction)PowerMockito.doReturn((Object)mailServletInterface).when((Object)action)).getMailInterface(mailRequest);
        AJAXRequestResult result = action.perform(mailRequest);
        Object object = result.getResultObject();
        Assert.assertEquals((String)"Wrong format", (Object)"file", (Object)ajaxRequestData.getFormat());
        Assert.assertEquals((String)"Wrong caching value", (Object)false, (Object)ajaxRequestData.getParameter("cache", Boolean.TYPE));
        Assert.assertTrue((String)"Wrong class", (boolean)IFileHolder.class.isInstance(object));
        Assert.assertEquals((String)"Wrong content type", (Object)"application/pdf", (Object)((IFileHolder)object).getContentType());
    }
}

