/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.customizer.folder;

import com.openexchange.ajax.customizer.folder.AdditionalFolderField;
import com.openexchange.ajax.customizer.folder.AdditionalFolderFieldList;
import com.openexchange.ajax.customizer.folder.SimFolderField;
import junit.framework.TestCase;

public class AdditionalFolderFieldListTest
extends TestCase {
    private SimFolderField field;
    private SimFolderField field2;
    private AdditionalFolderFieldList fields;

    protected void setUp() throws Exception {
        super.setUp();
        this.field = new SimFolderField();
        this.field.setColumnId(12);
        this.field.setColumnName("someField");
        this.field.setJsonValue("jsonValue");
        this.field.setValue("someValue");
        this.field2 = new SimFolderField();
        this.field2.setColumnId(13);
        this.field2.setColumnName("someOtherField");
        this.field2.setJsonValue("otherJsonValue");
        this.field2.setValue("someOtherValue");
        this.fields = new AdditionalFolderFieldList();
        this.fields.addField((AdditionalFolderField)this.field);
        this.fields.addField((AdditionalFolderField)this.field2);
    }

    public void testLookup() {
        AdditionalFolderFieldListTest.assertEquals((Object)this.field, (Object)this.fields.get(12));
        AdditionalFolderFieldListTest.assertEquals((Object)this.field2, (Object)this.fields.get(13));
        AdditionalFolderFieldListTest.assertEquals((Object)this.field, (Object)this.fields.get("someField"));
        AdditionalFolderFieldListTest.assertEquals((Object)this.field2, (Object)this.fields.get("someOtherField"));
    }

    public void testColumnIDCollision() {
        SimFolderField collision = new SimFolderField();
        collision.setColumnId(this.field.getColumnID());
        this.fields.addField((AdditionalFolderField)collision);
        AdditionalFolderFieldListTest.assertEquals((Object)this.field, (Object)this.fields.get(12));
    }

    public void testColumnNameCollision() {
        SimFolderField collision = new SimFolderField();
        collision.setColumnName(this.field.getColumnName());
        this.fields.addField((AdditionalFolderField)collision);
        AdditionalFolderFieldListTest.assertEquals((Object)this.field, (Object)this.fields.get("someField"));
    }

    public void testKnows() {
        AdditionalFolderFieldListTest.assertTrue((boolean)this.fields.knows(12));
        AdditionalFolderFieldListTest.assertTrue((boolean)this.fields.knows("someField"));
        AdditionalFolderFieldListTest.assertFalse((boolean)this.fields.knows(23));
        AdditionalFolderFieldListTest.assertFalse((boolean)this.fields.knows("someUnknownField"));
    }

    public void testRemove() {
        this.fields.remove(12);
        AdditionalFolderFieldListTest.assertFalse((boolean)this.fields.knows(12));
    }

    public void testNullField() {
        AdditionalFolderField field3 = this.fields.get(23);
        AdditionalFolderFieldListTest.assertNotNull((Object)field3);
        AdditionalFolderFieldListTest.assertEquals(null, (Object)field3.getValue(null, null));
        AdditionalFolderFieldListTest.assertEquals(null, (Object)field3.renderJSON(null));
    }
}

