/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.login.LoginTools;
import junit.framework.TestCase;

public class LoginAddFragmentTest
extends TestCase {
    public LoginAddFragmentTest(String name) {
        super(name);
    }

    public void assertFragment(String original, String expected) {
        LoginAddFragmentTest.assertEquals((String)expected, (String)new TestLogin().addFragmentParam(original, "session", "abcd"));
    }

    public void testSimple() {
        this.assertFragment("http://www.open-xchange.com/index.html", "http://www.open-xchange.com/index.html#session=abcd");
    }

    public void testEnhanceExistingFragment() {
        this.assertFragment("http://www.open-xchange.com/index.html#f=12&i=23", "http://www.open-xchange.com/index.html#f=12&i=23&session=abcd");
    }

    public void testDelimitedByQuestionMark() {
        this.assertFragment("http://www.open-xchange.com/index.html#f=12&i=23?someParam=someValue", "http://www.open-xchange.com/index.html#f=12&i=23&session=abcd?someParam=someValue");
    }

    private static final class TestLogin
    extends LoginServlet {
        private TestLogin() {
        }

        public String addFragmentParam(String url, String param, String value) {
            return LoginTools.addFragmentParameter((String)url, (String)param, (String)value);
        }
    }
}

