/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.publish.json;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.FormElement;
import com.openexchange.exception.OXException;
import com.openexchange.json.JSONAssertion;
import com.openexchange.publish.Publication;
import com.openexchange.publish.PublicationTarget;
import com.openexchange.publish.json.PublicationWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PublicationWriterTest
extends TestCase {
    private Publication publication;

    protected void setUp() throws Exception {
        super.setUp();
        PublicationTarget target = new PublicationTarget();
        target.setId("com.openexchange.publish.test");
        DynamicFormDescription form = new DynamicFormDescription();
        form.add(FormElement.input((String)"siteName", (String)"Site Name")).add(FormElement.checkbox((String)"protected", (String)"Protected"));
        target.setFormDescription(form);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("siteName", "publication");
        config.put("protected", true);
        this.publication = new Publication();
        this.publication.setId(23);
        this.publication.setEntityId("12");
        this.publication.setModule("oranges");
        this.publication.setTarget(target);
        this.publication.setConfiguration(config);
        this.publication.setDisplayName("myName");
        this.publication.setEnabled(true);
    }

    public void testWriteObject() throws JSONException, OXException {
        PublicationWriter writer = new PublicationWriter();
        JSONObject object = writer.write(this.publication, null, TimeZone.getTimeZone("utc"));
        JSONAssertion assertion = new JSONAssertion().hasKey("id").withValue((Object)23).hasKey("entity").withValueObject().hasKey("folder").withValue((Object)"12").objectEnds().hasKey("enabled").withValue((Object)true).hasKey("entityModule").withValue((Object)"oranges").hasKey("target").withValue((Object)"com.openexchange.publish.test").hasKey("displayName").withValue((Object)"myName").hasKey("com.openexchange.publish.test").withValueObject().hasKey("siteName").withValue((Object)"publication").hasKey("protected").withValue((Object)true).objectEnds().objectEnds();
        JSONAssertion.assertValidates((JSONAssertion)assertion, (Object)object);
    }

    public void testWriteArray() throws JSONException, OXException {
        HashMap<String, String[]> specialCols = new HashMap<String, String[]>();
        String[] basicCols = new String[]{"id", "target", "displayName", "enabled"};
        specialCols.put("com.openexchange.publish.test", new String[]{"siteName"});
        JSONArray array = new PublicationWriter().writeArray(this.publication, basicCols, specialCols, Arrays.asList("com.openexchange.publish.test"), this.publication.getTarget().getFormDescription(), TimeZone.getTimeZone("utc"));
        JSONAssertion assertion = new JSONAssertion().isArray().withValues(new Object[]{23, "com.openexchange.publish.test", "myName", true, "publication"});
        JSONAssertion.assertValidates((JSONAssertion)assertion, (Object)array);
    }

    public void testThrowsExceptionOnUnknownColumn() {
        try {
            new PublicationWriter().writeArray(this.publication, new String[]{"id", "unknownColumn"}, new HashMap(), Arrays.asList("com.openexchange.publish.test"), this.publication.getTarget().getFormDescription(), TimeZone.getTimeZone("utc"));
            PublicationWriterTest.fail((String)"Should have failed");
        }
        catch (OXException e) {
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

