/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.java.Strings;
import com.openexchange.java.util.Pair;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionUtils.class);

    public static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            String marker = " ---=== /!\\ ===--- ";
            LOG.error("{}Thread death{}", new Object[]{marker, marker, t});
            throw (ThreadDeath)t;
        }
        if (t instanceof OutOfMemoryError) {
            OutOfMemoryError oom = (OutOfMemoryError)t;
            ExceptionUtils.handleOOM(oom);
            throw oom;
        }
        if (t instanceof VirtualMachineError) {
            String marker = " ---=== /!\\ ===--- ";
            LOG.error("{}The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating.{}", new Object[]{marker, marker, t});
            throw (VirtualMachineError)t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleOOM(OutOfMemoryError oom) {
        block16: {
            String message = oom.getMessage();
            if ("unable to create new native thread".equalsIgnoreCase(message)) {
                if (!Boolean.TRUE.equals(System.getProperties().get("__thread_dump_created"))) {
                    System.getProperties().put("__thread_dump_created", Boolean.TRUE);
                    boolean error = true;
                    try {
                        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
                        String ls = Strings.getLineSeparator();
                        LOG.info("{}Threads: {}", (Object)ls, (Object)threads.size());
                        StringBuilder sb = new StringBuilder(2048);
                        for (Map.Entry<Thread, StackTraceElement[]> mapEntry : threads.entrySet()) {
                            Thread thread = mapEntry.getKey();
                            sb.setLength(0);
                            sb.append("        Thread: ").append(thread).append(" java.lang.Thread.State: ").append(thread.getState().name()).append(ls);
                            for (StackTraceElement elem : mapEntry.getValue()) {
                                sb.append(elem).append(ls);
                            }
                            LOG.info(sb.toString());
                        }
                        sb = null;
                        LOG.info("{}    Thread dump finished{}", (Object)ls, (Object)ls);
                        error = false;
                    }
                    finally {
                        if (error) {
                            System.getProperties().remove("__thread_dump_created");
                        }
                    }
                }
            } else if ("Java heap space".equalsIgnoreCase(message)) {
                try {
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    Pair<Boolean, String> heapDumpArgs = ExceptionUtils.checkHeapDumpArguments();
                    if (((Boolean)heapDumpArgs.getFirst()).booleanValue() || Boolean.TRUE.equals(System.getProperties().get("__heap_dump_created"))) break block16;
                    System.getProperties().put("__heap_dump_created", Boolean.TRUE);
                    boolean error = true;
                    try {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-hh:mm:ss", Locale.US);
                        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                        String path = null == heapDumpArgs.getSecond() ? "/tmp" : (String)heapDumpArgs.getSecond();
                        String fn = path + "/" + dateFormat.format(new Date()) + "-heap.hprof";
                        String mbeanName = "com.sun.management:type=HotSpotDiagnostic";
                        server.invoke(new ObjectName(mbeanName), "dumpHeap", new Object[]{fn, Boolean.TRUE}, new String[]{String.class.getCanonicalName(), "boolean"});
                        LOG.info("{}    Heap snapshot dumped to file {}{}", new Object[]{Strings.getLineSeparator(), fn, Strings.getLineSeparator()});
                        error = false;
                    }
                    finally {
                        if (error) {
                            System.getProperties().remove("__heap_dump_created");
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        String marker = " ---=== /!\\ ===--- ";
        LOG.error("{}The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating.{}", new Object[]{marker, marker, oom});
    }

    public static Throwable truncateThrowable(Throwable t) {
        int threshold;
        if (null == t) {
            return t;
        }
        StackTraceElement[] stackTrace = t.getStackTrace();
        int length = stackTrace.length;
        if (length <= (threshold = 20)) {
            return t;
        }
        LinkedList<StackTraceElement> truncatedStackTrace = new LinkedList<StackTraceElement>();
        for (int i = 0; i < length; ++i) {
            if (i <= threshold) {
                truncatedStackTrace.add(stackTrace[i]);
                continue;
            }
            String prefix = "com.openexchange.http.grizzly.service.http";
            String className = stackTrace[i].getClassName();
            if (className.startsWith(prefix)) continue;
            truncatedStackTrace.add(stackTrace[i]);
        }
        FastThrowable ft = new FastThrowable(t.getMessage(), t.getCause());
        ft.setStackTrace(truncatedStackTrace.toArray(new StackTraceElement[truncatedStackTrace.size()]));
        return ft;
    }

    private static Pair<Boolean, String> checkHeapDumpArguments() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        boolean heapDumpOnOOm = false;
        String path = null;
        for (String argument : arguments) {
            File file;
            if ("-XX:+HeapDumpOnOutOfMemoryError".equals(argument)) {
                heapDumpOnOOm = true;
                continue;
            }
            if (!argument.startsWith("-XX:HeapDumpPath=") || (file = new File(path = argument.substring(17).trim())).exists() && file.canWrite()) continue;
            path = null;
        }
        return new Pair((Object)heapDumpOnOOm, path);
    }

    static final class FastThrowable
    extends Throwable {
        FastThrowable(String message, Throwable cause) {
            super(null == message ? "<unknkown>" : message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

