/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.meta.internal;

import com.openexchange.ajax.meta.MetaContributor;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.java.util.Pair;
import com.openexchange.session.Session;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaContributorReference
implements MetaContributor {
    private static final Logger LOG = LoggerFactory.getLogger(MetaContributorReference.class);
    private final ServiceReference<MetaContributor> reference;
    private final BundleContext context;
    private MetaContributor contributor;
    private String[] topics;

    public MetaContributorReference(ServiceReference<MetaContributor> reference, BundleContext context) {
        this.reference = reference;
        this.context = context;
    }

    @Override
    public void contributeTo(Map<String, Object> meta, String id, Session session) throws OXException {
        this.doContribution(meta, id, session);
    }

    public synchronized boolean init() {
        this.topics = null;
        Object o = this.reference.getProperty("contributor.topics");
        if (o instanceof String) {
            this.topics = new String[]{(String)o};
        } else if (o instanceof String[]) {
            this.topics = (String[])o;
        } else if (o instanceof Collection) {
            try {
                Collection c = (Collection)o;
                this.topics = c.toArray(new String[c.size()]);
            }
            catch (ArrayStoreException e) {
                LOG.error("Invalid event contributor topics", (Throwable)e);
            }
        }
        return this.topics != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        MetaContributorReference metaContributorReference = this;
        synchronized (metaContributorReference) {
            if (this.contributor == null) {
                return;
            }
            this.contributor = null;
        }
        try {
            this.context.ungetService(this.reference);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public synchronized String[] getTopics() {
        return this.topics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaContributor getContributor() {
        MetaContributorReference metaContributorReference = this;
        synchronized (metaContributorReference) {
            if (this.contributor != null) {
                return this.contributor;
            }
        }
        MetaContributor tempHandler = null;
        try {
            tempHandler = (MetaContributor)this.context.getService(this.reference);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        MetaContributorReference e = this;
        synchronized (e) {
            if (this.contributor == null) {
                this.contributor = tempHandler;
                return this.contributor;
            }
            tempHandler = this.contributor;
        }
        try {
            this.context.ungetService(this.reference);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return tempHandler;
    }

    public void doContribution(Map<String, Object> meta, String id, Session session) {
        Bundle bundle = this.reference.getBundle();
        if (bundle == null) {
            return;
        }
        MetaContributor contributor = this.getContributor();
        if (contributor == null) {
            return;
        }
        try {
            contributor.contributeTo(meta, id, session);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
            LOG.error("Entity contribution failed", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            String marker = " ---=== /!\\ ===--- ";
            LOG.error("{}Thread death{}", new Object[]{marker, marker, t});
            throw (ThreadDeath)t;
        }
        if (t instanceof OutOfMemoryError) {
            OutOfMemoryError oom;
            block19: {
                oom = (OutOfMemoryError)t;
                String message = oom.getMessage();
                if ("unable to create new native thread".equalsIgnoreCase(message)) {
                    if (!Boolean.TRUE.equals(System.getProperties().get("__thread_dump_created"))) {
                        System.getProperties().put("__thread_dump_created", Boolean.TRUE);
                        boolean error = true;
                        try {
                            Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
                            String ls = Strings.getLineSeparator();
                            LOG.info("{}Threads: {}", (Object)ls, (Object)threads.size());
                            StringBuilder sb = new StringBuilder(2048);
                            for (Map.Entry<Thread, StackTraceElement[]> mapEntry : threads.entrySet()) {
                                Thread thread = mapEntry.getKey();
                                sb.setLength(0);
                                sb.append("        Thread: ").append(thread).append(" java.lang.Thread.State: ").append(thread.getState().name()).append(ls);
                                for (StackTraceElement elem : mapEntry.getValue()) {
                                    sb.append(elem).append(ls);
                                }
                                LOG.info(sb.toString());
                            }
                            sb = null;
                            LOG.info("{}    Thread dump finished{}", (Object)ls, (Object)ls);
                            error = false;
                        }
                        finally {
                            if (error) {
                                System.getProperties().remove("__thread_dump_created");
                            }
                        }
                    }
                } else if ("Java heap space".equalsIgnoreCase(message)) {
                    try {
                        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                        Pair<Boolean, String> heapDumpArgs = MetaContributorReference.checkHeapDumpArguments();
                        if (((Boolean)heapDumpArgs.getFirst()).booleanValue() || Boolean.TRUE.equals(System.getProperties().get("__heap_dump_created"))) break block19;
                        System.getProperties().put("__heap_dump_created", Boolean.TRUE);
                        boolean error = true;
                        try {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-hh:mm:ss", Locale.US);
                            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                            String path = null == heapDumpArgs.getSecond() ? "/tmp" : (String)heapDumpArgs.getSecond();
                            String fn = path + "/" + dateFormat.format(new Date()) + "-heap.hprof";
                            String mbeanName = "com.sun.management:type=HotSpotDiagnostic";
                            server.invoke(new ObjectName(mbeanName), "dumpHeap", new Object[]{fn, Boolean.TRUE}, new String[]{String.class.getCanonicalName(), "boolean"});
                            LOG.info("{}    Heap snapshot dumped to file {}{}", new Object[]{Strings.getLineSeparator(), fn, Strings.getLineSeparator()});
                            error = false;
                        }
                        finally {
                            if (error) {
                                System.getProperties().remove("__heap_dump_created");
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            String marker = " ---=== /!\\ ===--- ";
            LOG.error("{}The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating.{}", new Object[]{marker, marker, t});
            throw oom;
        }
        if (t instanceof VirtualMachineError) {
            String marker = " ---=== /!\\ ===--- ";
            LOG.error("{}The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating.{}", new Object[]{marker, marker, t});
            throw (VirtualMachineError)t;
        }
    }

    private static Pair<Boolean, String> checkHeapDumpArguments() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        boolean heapDumpOnOOm = false;
        String path = null;
        for (String argument : arguments) {
            File file;
            if ("-XX:+HeapDumpOnOutOfMemoryError".equals(argument)) {
                heapDumpOnOOm = true;
                continue;
            }
            if (!argument.startsWith("-XX:HeapDumpPath=") || (file = new File(path = argument.substring(17).trim())).exists() && file.canWrite()) continue;
            path = null;
        }
        return new Pair((Object)heapDumpOnOOm, path);
    }
}

