/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.search;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.search.ComparablePattern;
import com.openexchange.file.storage.search.SearchTerm;
import com.openexchange.file.storage.search.SearchTermVisitor;
import java.util.Collection;

public final class NumberOfVersionsTerm
implements SearchTerm<ComparablePattern<Number>> {
    private final ComparablePattern<Number> pattern;

    public NumberOfVersionsTerm(ComparablePattern<Number> pattern) {
        this.pattern = pattern;
    }

    @Override
    public ComparablePattern<Number> getPattern() {
        return this.pattern;
    }

    @Override
    public void visit(SearchTermVisitor visitor) throws OXException {
        if (null != visitor) {
            visitor.visit(this);
        }
    }

    @Override
    public void addField(Collection<File.Field> col) {
        if (null != col) {
            col.add(File.Field.NUMBER_OF_VERSIONS);
        }
    }

    @Override
    public boolean matches(File file) throws OXException {
        int numberOfVersions = file.getNumberOfVersions();
        switch (this.pattern.getComparisonType()) {
            case EQUALS: {
                return numberOfVersions == this.pattern.getPattern().intValue();
            }
            case LESS_THAN: {
                return numberOfVersions < this.pattern.getPattern().intValue();
            }
            case GREATER_THAN: {
                return numberOfVersions > this.pattern.getPattern().intValue();
            }
        }
        return false;
    }
}

