/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.java.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FileStorageUtility {
    private static final Pattern IS_NUMBERED_WITH_EXTENSION = Pattern.compile("\\(\\d+\\)\\.");
    private static final Pattern IS_NUMBERED = Pattern.compile("\\(\\d+\\)$");

    private FileStorageUtility() {
    }

    public static String getETagFor(File fileMetadata) {
        return FileStorageUtility.getETagFor(fileMetadata.getId(), fileMetadata.getVersion(), fileMetadata.getLastModified());
    }

    public static String getETagFor(String id, String version, Date lastModified) {
        StringBuilder sb = new StringBuilder("http://www.open-xchange.com/infostore");
        if (null != id) {
            sb.append('/').append(id);
        }
        if (null != version) {
            sb.append('/').append(version);
        }
        if (null != lastModified) {
            sb.append('/').append(lastModified.getTime());
        }
        return sb.toString();
    }

    public static void checkUrl(File file) throws OXException {
        FileStorageUtility.checkUrl(file.getURL());
    }

    public static void checkUrl(String sUrl) throws OXException {
        if (Strings.isEmpty((String)sUrl)) {
            return;
        }
        try {
            URL url = new URL(sUrl);
            String protocol = url.getProtocol();
            if (!"http".equals(protocol) && !"https".equals(protocol)) {
                throw new MalformedURLException("Only http & https protocols supported.");
            }
        }
        catch (MalformedURLException e) {
            throw FileStorageExceptionCodes.INVALID_URL.create(e, sUrl, e.getMessage());
        }
    }

    public static String enhance(String filename, int counter) {
        if (null == filename) {
            return filename;
        }
        String counterString = '(' + String.valueOf(counter) + ')';
        Matcher matcher = IS_NUMBERED_WITH_EXTENSION.matcher(filename);
        if (matcher.find()) {
            return new StringBuilder(filename).replace(matcher.start(), matcher.end() - 1, counterString).toString();
        }
        matcher = IS_NUMBERED.matcher(filename);
        if (matcher.find()) {
            return new StringBuilder(filename).replace(matcher.start(), matcher.end(), counterString).toString();
        }
        int index = filename.lastIndexOf(46);
        if (0 >= index) {
            index = filename.length();
        }
        return new StringBuilder(filename).insert(index, ' ' + counterString).toString();
    }
}

